/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry;

import java.util.concurrent.TimeUnit;

public class Backoff {
    private final long maxBackoffTimeMs;
    private final long backoffFactorMs;
    private final int maxRetries;
    private int numRetries = 0;

    private Backoff(Builder builder) {
        this.maxBackoffTimeMs = builder.maxBackoffTimeMs;
        this.backoffFactorMs = builder.backoffFactorMs;
        this.maxRetries = builder.maxRetries;
    }

    public static Backoff defaultBackoff() {
        return Backoff.builder().maxBackoff(15, TimeUnit.SECONDS).backoffFactor(1, TimeUnit.SECONDS).maxRetries(10).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public long nextWaitMs() {
        ++this.numRetries;
        int n = this.numRetries - 1;
        if (n == 0) {
            return 0L;
        }
        if (n >= this.maxRetries) {
            return -1L;
        }
        return (long)Math.min((double)this.maxBackoffTimeMs, (double)this.backoffFactorMs * Math.pow(2.0, n - 1));
    }

    public static class Builder {
        private long maxBackoffTimeMs;
        private long backoffFactorMs;
        private int maxRetries;

        public Builder maxBackoff(int backoff, TimeUnit unit) {
            this.maxBackoffTimeMs = unit.toMillis(backoff);
            return this;
        }

        public Builder backoffFactor(int backoffFactor, TimeUnit unit) {
            this.backoffFactorMs = unit.toMillis(backoffFactor);
            return this;
        }

        public Builder maxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public Backoff build() {
            return new Backoff(this);
        }
    }
}

