/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.toevent;

import com.newrelic.jfr.MethodSupport;
import com.newrelic.jfr.RecordedObjectValidators;
import com.newrelic.jfr.toevent.EventToEvent;
import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.events.Event;
import java.util.Collections;
import java.util.List;
import jdk.jfr.consumer.RecordedClass;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordedThread;

public class ValhallaVBCDetector
implements EventToEvent {
    public static final String SIMPLE_CLASS_NAME = ValhallaVBCDetector.class.getSimpleName();
    public static final String OLD_EVENT_NAME = "jdk.SyncOnPrimitiveWrapper";
    public static final String EVENT_NAME = "jdk.SyncOnValueBasedClass";
    public static final String BOX_CLASS = "boxClass";
    public static final String EVENT_THREAD = "eventThread";
    public static final String THREAD_NAME = "thread.name";
    public static final String STACK_TRACE = "stackTrace";
    public static final String JFR_VALHALLA_VBC_SYNC = "JfrValhallaVBCSync";

    @Override
    public String getEventName() {
        return EVENT_NAME;
    }

    @Override
    public boolean test(RecordedEvent event) {
        String name = event.getEventType().getName();
        return name.equalsIgnoreCase(EVENT_NAME) || name.equalsIgnoreCase(OLD_EVENT_NAME);
    }

    @Override
    public List<Event> apply(RecordedEvent event) {
        long timestamp = event.getStartTime().toEpochMilli();
        Attributes attr = new Attributes();
        RecordedThread eventThread = null;
        if (RecordedObjectValidators.hasField(event, EVENT_THREAD, SIMPLE_CLASS_NAME)) {
            eventThread = event.getThread(EVENT_THREAD);
        }
        RecordedClass boxClass = null;
        if (RecordedObjectValidators.hasField(event, BOX_CLASS, SIMPLE_CLASS_NAME)) {
            boxClass = event.getClass(BOX_CLASS);
        }
        attr.put(THREAD_NAME, eventThread == null ? null : eventThread.getJavaName());
        attr.put(BOX_CLASS, boxClass == null ? null : boxClass.getName());
        attr.put(STACK_TRACE, MethodSupport.serialize(event.getStackTrace()));
        return Collections.singletonList(new Event(JFR_VALHALLA_VBC_SYNC, attr, timestamp));
    }
}

