/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.toevent;

import com.newrelic.telemetry.Attributes;

public class AttributeValueSplitter {
    static final int MAX_LENGTH = 4096;
    static final String KEY_EXTENDED = "Extended_";

    void maybeSplit(Attributes attr, String key, String value) {
        int extendedCount = 0;
        while (value.length() > 4096) {
            String firstBlock = value.substring(0, 4096);
            attr.put(this.incrementKey(extendedCount, key), firstBlock);
            value = value.substring(4096);
            ++extendedCount;
        }
        attr.put(this.incrementKey(extendedCount, key), value);
    }

    String incrementKey(int extendedCount, String key) {
        return extendedCount == 0 ? key : key + KEY_EXTENDED + extendedCount;
    }
}

