/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.profiler;

import java.util.Collections;
import java.util.List;

public final class JvmStackTraceEvent {
    private final String threadName;
    private final String threadState;
    private final List<JvmStackFrame> frames;

    public JvmStackTraceEvent(String threadName, String threadState, List<JvmStackFrame> frames) {
        this.threadName = threadName;
        this.threadState = threadState;
        this.frames = Collections.unmodifiableList(frames);
    }

    public String getThreadName() {
        return this.threadName;
    }

    public String getThreadState() {
        return this.threadState;
    }

    public List<JvmStackFrame> getFrames() {
        return this.frames;
    }

    public String toString() {
        return "JvmStackTraceEvent{threadName='" + this.threadName + '\'' + ", threadState='" + this.threadState + '\'' + ", frames=" + this.frames + '}';
    }

    public static final class JvmStackFrame {
        private final String desc;
        private final int line;
        private final int bytecodeIndex;

        public JvmStackFrame(String desc, int line, int bytecodeIndex) {
            this.desc = desc;
            this.line = line;
            this.bytecodeIndex = bytecodeIndex;
        }

        public String getDesc() {
            return this.desc;
        }

        public int getLine() {
            return this.line;
        }

        public int getBytecodeIndex() {
            return this.bytecodeIndex;
        }
    }
}

