/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EditableFile {
    String filePath;
    String fileAsString;
    public final String comment;
    static final String lineSep = System.getProperty("line.separator");

    public EditableFile(String filestr) throws NullPointerException, FileNotFoundException, IOException {
        if (filestr == null || filestr.equals("")) {
            throw new NullPointerException("A null or empty string can't become an EditableFile.");
        }
        this.filePath = filestr;
        File file = new File(this.filePath);
        if (!file.exists()) {
            throw new FileNotFoundException("File " + this.filePath + " does not exist, so it can't become an EditableFile.");
        }
        StringBuilder sb = new StringBuilder();
        try {
            String str;
            BufferedReader in = new BufferedReader(new FileReader(this.filePath));
            while ((str = in.readLine()) != null) {
                sb.append(str + lineSep);
            }
            in.close();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.getMessage();
            fnfe.printStackTrace();
            throw new FileNotFoundException("Couldn't create EditableFile due to FileNotFoundException");
        }
        catch (IOException e) {
            e.getMessage();
            e.printStackTrace();
            throw new IOException("Couldn't create EditableFile due to IOException");
        }
        this.fileAsString = sb.toString();
        this.comment = this.filePath.endsWith(".bat") ? "::" : (this.filePath.endsWith(".java") ? "//" : "#");
    }

    public String getContents() {
        return this.fileAsString;
    }

    public String getLocation() {
        return this.filePath;
    }

    public boolean contains(String regex) {
        Pattern p;
        Matcher m4;
        return this.fileAsString != null && (m4 = (p = Pattern.compile(regex, 8)).matcher(this.fileAsString)).find();
    }

    public String replaceFirst(String regex, String replacement) {
        return this.replaceFirst(regex, replacement, true);
    }

    public String replaceFirst(String regex, String replacement, boolean isMultiLine) {
        Pattern p = isMultiLine ? Pattern.compile(regex, 8) : Pattern.compile(regex);
        Matcher m4 = p.matcher(this.fileAsString);
        this.fileAsString = m4.replaceFirst(replacement);
        this.write();
        return this.fileAsString;
    }

    public String replaceAll(String regex, String replacement) {
        return this.replaceAll(regex, replacement, true);
    }

    public String replaceAll(String regex, String replacement, boolean isMultiLine) {
        Pattern p = isMultiLine ? Pattern.compile(regex, 8) : Pattern.compile(regex);
        Matcher m4 = p.matcher(this.fileAsString);
        this.fileAsString = m4.replaceAll(replacement);
        this.write();
        return this.fileAsString;
    }

    public String insertBeforeLocator(String regex, String textToInsert, boolean isMultiLine) {
        this.fileAsString = this.replaceFirst("(" + regex + ")", textToInsert + lineSep + "$1", isMultiLine);
        this.write();
        return this.fileAsString;
    }

    public String insertAfterLocator(String regex, String textToInsert, boolean isMultiLine) {
        this.fileAsString = this.replaceFirst("(" + regex + ")", "$1" + lineSep + textToInsert, isMultiLine);
        this.write();
        return this.fileAsString;
    }

    public void commentOutFirstLineMatching(String regex) {
        this.replaceFirst("(" + regex + ")", this.comment + "$1");
    }

    public void commentOutAllLinesMatching(String regex) {
        this.replaceAll("(" + regex + ")", this.comment + "$1");
    }

    public void append(String text) {
        this.fileAsString = this.fileAsString + lineSep + text;
        this.write();
    }

    public String backup() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd_HHmmss");
        String filename = this.filePath + "." + df.format(new Date());
        if (this.write(filename)) {
            return filename;
        }
        return "";
    }

    private boolean write() {
        return this.write(this.filePath);
    }

    private boolean write(String pathToFile) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(pathToFile));
            out.write(this.fileAsString);
            out.close();
            return true;
        }
        catch (IOException e) {
            System.out.println("Problem writing file to disk");
            e.getMessage();
            e.printStackTrace();
            return false;
        }
    }
}

