/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracing;

import com.newrelic.agent.deps.com.google.common.base.Joiner;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracing.ParentType;
import com.newrelic.agent.tracing.Sampled;
import com.newrelic.agent.tracing.VendorStateResult;
import com.newrelic.agent.tracing.W3CTraceState;
import com.newrelic.api.agent.NewRelic;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class W3CTraceStateSupport {
    private static final String SINGLE_TENANT_VENDOR_STATE_KEY = "[a-z][_0-9a-z\\-*/]{0,255}";
    private static final String VENDOR_STATE_KEY = "([a-z][_0-9a-z\\-*/]{0,255}|[a-z0-9][_0-9a-z\\-*/]{0,240}@[a-z][_0-9a-z\\-*/]{0,13})";
    private static final String VENDOR_STATE_VALUE = "[\\x20-\\x2b\\x2d-\\x3c\\x3e-\\x7e]{0,255}[\\x21-\\x2b\\x2d-\\x3c\\x3e-\\x7e]";
    private static final Pattern VENDOR_STATE_PATTERN = Pattern.compile("^([a-z][_0-9a-z\\-*/]{0,255}|[a-z0-9][_0-9a-z\\-*/]{0,240}@[a-z][_0-9a-z\\-*/]{0,13})=[\\x20-\\x2b\\x2d-\\x3c\\x3e-\\x7e]{0,255}[\\x21-\\x2b\\x2d-\\x3c\\x3e-\\x7e]$");
    static final int NR_HEADER_VERSION_INT = 0;
    public static final String W3C_TRACE_STATE_VENDOR_DELIMITER = ",";
    private static final int MAX_VENDOR_STATE_SIZE = 31;
    private static final int LONG_VENDOR_STATE_SIZE = 128;

    static W3CTraceState parseHeaders(List<String> traceStateHeaders) {
        long timestamp;
        Float priority;
        if (traceStateHeaders == null || traceStateHeaders.isEmpty()) {
            NewRelic.incrementCounter((String)"Supportability/TraceContext/TraceState/Ignored/Empty");
            return null;
        }
        String agentTrustKey = ServiceFactory.getDistributedTraceService().getTrustKey();
        VendorStateResult vendorStateResult = W3CTraceStateSupport.flattenVendorStatesAndExtractNrState(traceStateHeaders, agentTrustKey);
        List<String> vendorStates = vendorStateResult.getVendorStates();
        String nrState = vendorStateResult.getNrState();
        W3CTraceState traceState = new W3CTraceState(traceStateHeaders, vendorStates);
        if (nrState == null) {
            NewRelic.incrementCounter((String)"Supportability/TraceContext/TraceState/NoNrEntry");
            return traceState;
        }
        String[] trustKeyAndFields = nrState.split("@nr=");
        if (trustKeyAndFields.length != 2) {
            NewRelic.incrementCounter((String)"Supportability/TraceContext/TraceState/InvalidNrEntry");
            return traceState;
        }
        String trustKey = trustKeyAndFields[0];
        boolean isTrustedAccountKey = agentTrustKey.equals(trustKey);
        if (!isTrustedAccountKey) {
            NewRelic.incrementCounter((String)"Supportability/TraceContext/TraceState/Ignored/UntrustedAccount");
            return traceState;
        }
        String[] traceFields = trustKeyAndFields[1].split("-", 10);
        if (traceFields.length < 9) {
            NewRelic.incrementCounter((String)"Supportability/TraceContext/TraceState/InvalidNrEntry");
            return traceState;
        }
        if (traceFields[0].isEmpty()) {
            NewRelic.incrementCounter((String)"Supportability/TraceContext/TraceState/InvalidNrEntry");
            return traceState;
        }
        int version = Integer.parseInt(traceFields[0]);
        if (version < 0) {
            NewRelic.incrementCounter((String)"Supportability/TraceContext/TraceState/InvalidNrEntry");
            return traceState;
        }
        if (traceFields[1].isEmpty()) {
            NewRelic.incrementCounter((String)"Supportability/TraceContext/TraceState/InvalidNrEntry");
            return traceState;
        }
        ParentType parentType = ParentType.getParentTypeFromValue(Integer.parseInt(traceFields[1]));
        if (parentType == null || parentType.value < ParentType.App.value || parentType.value > ParentType.Mobile.value) {
            NewRelic.incrementCounter((String)"Supportability/TraceContext/TraceState/InvalidNrEntry");
            return traceState;
        }
        String accountId = traceFields[2];
        if (accountId.isEmpty()) {
            NewRelic.incrementCounter((String)"Supportability/TraceContext/TraceState/InvalidNrEntry");
            return traceState;
        }
        String applicationId = traceFields[3];
        if (applicationId.isEmpty()) {
            NewRelic.incrementCounter((String)"Supportability/TraceContext/TraceState/InvalidNrEntry");
            return traceState;
        }
        Sampled sampled = Sampled.parse(traceFields[6]);
        try {
            priority = !traceFields[7].isEmpty() ? Float.valueOf(Float.parseFloat(traceFields[7])) : null;
        }
        catch (NumberFormatException ignored) {
            priority = null;
        }
        String guid = traceFields[4];
        String txnId = !traceFields[5].isEmpty() ? traceFields[5] : null;
        String unparsedTimestamp = traceFields[8];
        if (unparsedTimestamp.isEmpty()) {
            NewRelic.incrementCounter((String)"Supportability/TraceContext/TraceState/InvalidNrEntry");
            return traceState;
        }
        try {
            timestamp = Long.parseLong(unparsedTimestamp);
        }
        catch (NumberFormatException ignored) {
            return traceState;
        }
        return new W3CTraceState(traceStateHeaders, vendorStates, true, version, trustKey, parentType, accountId, applicationId, guid, txnId, sampled, priority, timestamp);
    }

    static List<String> truncateVendorStates(List<String> vendorStates) {
        if (vendorStates.size() <= 31) {
            return vendorStates;
        }
        NewRelic.incrementCounter((String)"Supportability/TraceContext/TraceState/Ignored/InvalidVendorCount");
        int longTraceStatesToKeep = W3CTraceStateSupport.countLongStatesToKeep(vendorStates);
        return W3CTraceStateSupport.truncateVendorStates(vendorStates, longTraceStatesToKeep);
    }

    private static List<String> truncateVendorStates(List<String> vendorStates, int longTraceStatesToKeep) {
        ArrayList<String> newStates = new ArrayList<String>(31);
        for (String vendor : vendorStates) {
            if (vendor.length() <= 128) {
                newStates.add(vendor);
            } else if (longTraceStatesToKeep > 0) {
                newStates.add(vendor);
                --longTraceStatesToKeep;
            }
            if (newStates.size() < 31) continue;
            return newStates;
        }
        return newStates;
    }

    private static int countLongStatesToKeep(List<String> vendorStates) {
        int numberOfLongStates = 0;
        for (String vendorState : vendorStates) {
            if (vendorState.length() <= 128) continue;
            ++numberOfLongStates;
        }
        return 31 - (vendorStates.size() - numberOfLongStates);
    }

    private static VendorStateResult flattenVendorStatesAndExtractNrState(List<String> traceStateHeaders, String agentTrustKey) {
        LinkedList<String> vendorStates = new LinkedList<String>();
        String nrState = null;
        for (String header : traceStateHeaders) {
            String[] splitVendors;
            for (String vendor : splitVendors = header.split(W3C_TRACE_STATE_VENDOR_DELIMITER)) {
                String trimmedVendor = vendor.trim();
                if (trimmedVendor.isEmpty()) continue;
                if (trimmedVendor.contains("@nr=") && trimmedVendor.startsWith(agentTrustKey + "@nr=")) {
                    nrState = trimmedVendor;
                    continue;
                }
                vendorStates.add(trimmedVendor);
            }
        }
        List<String> vendorKeys = W3CTraceStateSupport.vendorStatesToVendorKeys(vendorStates);
        if (W3CTraceStateSupport.containsDuplicates(vendorKeys) || W3CTraceStateSupport.anyVendorStateIsInvalid(vendorStates)) {
            return new VendorStateResult(Collections.emptyList(), nrState);
        }
        return new VendorStateResult(vendorStates, nrState);
    }

    static String concatenateVendorStates(List<String> vendorStates) {
        return Joiner.on(W3C_TRACE_STATE_VENDOR_DELIMITER).join(vendorStates);
    }

    public static Set<String> buildVendorKeys(W3CTraceState state) {
        List<String> vendorStates = state.getVendorStates();
        List<String> vendorKeys = W3CTraceStateSupport.vendorStatesToVendorKeys(vendorStates);
        if (W3CTraceStateSupport.containsDuplicates(vendorKeys) || W3CTraceStateSupport.anyVendorStateIsInvalid(vendorStates)) {
            return Collections.emptySet();
        }
        return new LinkedHashSet<String>(vendorKeys);
    }

    private static List<String> vendorStatesToVendorKeys(List<String> vendorStates) {
        LinkedList<String> vendorKeys = new LinkedList<String>();
        for (String vendorState : vendorStates) {
            String vendorKey = vendorState.split("=")[0];
            vendorKeys.add(vendorKey);
        }
        return vendorKeys;
    }

    private static boolean containsDuplicates(List<String> list) {
        HashSet<String> set = new HashSet<String>(list);
        return set.size() != list.size();
    }

    private static boolean anyVendorStateIsInvalid(List<String> vendorStates) {
        for (String vendorState : vendorStates) {
            if (VENDOR_STATE_PATTERN.matcher(vendorState).matches()) continue;
            return true;
        }
        return false;
    }
}

