/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracing;

import com.newrelic.agent.deps.com.google.common.annotations.VisibleForTesting;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class W3CTraceParentValidator {
    private static final String INVALID_VERSION = "ff";
    private static final String INVALID_TRACE_ID = "00000000000000000000000000000000";
    private static final String INVALID_PARENT_ID = "0000000000000000";
    private static final Pattern HEXADECIMAL_PATTERN = Pattern.compile("\\p{XDigit}+");
    private final String traceParentHeader;
    private final String version;
    private final String traceId;
    private final String parentId;
    private final String flags;

    private W3CTraceParentValidator(Builder builder) {
        this.traceParentHeader = builder.traceParentHeader;
        this.version = builder.version;
        this.traceId = builder.traceId;
        this.parentId = builder.parentId;
        this.flags = builder.flags;
    }

    private boolean isValid() {
        return this.isValidVersion() && this.isValidTraceId() && this.isValidParentId() && this.isValidFlags();
    }

    boolean isValidVersion() {
        return this.version.length() == 2 && this.isHexadecimal(this.version.charAt(0)) && this.isHexadecimal(this.version.charAt(1)) && !this.version.equals(INVALID_VERSION) && (!this.version.equals("00") || !this.traceParentHeaderLengthIsInvalid());
    }

    private boolean traceParentHeaderLengthIsInvalid() {
        return this.traceParentHeader.length() != 55;
    }

    boolean isHexadecimal(char character) {
        return Character.digit(character, 16) != -1;
    }

    boolean isHexadecimal(String input) {
        Matcher matcher = HEXADECIMAL_PATTERN.matcher(input);
        return matcher.matches();
    }

    boolean isValidTraceId() {
        return this.traceId.length() == 32 && !this.traceId.equals(INVALID_TRACE_ID) && this.isHexadecimal(this.traceId);
    }

    boolean isValidParentId() {
        return this.parentId.length() == 16 && !this.parentId.equals(INVALID_PARENT_ID) && this.isHexadecimal(this.parentId);
    }

    boolean isValidFlags() {
        return this.flags.length() == 2 && this.isHexadecimal(this.flags);
    }

    static Builder forHeader(String traceParentHeader) {
        return new Builder(traceParentHeader);
    }

    static class Builder {
        private final String traceParentHeader;
        private String version;
        private String traceId;
        private String parentId;
        private String flags;

        Builder(String traceParentHeader) {
            this.traceParentHeader = traceParentHeader;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder traceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        public Builder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        public Builder flags(String flags) {
            this.flags = flags;
            return this;
        }

        @VisibleForTesting
        W3CTraceParentValidator build() {
            return new W3CTraceParentValidator(this);
        }

        public boolean isValid() {
            return this.build().isValid();
        }
    }
}

