/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.json;

import com.newrelic.agent.model.AttributeFilter;
import com.newrelic.agent.service.ServiceFactory;
import java.util.Collections;
import java.util.Map;

public class BasicAttributeFilter
implements AttributeFilter {
    private final GetMapStrategy strategy;

    public BasicAttributeFilter(GetMapStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public boolean shouldIncludeAgentAttribute(String appName, String attributeName) {
        return this.strategy.shouldIncludeAttribute(appName, attributeName);
    }

    @Override
    public Map<String, ?> filterAgentAttributes(String appName, Map<String, ?> agentAttributes) {
        return this.strategy.getFilteredMap(appName, agentAttributes);
    }

    @Override
    public Map<String, ?> filterUserAttributes(String appName, Map<String, ?> userAttributes) {
        if (!ServiceFactory.getConfigService().getDefaultAgentConfig().isHighSecurity()) {
            return this.strategy.getFilteredMap(appName, userAttributes);
        }
        return Collections.emptyMap();
    }

    static interface GetMapStrategy {
        public Map<String, ?> getFilteredMap(String var1, Map<String, ?> var2);

        public boolean shouldIncludeAttribute(String var1, String var2);
    }
}

