/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.weaver;

import com.newrelic.agent.Agent;
import com.newrelic.agent.InstrumentationProxy;
import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.config.ClassTransformerConfig;
import com.newrelic.agent.config.IBMUtils;
import com.newrelic.agent.deps.com.google.common.collect.ImmutableSet;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.deps.org.objectweb.asm.tree.ClassNode;
import com.newrelic.agent.instrumentation.ClassLoaderClassFinder;
import com.newrelic.agent.instrumentation.builtin.AgentClassLoaderBaseInstrumentation;
import com.newrelic.agent.instrumentation.builtin.AgentClassLoaderInstrumentation;
import com.newrelic.agent.instrumentation.builtin.ClassLoaderPackageAccessInstrumentation;
import com.newrelic.agent.instrumentation.classmatchers.OptimizedClassMatcher;
import com.newrelic.agent.instrumentation.context.ClassMatchVisitorFactory;
import com.newrelic.agent.instrumentation.context.ContextClassTransformer;
import com.newrelic.agent.instrumentation.context.InstrumentationContext;
import com.newrelic.agent.instrumentation.weaver.errorhandler.LogAndReturnOriginal;
import com.newrelic.agent.instrumentation.weaver.extension.CaffeineBackedExtensionClass;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.weave.utils.BootstrapLoader;
import com.newrelic.weave.utils.ClassCache;
import com.newrelic.weave.utils.Streams;
import com.newrelic.weave.utils.WeaveUtils;
import com.newrelic.weave.violation.WeaveViolation;
import com.newrelic.weave.weavepackage.ExtensionClassTemplate;
import com.newrelic.weave.weavepackage.NewClassAppender;
import com.newrelic.weave.weavepackage.PackageValidationResult;
import com.newrelic.weave.weavepackage.PackageWeaveResult;
import com.newrelic.weave.weavepackage.WeavePackage;
import com.newrelic.weave.weavepackage.WeavePackageConfig;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;

public class ClassLoaderClassTransformer
implements ClassMatchVisitorFactory,
ContextClassTransformer,
ClassFileTransformer {
    private static final String agentClassloaderName = Type.getType(AgentBridge.getAgent().getClass().getClassLoader().getClass()).getInternalName();
    private final Set<String> classloadersToSkip;
    private final Set<String> classloadersToInclude;
    private final Instrumentation instrumentation;
    private final WeavePackage classloaderBasePackage;
    private final WeavePackage classloaderPackage;
    private final WeavePackage checkPackageAccessPackage;
    private final Map<String, byte[]> observedClassLoaders = new ConcurrentHashMap<String, byte[]>();
    private ClassNode extensionTemplate;

    public ClassLoaderClassTransformer(InstrumentationProxy instrumentation, Set<String> classloaderDelegationExcludes, Set<String> classloaderDelegationIncludes) {
        this.classloadersToSkip = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add("com/ibm/oti/vm/BootstrapClassLoader")).add("jdk/internal/loader/BuiltinClassLoader")).add("sun/reflect/misc/MethodUtil")).add(agentClassloaderName)).addAll(classloaderDelegationExcludes)).build();
        this.classloadersToInclude = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add("org/jboss/modules/NamedClassLoader")).add("org/jboss/modules/ConcurrentClassLoader")).add("org/jboss/modules/ModuleClassLoader")).addAll(classloaderDelegationIncludes)).build();
        AgentBridge.getAgent().getLogger().log(Level.FINER, "classloadersToSkip: {0}", this.classloadersToSkip);
        try {
            this.extensionTemplate = WeaveUtils.convertToClassNode(WeaveUtils.getClassBytesFromClassLoaderResource(CaffeineBackedExtensionClass.class.getName(), CaffeineBackedExtensionClass.class.getClassLoader()));
        }
        catch (Exception e) {
            AgentBridge.getAgent().getLogger().log(Level.WARNING, (Throwable)e, "Unable to initialize custom extension class template. Falling back to default java NewField implementation");
            this.extensionTemplate = ExtensionClassTemplate.DEFAULT_EXTENSION_TEMPLATE;
        }
        this.instrumentation = instrumentation;
        this.classloaderBasePackage = this.buildBaseClassLoaderPatcherPackage();
        this.classloaderPackage = this.buildClassLoaderPatcherPackage();
        this.checkPackageAccessPackage = this.buildCheckAccessPatcherPackage();
    }

    private WeavePackage buildBaseClassLoaderPatcherPackage() {
        WeavePackageConfig baseClassloaderPatcher = WeavePackageConfig.builder().name("base-agent-classloader-patcher").errorHandleClassNode(LogAndReturnOriginal.ERROR_HANDLER_NODE).extensionClassTemplate(this.extensionTemplate).build();
        ArrayList<byte[]> baseWeavePackageBytes = new ArrayList<byte[]>();
        try {
            byte[] baseClassloaderPatcherInstrumentationBytes = WeaveUtils.getClassBytesFromClassLoaderResource(AgentClassLoaderBaseInstrumentation.class.getName(), ClassLoaderClassTransformer.class.getClassLoader());
            baseWeavePackageBytes.add(baseClassloaderPatcherInstrumentationBytes);
        }
        catch (IOException e) {
            Agent.LOG.log(Level.FINE, e, "Unable to initialize agent classloader instrumentation");
        }
        return new WeavePackage(baseClassloaderPatcher, baseWeavePackageBytes);
    }

    private WeavePackage buildClassLoaderPatcherPackage() {
        WeavePackageConfig classloaderPatcher = WeavePackageConfig.builder().name("agent-classloader-patcher").errorHandleClassNode(LogAndReturnOriginal.ERROR_HANDLER_NODE).extensionClassTemplate(this.extensionTemplate).build();
        ArrayList<byte[]> weavePackageBytes = new ArrayList<byte[]>();
        try {
            byte[] classloaderPatcherInstrumentationBytes = WeaveUtils.getClassBytesFromClassLoaderResource(AgentClassLoaderInstrumentation.class.getName(), ClassLoaderClassTransformer.class.getClassLoader());
            weavePackageBytes.add(classloaderPatcherInstrumentationBytes);
        }
        catch (IOException e) {
            Agent.LOG.log(Level.FINE, e, "Unable to initialize agent classloader instrumentation");
        }
        return new WeavePackage(classloaderPatcher, weavePackageBytes);
    }

    private WeavePackage buildCheckAccessPatcherPackage() {
        WeavePackageConfig checkAccessPatcher = WeavePackageConfig.builder().name("check-access-patcher").errorHandleClassNode(LogAndReturnOriginal.ERROR_HANDLER_NODE).extensionClassTemplate(this.extensionTemplate).build();
        ArrayList<byte[]> checkAccessPackageBytes = new ArrayList<byte[]>();
        try {
            ClassTransformerConfig config;
            if (System.getSecurityManager() != null && (config = ServiceFactory.getConfigService().getDefaultAgentConfig().getClassTransformerConfig()).isGrantPackageAccess()) {
                byte[] classloaderPackageAccessInstrumentationBytes = WeaveUtils.getClassBytesFromClassLoaderResource(ClassLoaderPackageAccessInstrumentation.class.getName(), ClassLoaderClassTransformer.class.getClassLoader());
                checkAccessPackageBytes.add(classloaderPackageAccessInstrumentationBytes);
                return new WeavePackage(checkAccessPatcher, checkAccessPackageBytes);
            }
        }
        catch (IOException e) {
            Agent.LOG.log(Level.FINE, e, "Unable to initialize agent classloader instrumentation");
        }
        return null;
    }

    public void start(Class<?>[] loadedClasses) {
        this.instrumentation.addTransformer(this, true);
        ArrayList toRetransform = new ArrayList();
        for (Class<?> clazz : loadedClasses) {
            if (!ClassLoader.class.isAssignableFrom(clazz)) continue;
            try {
                byte[] classLoaderBytes = Streams.getClassBytes(clazz);
                if (classLoaderBytes == null) continue;
                this.observedClassLoaders.put(WeaveUtils.getClassInternalName(clazz.getName()), classLoaderBytes);
                String className = Type.getType(clazz).getInternalName();
                if (this.classloadersToSkip.contains(className) || className.equals("java/lang/ClassLoader")) continue;
                toRetransform.add(clazz);
            }
            catch (IOException e) {
                Agent.LOG.log(Level.FINE, e, "Unable to capture ClassLoader information for {0}", clazz.getName());
            }
        }
        if (!toRetransform.isEmpty()) {
            Agent.LOG.log(Level.FINER, "Retransforming {0}", ((Object)toRetransform).toString());
            for (Class clazz : toRetransform) {
                try {
                    this.instrumentation.retransformClasses(clazz);
                }
                catch (Throwable t2) {
                    Agent.LOG.log(Level.FINE, t2, "ClassLoaderClassTransformer: Error retransforming {0}", clazz.getName());
                }
            }
        }
        if (ServiceFactory.getConfigService().getDefaultAgentConfig().getIbmWorkaroundEnabled()) {
            Agent.LOG.log(Level.FINE, "ClassLoaderClassTransformer: skipping redefine of {0}. IBM SR {1}. java.runtime.version {2}", ClassLoader.class.getName(), IBMUtils.getIbmSRNumber(), System.getProperty("java.runtime.version"));
        } else {
            try {
                Agent.LOG.log(Level.FINER, "ClassLoaderClassTransformer: Attempting to redefine {0}", ClassLoader.class);
                InstrumentationProxy.forceRedefinition(this.instrumentation, ClassLoader.class);
            }
            catch (Exception e) {
                Agent.LOG.log(Level.FINEST, e, "ClassLoaderClassTransformer: Error redefining {0}", ClassLoader.class.getName());
            }
        }
    }

    @Override
    public ClassVisitor newClassMatchVisitor(ClassLoader loader, Class<?> classBeingRedefined, ClassReader reader, ClassVisitor cv, InstrumentationContext context) {
        String superName;
        String string = superName = reader.getClassName().equals("java/lang/ClassLoader") ? reader.getClassName() : reader.getSuperName();
        if (this.observedClassLoaders.containsKey(superName) || this.classloadersToInclude.contains(reader.getClassName()) || this.classloadersToInclude.contains(superName)) {
            context.putMatch(this, null);
        }
        return null;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        String superName;
        ClassReader reader = new ClassReader(classfileBuffer);
        String string = superName = reader.getClassName().equals("java/lang/ClassLoader") ? reader.getClassName() : reader.getSuperName();
        if (this.observedClassLoaders.containsKey(superName) || this.classloadersToInclude.contains(reader.getClassName()) || this.classloadersToInclude.contains(superName)) {
            return this.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer, null, null);
        }
        return null;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer, InstrumentationContext context, OptimizedClassMatcher.Match match) throws IllegalClassFormatException {
        if (this.classloadersToSkip.contains(className)) {
            Agent.LOG.log(Level.FINEST, "ClassLoaderClassTransformer: classloadersToSkip contains {0}", className);
            return null;
        }
        if (!this.observedClassLoaders.containsKey(className)) {
            this.observedClassLoaders.put(className, classfileBuffer);
        }
        try {
            if (loader == null) {
                loader = BootstrapLoader.PLACEHOLDER;
            }
            Agent.LOG.log(Level.FINER, "ClassLoaderClassTransformer transforming: {0} -- {1}", loader, className);
            ClassCache cache = new ClassCache(new ClassLoaderClassFinder(this.observedClassLoaders));
            PackageValidationResult result = className.equals("java/lang/ClassLoader") ? this.classloaderPackage.validate(cache) : this.classloaderBasePackage.validate(cache);
            if (result.succeeded()) {
                PackageWeaveResult packageWeaveResult;
                Map<String, byte[]> utilityClassBytes = result.computeUtilityClassBytes(cache);
                if (utilityClassBytes != null && !utilityClassBytes.isEmpty()) {
                    NewClassAppender.appendClassesToBootstrapClassLoader(this.instrumentation, utilityClassBytes);
                }
                String[] superNames = className.equals("java/lang/ClassLoader") ? new String[]{} : new String[]{"java/lang/ClassLoader"};
                Map<Method, Collection<String>> skipMethods = context != null ? context.getSkipMethods() : Collections.emptyMap();
                byte[] newBytes = classfileBuffer;
                if (this.checkPackageAccessPackage != null && newBytes != null && className.equals("java/lang/ClassLoader")) {
                    PackageValidationResult checkPackageAccessResult = this.checkPackageAccessPackage.validate(cache);
                    if (checkPackageAccessResult.succeeded()) {
                        newBytes = checkPackageAccessResult.weave(className, superNames, new String[0], newBytes, cache, skipMethods).getCompositeBytes(cache);
                    } else {
                        this.logClassLoaderWeaveViolations(checkPackageAccessResult, className);
                    }
                    if (newBytes == null) {
                        newBytes = classfileBuffer;
                    }
                }
                if ((newBytes = (packageWeaveResult = result.weave(className, superNames, new String[0], newBytes, cache, skipMethods)).getCompositeBytes(cache)) != null) {
                    Agent.LOG.log(Level.FINE, "ClassLoaderClassTransformer patched {0} -- {1}", loader, className);
                    return newBytes;
                }
            } else {
                this.logClassLoaderWeaveViolations(result, className);
            }
        }
        catch (Throwable t2) {
            Agent.LOG.log(Level.FINE, t2, "ClassLoaderClassTransformer unable to instrument classloader {0} -- {1}", loader, className);
        }
        Agent.LOG.log(Level.FINE, "ClassLoaderClassTransformer skipped transformation: {0} -- {1}", loader, className);
        return null;
    }

    private void logClassLoaderWeaveViolations(PackageValidationResult result, String classLoaderClassName) {
        String weavePackageName = result.getWeavePackage().getName();
        List<WeaveViolation> violations = result.getViolations();
        Agent.LOG.log(Level.FINE, "{0} - {1} violations against classloader {2}", weavePackageName, violations.size(), classLoaderClassName);
        for (WeaveViolation violation : violations) {
            Agent.LOG.log(Level.FINE, "WeaveViolation: {0}", violation.getType().name());
            Agent.LOG.log(Level.FINE, "\t\tClass: {0}", violation.getClazz());
            if (violation.getMethod() != null) {
                Agent.LOG.log(Level.FINE, "\t\tMethod: {0}", violation.getMethod());
            }
            if (violation.getField() != null) {
                Agent.LOG.log(Level.FINE, "\t\tField: {0}", violation.getField());
            }
            Agent.LOG.log(Level.FINE, "\t\tReason: {0}", violation.getType().getMessage());
        }
    }
}

