/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.tracing;

import com.newrelic.agent.Agent;
import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.bridge.Instrumentation;
import com.newrelic.agent.bridge.TracedMethod;
import com.newrelic.agent.bridge.Transaction;
import com.newrelic.agent.bridge.TransactionNamePriority;
import com.newrelic.agent.deps.com.google.common.base.Joiner;
import com.newrelic.agent.deps.org.objectweb.asm.Label;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.AdviceAdapter;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.instrumentation.tracing.BridgeUtils;
import com.newrelic.agent.instrumentation.tracing.TraceDetails;
import com.newrelic.agent.instrumentation.tracing.TraceMethodVisitor;
import com.newrelic.agent.util.Strings;
import com.newrelic.agent.util.asm.BytecodeGenProxyBuilder;
import com.newrelic.agent.util.asm.Variables;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class FlyweightTraceMethodVisitor
extends AdviceAdapter {
    private static final Type JOINER_TYPE = Type.getType(Joiner.class);
    final Map<Method, Handler> tracedMethodMethodHandlers;
    private final Method method;
    private final int startTimeLocal;
    private final Label startFinallyLabel;
    private final TraceDetails traceDetails;
    private final String className;
    private final int parentTracerLocal;
    private final int metricNameLocal;
    private final int rollupMetricNamesCacheId;
    private static final Type THROWABLE_TYPE = Type.getType(Throwable.class);

    public FlyweightTraceMethodVisitor(String className, MethodVisitor mv, int access, String name, String desc, TraceDetails trace, Class<?> classBeingRedefined) {
        super(589824, mv, access, name, desc);
        this.className = className.replace('/', '.');
        this.method = new Method(name, desc);
        this.startFinallyLabel = new Label();
        this.startTimeLocal = this.newLocal(Type.LONG_TYPE);
        this.parentTracerLocal = this.newLocal(BridgeUtils.TRACED_METHOD_TYPE);
        this.metricNameLocal = this.newLocal(Type.getType(String.class));
        this.rollupMetricNamesCacheId = trace.rollupMetricName().length > 0 ? AgentBridge.instrumentation.addToObjectCache((Object)trace.rollupMetricName()) : -1;
        this.traceDetails = trace;
        this.tracedMethodMethodHandlers = this.getTracedMethodMethodHandlers();
    }

    private Map<Method, Handler> getTracedMethodMethodHandlers() {
        HashMap<Method, Handler> map = new HashMap<Method, Handler>();
        map.put(new Method("getMetricName", "()Ljava/lang/String;"), new Handler(){

            @Override
            public void handle(AdviceAdapter mv) {
                mv.loadLocal(FlyweightTraceMethodVisitor.this.metricNameLocal);
            }
        });
        map.put(new Method("setMetricName", "([Ljava/lang/String;)V"), new Handler(){

            @Override
            public void handle(AdviceAdapter mv) {
                mv.checkCast(Type.getType(Object[].class));
                FlyweightTraceMethodVisitor.this.push("");
                mv.invokeStatic(JOINER_TYPE, new Method("on", JOINER_TYPE, new Type[]{Type.getType(String.class)}));
                mv.swap();
                mv.invokeVirtual(JOINER_TYPE, new Method("join", Type.getType(String.class), new Type[]{Type.getType(Object[].class)}));
                mv.storeLocal(FlyweightTraceMethodVisitor.this.metricNameLocal);
            }
        });
        this.addUnsupportedMethod(map, new Method("nameTransaction", Type.VOID_TYPE, new Type[]{Type.getType(TransactionNamePriority.class)}));
        this.addUnsupportedMethod(map, new Method("setRollupMetricNames", "([Ljava/lang/String;)V"));
        this.addUnsupportedMethod(map, new Method("addRollupMetricName", "([Ljava/lang/String;)V"));
        this.addUnsupportedMethod(map, new Method("setMetricNameFormatInfo", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V"));
        this.addUnsupportedMethod(map, new Method("addExclusiveRollupMetricName", "([Ljava/lang/String;)V"));
        this.addUnsupportedMethod(map, new Method("isMetricProducer", "()Z"));
        this.addUnsupportedMethod(map, new Method("setCustomMetricPrefix", "(Ljava/lang/String;)V"));
        this.addUnsupportedMethod(map, new Method("setTrackChildThreads", "(Z)V"));
        this.addUnsupportedMethod(map, new Method("trackChildThreads", "()Z"));
        this.addUnsupportedMethod(map, new Method("setTrackCallbackRunnable", "(Z)V"));
        this.addUnsupportedMethod(map, new Method("isTrackCallbackRunnable", "()Z"));
        this.addUnsupportedMethod(map, new Method("reportAsDatastore", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V"));
        this.addUnsupportedMethod(map, new Method("addOutboundRequestHeaders", "(Lcom/newrelic/api/agent/OutboundHeaders;)V"));
        this.addUnsupportedMethod(map, new Method("readInboundResponseHeaders", "(Lcom/newrelic/api/agent/InboundHeaders;)V"));
        this.addUnsupportedMethod(map, new Method("reportAsExternal", "(Lcom/newrelic/agent/bridge/external/ExternalParameters;)V"));
        this.addUnsupportedMethod(map, new Method("reportAsExternal", "(Lcom/newrelic/api/agent/ExternalParameters;)V"));
        this.addUnsupportedMethod(map, new Method("addCustomAttribute", "(Ljava/lang/String;Ljava/lang/String;)V"));
        this.addUnsupportedMethod(map, new Method("addCustomAttribute", "(Ljava/lang/String;Ljava/lang/Number;)V"));
        this.addUnsupportedMethod(map, new Method("addCustomAttribute", "(Ljava/lang/String;Z)V"));
        this.addUnsupportedMethod(map, new Method("addCustomAttributes", "(Ljava/util/Map;)V"));
        map.put(new Method("getParentTracedMethod", "()Lcom/newrelic/agent/bridge/TracedMethod;"), new Handler(){

            @Override
            public void handle(AdviceAdapter mv) {
                mv.loadLocal(FlyweightTraceMethodVisitor.this.parentTracerLocal);
            }
        });
        return map;
    }

    private void addUnsupportedMethod(Map<Method, Handler> map, Method method) {
        map.put(method, new UnsupportedHandler(method));
    }

    @Override
    protected void onMethodEnter() {
        super.onMethodEnter();
        this.push(0L);
        super.storeLocal(this.startTimeLocal, Type.LONG_TYPE);
        this.visitInsn(1);
        super.storeLocal(this.parentTracerLocal, BridgeUtils.TRACED_METHOD_TYPE);
        this.visitInsn(1);
        super.storeLocal(this.metricNameLocal);
        Label start = new Label();
        Label end = new Label();
        this.visitLabel(start);
        BridgeUtils.getCurrentTransactionOrNull(this);
        super.ifNull(end);
        super.invokeStatic(Type.getType(System.class), new Method("nanoTime", Type.LONG_TYPE, new Type[0]));
        super.storeLocal(this.startTimeLocal, Type.LONG_TYPE);
        BridgeUtils.getCurrentTransaction(this);
        Transaction transactionApi = BytecodeGenProxyBuilder.newBuilder(Transaction.class, this, true).build();
        transactionApi.startFlyweightTracer();
        super.storeLocal(this.parentTracerLocal, BridgeUtils.TRACED_METHOD_TYPE);
        String fullMetricName = this.traceDetails.getFullMetricName(this.className, this.method.getName());
        if (fullMetricName == null) {
            fullMetricName = Strings.join('/', "Java", this.className, this.method.getName());
        }
        this.push(fullMetricName);
        super.storeLocal(this.metricNameLocal);
        this.goTo(end);
        Label handler = new Label();
        this.visitLabel(handler);
        this.pop();
        this.visitLabel(end);
        this.visitTryCatchBlock(start, end, handler, TraceMethodVisitor.THROWABLE_TYPE.getInternalName());
        super.visitLabel(this.startFinallyLabel);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        Label endFinallyLabel = new Label();
        super.visitTryCatchBlock(this.startFinallyLabel, endFinallyLabel, endFinallyLabel, THROWABLE_TYPE.getInternalName());
        super.visitLabel(endFinallyLabel);
        this.onEveryExit();
        super.visitInsn(191);
        super.visitMaxs(maxStack, maxLocals);
    }

    @Override
    protected void onMethodExit(int opcode) {
        if (opcode != 191) {
            this.onEveryExit();
        }
    }

    private void onEveryExit() {
        Label skip = super.newLabel();
        super.loadLocal(this.parentTracerLocal);
        super.ifNull(skip);
        BridgeUtils.getCurrentTransactionOrNull(this);
        super.ifNull(skip);
        BridgeUtils.getCurrentTransaction(this);
        BytecodeGenProxyBuilder<Transaction> builder = BytecodeGenProxyBuilder.newBuilder(Transaction.class, this, true);
        Variables loader = builder.getVariables();
        String[] rollupMetricNames = this.rollupMetricNamesCacheId >= 0 ? loader.load(String[].class, new Runnable(){

            @Override
            public void run() {
                FlyweightTraceMethodVisitor.this.getStatic(BridgeUtils.AGENT_BRIDGE_TYPE, "instrumentation", BridgeUtils.INSTRUMENTATION_TYPE);
                BytecodeGenProxyBuilder.newBuilder(Instrumentation.class, FlyweightTraceMethodVisitor.this, true).build().getCachedObject(FlyweightTraceMethodVisitor.this.rollupMetricNamesCacheId);
                FlyweightTraceMethodVisitor.this.checkCast(Type.getType(String[].class));
            }
        }) : null;
        long startTime = loader.loadLocal(this.startTimeLocal, Type.LONG_TYPE, -1L);
        long loadEndTime = loader.load(-2L, new Runnable(){

            @Override
            public void run() {
                FlyweightTraceMethodVisitor.this.invokeStatic(Type.getType(System.class), new Method("nanoTime", Type.LONG_TYPE, new Type[0]));
            }
        });
        Transaction transactionApi = builder.build();
        transactionApi.finishFlyweightTracer(loader.loadLocal(this.parentTracerLocal, TracedMethod.class), startTime, loadEndTime, this.className, this.method.getName(), this.methodDesc, loader.loadLocal(this.metricNameLocal, String.class), rollupMetricNames);
        super.visitLabel(skip);
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        if (!owner.equals(BridgeUtils.TRACED_METHOD_TYPE.getInternalName())) {
            super.visitFieldInsn(opcode, owner, name, desc);
        }
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (BridgeUtils.isAgentType(owner) && "getTracedMethod".equals(name)) {
            this.pop();
        } else if (BridgeUtils.isTracedMethodType(owner)) {
            Method method = new Method(name, desc);
            Handler handler = this.tracedMethodMethodHandlers.get(method);
            if (handler != null) {
                handler.handle(this);
            }
        } else {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }
    }

    private static class UnsupportedHandler
    implements Handler {
        private final Method method;

        public UnsupportedHandler(Method method) {
            this.method = method;
        }

        @Override
        public void handle(AdviceAdapter mv) {
            Agent.LOG.log(Level.FINER, "{0}.{1} is unsupported in flyweight tracers", TracedMethod.class.getSimpleName(), this.method);
        }
    }

    private static interface Handler {
        public void handle(AdviceAdapter var1);
    }
}

