/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.frameworks.spring;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.bridge.TransactionNamePriority;
import com.newrelic.agent.instrumentation.PointCutClassTransformer;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.instrumentation.pointcuts.frameworks.spring.SpringPointCut;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DefaultTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.metricname.ClassMethodMetricNameFormat;
import com.newrelic.agent.tracers.metricname.SimpleMetricNameFormat;
import com.newrelic.agent.transaction.TransactionNamingPolicy;
import java.text.MessageFormat;
import java.util.logging.Level;

@PointCut
public class SpringDispatcherPointCut
extends TracerFactoryPointCut {
    static final String DISPATCHER_SERVLET_CLASS_NAME = "org/springframework/web/servlet/DispatcherServlet";
    private static final String RENDER_METHOD_NAME = "render";

    public SpringDispatcherPointCut(PointCutClassTransformer classTransformer) {
        super(SpringDispatcherPointCut.class, (ClassMatcher)new ExactClassMatcher(DISPATCHER_SERVLET_CLASS_NAME), SpringDispatcherPointCut.createMethodMatcher(new ExactMethodMatcher(RENDER_METHOD_NAME, "(Lorg/springframework/web/servlet/ModelAndView;Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;)V"), new ExactMethodMatcher("doDispatch", "(Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;)V")));
    }

    @Override
    public Tracer doGetTracer(Transaction transaction, ClassMethodSignature sig, Object dispatcher, Object[] args2) {
        if (RENDER_METHOD_NAME == sig.getMethodName()) {
            StringBuilder metricName = new StringBuilder("SpringView");
            if (this.canSetTransactionName(transaction)) {
                try {
                    String viewName = SpringPointCut.getModelAndViewViewName(args2[0]);
                    if (viewName != null) {
                        metricName.append(viewName);
                    }
                }
                catch (Exception e) {
                    metricName.append("/Java/").append(dispatcher.getClass().getName()).append('/').append(sig.getMethodName());
                }
            } else {
                metricName.append("/Java/").append(dispatcher.getClass().getName()).append('/').append(sig.getMethodName());
            }
            return new DefaultTracer(transaction, sig, dispatcher, new SimpleMetricNameFormat(metricName.toString()));
        }
        return new DefaultTracer(transaction, sig, dispatcher, new ClassMethodMetricNameFormat(sig, dispatcher));
    }

    private boolean canSetTransactionName(Transaction transaction) {
        return TransactionNamingPolicy.getHigherPriorityTransactionNamingPolicy().canSetTransactionName(transaction, TransactionNamePriority.FRAMEWORK);
    }

    private void setTransactionName(Transaction transaction, String viewName) {
        if (!transaction.isTransactionNamingEnabled()) {
            return;
        }
        TransactionNamingPolicy policy = TransactionNamingPolicy.getHigherPriorityTransactionNamingPolicy();
        if (Agent.LOG.isLoggable(Level.FINER) && policy.canSetTransactionName(transaction, TransactionNamePriority.FRAMEWORK)) {
            String msg = MessageFormat.format("Setting transaction name to \"{0}\" using Spring view", viewName);
            Agent.LOG.finer(msg);
        }
        policy.setTransactionName(transaction, viewName, "SpringView", TransactionNamePriority.FRAMEWORK);
    }
}

