/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.errors;

import com.newrelic.agent.Agent;
import com.newrelic.agent.HarvestListener;
import com.newrelic.agent.Harvestable;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionActivity;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.TransactionErrorPriority;
import com.newrelic.agent.TransactionListener;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.AgentConfigListener;
import com.newrelic.agent.config.DistributedTracingConfig;
import com.newrelic.agent.config.ErrorCollectorConfig;
import com.newrelic.agent.config.StripExceptionConfig;
import com.newrelic.agent.deps.com.google.common.annotations.VisibleForTesting;
import com.newrelic.agent.errors.DeadlockTraceError;
import com.newrelic.agent.errors.ErrorAnalyzer;
import com.newrelic.agent.errors.ErrorAnalyzerImpl;
import com.newrelic.agent.errors.ErrorHarvestableImpl;
import com.newrelic.agent.errors.ErrorMessageReplacer;
import com.newrelic.agent.errors.ErrorService;
import com.newrelic.agent.errors.ExceptionHandlerPointCut;
import com.newrelic.agent.errors.ExceptionHandlerSignature;
import com.newrelic.agent.errors.HttpTracedError;
import com.newrelic.agent.errors.ReportableError;
import com.newrelic.agent.errors.ThrowableError;
import com.newrelic.agent.errors.TracedError;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.instrumentation.methodmatchers.InvalidMethodDescriptor;
import com.newrelic.agent.instrumentation.yaml.PointCutFactory;
import com.newrelic.agent.model.ErrorEvent;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.analytics.DistributedSamplingPriorityQueue;
import com.newrelic.agent.service.analytics.ErrorEventFactory;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.stats.StatsWork;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracing.DistributedTraceService;
import com.newrelic.agent.tracing.DistributedTraceServiceImpl;
import com.newrelic.agent.transport.HttpError;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.logging.Level;

public class ErrorServiceImpl
extends AbstractService
implements ErrorService,
HarvestListener {
    @VisibleForTesting
    static final int ERROR_LIMIT_PER_REPORTING_PERIOD = 20;
    @VisibleForTesting
    final AtomicInteger errorCountThisHarvest = new AtomicInteger();
    final AtomicInteger expectedErrorCountThisHarvest = new AtomicInteger();
    private final AtomicInteger errorCount = new AtomicInteger();
    private final AtomicLong totalErrorCount = new AtomicLong();
    private final AtomicReferenceArray<TracedError> tracedErrors;
    private final ConcurrentHashMap<String, DistributedSamplingPriorityQueue<ErrorEvent>> reservoirForApp = new ConcurrentHashMap();
    private volatile ErrorCollectorConfig errorCollectorConfig;
    private volatile ErrorMessageReplacer errorMessageReplacer;
    private volatile StripExceptionConfig stripExceptionConfig;
    private volatile ErrorAnalyzer errorAnalyzer;
    private final boolean shouldRecordErrorCount;
    private volatile int maxSamplesStored;
    private final String appName;
    protected Harvestable harvestable;

    public ErrorServiceImpl(String appName) {
        super(ErrorService.class.getSimpleName());
        this.appName = appName;
        this.errorCollectorConfig = ServiceFactory.getConfigService().getErrorCollectorConfig(appName);
        this.errorAnalyzer = new ErrorAnalyzerImpl(this.errorCollectorConfig);
        this.stripExceptionConfig = ServiceFactory.getConfigService().getStripExceptionConfig(appName);
        this.errorMessageReplacer = new ErrorMessageReplacer(this.stripExceptionConfig);
        this.tracedErrors = new AtomicReferenceArray(20);
        ServiceFactory.getTransactionService().addTransactionListener(new MyTransactionListener());
        ServiceFactory.getConfigService().addIAgentConfigListener(new MyConfigListener());
        this.shouldRecordErrorCount = !Boolean.getBoolean("com.newrelic.agent.errors.no_error_metric");
        this.maxSamplesStored = this.errorCollectorConfig.getMaxSamplesStored();
    }

    @Override
    protected void doStart() throws Exception {
        if (this.isEnabled()) {
            ServiceFactory.getHarvestService().addHarvestListener(this);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.errorCollectorConfig.isEnabled();
    }

    @Override
    protected void doStop() throws Exception {
        ServiceFactory.getHarvestService().removeHarvestable(this.harvestable);
    }

    @Override
    public void addHarvestableToService() {
        ErrorHarvestableImpl harvestableToAdd = new ErrorHarvestableImpl(this, this.appName);
        ServiceFactory.getHarvestService().addHarvestable(harvestableToAdd);
        this.harvestable = harvestableToAdd;
    }

    public ErrorCollectorConfig getErrorCollectorConfig() {
        return this.errorCollectorConfig;
    }

    @Override
    public int getMaxSamplesStored() {
        return this.maxSamplesStored;
    }

    @Override
    public void setMaxSamplesStored(int maxSamplesStored) {
        this.maxSamplesStored = maxSamplesStored;
    }

    @Override
    public void clearReservoir() {
        this.reservoirForApp.clear();
    }

    public void clearReservoir(String appName) {
        DistributedSamplingPriorityQueue<ErrorEvent> reservoir = this.reservoirForApp.get(appName);
        if (reservoir != null) {
            reservoir.clear();
        }
    }

    @VisibleForTesting
    public void setHarvestable(Harvestable harvestable) {
        this.harvestable = harvestable;
    }

    @Override
    public void harvestEvents(final String appName) {
        boolean eventsEnabled = this.isEventsEnabledForApp(appName);
        if (!eventsEnabled) {
            this.reservoirForApp.remove(appName);
            return;
        }
        if (this.maxSamplesStored <= 0) {
            this.clearReservoir(appName);
            return;
        }
        long startTimeInNanos = System.nanoTime();
        final DistributedSamplingPriorityQueue reservoir = this.reservoirForApp.put(appName, new DistributedSamplingPriorityQueue(appName, "Error Service", this.maxSamplesStored));
        if (reservoir != null && reservoir.size() > 0) {
            try {
                ServiceFactory.getRPMServiceManager().getOrCreateRPMService(appName).sendErrorEvents(this.maxSamplesStored, reservoir.getNumberOfTries(), Collections.unmodifiableList(reservoir.asList()));
                final long durationInNanos = System.nanoTime() - startTimeInNanos;
                ServiceFactory.getStatsService().doStatsWork(new StatsWork(){

                    @Override
                    public void doWork(StatsEngine statsEngine) {
                        ErrorServiceImpl.this.recordSupportabilityMetrics(statsEngine, durationInNanos, reservoir);
                    }

                    @Override
                    public String getAppName() {
                        return appName;
                    }
                }, reservoir.getServiceName());
                if (reservoir.size() < reservoir.getNumberOfTries()) {
                    int dropped = reservoir.getNumberOfTries() - reservoir.size();
                    Agent.LOG.log(Level.FINE, "Dropped {0} error events out of {1}.", dropped, reservoir.getNumberOfTries());
                }
            }
            catch (HttpError e) {
                if (!e.discardHarvestData()) {
                    Agent.LOG.log(Level.FINE, "Unable to send error events. Unsent events will be included in the next harvest.", e);
                    DistributedSamplingPriorityQueue<ErrorEvent> currentReservoir = this.reservoirForApp.get(appName);
                    currentReservoir.retryAll(reservoir);
                } else {
                    reservoir.clear();
                    Agent.LOG.log(Level.FINE, "Unable to send error events. Unsent events will be dropped.", e);
                }
            }
            catch (Exception e) {
                reservoir.clear();
                Agent.LOG.log(Level.FINE, "Unable to send error events. Unsent events will be dropped.", e);
            }
        }
    }

    @Override
    public String getEventHarvestIntervalMetric() {
        return "Supportability/EventHarvest/TransactionError/interval";
    }

    @Override
    public String getReportPeriodInSecondsMetric() {
        return "Supportability/EventHarvest/ErrorEventData/ReportPeriod";
    }

    @Override
    public String getEventHarvestLimitMetric() {
        return "Supportability/EventHarvest/ErrorEventData/HarvestLimit";
    }

    private void recordSupportabilityMetrics(StatsEngine statsEngine, long durationInNanos, DistributedSamplingPriorityQueue<ErrorEvent> reservoir) {
        statsEngine.getStats("Supportability/Events/TransactionError/Sent").incrementCallCount(reservoir.size());
        statsEngine.getStats("Supportability/Events/TransactionError/Seen").incrementCallCount(reservoir.getNumberOfTries());
        statsEngine.getResponseTimeStats("Supportability/EventHarvest/TransactionError/transmit").recordResponseTime(durationInNanos, TimeUnit.NANOSECONDS);
    }

    @VisibleForTesting
    public void harvestTracedErrors(String appName, StatsEngine statsEngine) {
        if (!appName.equals(this.appName)) {
            return;
        }
        List<TracedError> tracedErrorList = this.getAndClearTracedErrors(appName, statsEngine);
        if (tracedErrorList != null && tracedErrorList.size() > 0) {
            try {
                ServiceFactory.getRPMServiceManager().getOrCreateRPMService(appName).sendErrorData(tracedErrorList);
            }
            catch (Exception ex) {
                Agent.LOG.log(Level.FINE, ex, "Unable to send error events.");
            }
        }
    }

    private boolean isEnabledForApp(String appName) {
        return ServiceFactory.getConfigService().getErrorCollectorConfig(appName).isEnabled();
    }

    private boolean isEventsEnabledForApp(String appName) {
        return ServiceFactory.getConfigService().getErrorCollectorConfig(appName).isEventsEnabled();
    }

    @VisibleForTesting
    public void refreshErrorCollectorConfig(AgentConfig agentConfig) {
        ErrorCollectorConfig oldErrorConfig = this.errorCollectorConfig;
        this.errorCollectorConfig = agentConfig.getErrorCollectorConfig();
        this.errorAnalyzer = new ErrorAnalyzerImpl(this.errorCollectorConfig);
        if (this.errorCollectorConfig.isEnabled() == oldErrorConfig.isEnabled()) {
            return;
        }
        Agent.LOG.log(Level.INFO, this.errorCollectorConfig.isEnabled() ? "Errors will be sent to New Relic for {0}" : "Errors will not be sent to New Relic for {0}", this.appName);
    }

    @VisibleForTesting
    void refreshStripExceptionConfig(AgentConfig agentConfig) {
        StripExceptionConfig oldStripExceptionConfig = this.stripExceptionConfig;
        this.stripExceptionConfig = agentConfig.getStripExceptionConfig();
        if (this.stripExceptionConfig.isEnabled() != oldStripExceptionConfig.isEnabled()) {
            Agent.LOG.info(MessageFormat.format("Exception messages will{0} be stripped before sending to New Relic for {1}", this.stripExceptionConfig.isEnabled() ? "" : " not", this.appName));
        }
        if (!this.stripExceptionConfig.getAllowedClasses().equals(oldStripExceptionConfig.getAllowedClasses())) {
            Agent.LOG.info(MessageFormat.format("Exception classes allowed to keep their messages updated to {0} for {1}", this.stripExceptionConfig.getAllowedClasses().toString(), this.appName));
        }
        this.errorMessageReplacer = new ErrorMessageReplacer(this.stripExceptionConfig);
    }

    @Override
    public void reportErrors(TracedError ... errors) {
        for (TracedError error : errors) {
            this.reportError(error);
        }
    }

    @Override
    public void reportError(TracedError error) {
        this.reportError(error, null, null);
    }

    @VisibleForTesting
    protected void reportError(TracedError error, TransactionData transactionData, TransactionStats transactionStats) {
        if (error == null) {
            return;
        }
        if (error instanceof ThrowableError && this.getErrorAnalyzer().isIgnoredThrowable(((ThrowableError)error).getThrowable())) {
            if (Agent.LOG.isLoggable(Level.FINER)) {
                Throwable throwable = ((ThrowableError)error).getThrowable();
                String errorString = throwable == null ? "" : throwable.getClass().getName();
                String msg = MessageFormat.format("Ignoring error {0} for {1}", errorString, this.appName);
                Agent.LOG.finer(msg);
            }
            return;
        }
        if (error.incrementsErrorMetric()) {
            this.errorCountThisHarvest.incrementAndGet();
        } else if (!(error instanceof DeadlockTraceError)) {
            this.expectedErrorCountThisHarvest.incrementAndGet();
        }
        if (!this.errorCollectorConfig.isEnabled() || !this.isEventsEnabledForApp(this.appName) || this.maxSamplesStored <= 0) {
            return;
        }
        DistributedSamplingPriorityQueue<ErrorEvent> eventList = this.getReservoir(this.appName);
        ErrorEvent errorEvent = ErrorServiceImpl.createErrorEvent(this.appName, error, transactionData, transactionStats);
        eventList.add(errorEvent);
        if (this.errorCount.get() >= 20) {
            Agent.LOG.finer(MessageFormat.format("Error limit exceeded for {0}: {1}", this.appName, error));
            return;
        }
        int index = (int)this.totalErrorCount.getAndIncrement() % 20;
        if (this.tracedErrors.compareAndSet(index, null, error)) {
            this.errorCount.getAndIncrement();
            if (Agent.LOG.isLoggable(Level.FINER)) {
                Agent.LOG.finer(MessageFormat.format("Recording error for {0} : {1}", this.appName, error));
            }
        }
    }

    @VisibleForTesting
    protected static ErrorEvent createErrorEvent(String theAppName, TracedError error, TransactionData transactionData, TransactionStats transactionStats) {
        ErrorEvent errorEvent = transactionData != null ? ErrorEventFactory.create(theAppName, error, transactionData, transactionStats) : ErrorEventFactory.create(theAppName, error, DistributedTraceServiceImpl.nextTruncatedFloat());
        return errorEvent;
    }

    @VisibleForTesting
    List<TracedError> getAndClearTracedErrors(String appName, StatsEngine statsEngine) {
        this.recordMetrics(appName, statsEngine);
        if (ServiceFactory.getRPMServiceManager().getOrCreateRPMService(appName).isConnected()) {
            return this.getAndClearTracedErrors();
        }
        return Collections.emptyList();
    }

    @Override
    @VisibleForTesting
    public List<TracedError> getAndClearTracedErrors() {
        ArrayList<TracedError> errors = new ArrayList<TracedError>(20);
        for (int i = 0; i < this.tracedErrors.length(); ++i) {
            TracedError error = this.tracedErrors.getAndSet(i, null);
            if (error == null) continue;
            this.errorCount.getAndDecrement();
            errors.add(error);
        }
        return errors;
    }

    public ErrorAnalyzer getErrorAnalyzer() {
        return this.errorAnalyzer;
    }

    @VisibleForTesting
    public int getTracedErrorsCount() {
        return this.errorCount.get();
    }

    private void recordMetrics(String appName, StatsEngine statsEngine) {
        if (this.shouldRecordErrorCount) {
            int errorCount = this.errorCountThisHarvest.getAndSet(0);
            statsEngine.getStats("Errors/all").incrementCallCount(errorCount);
            int expectedErrorCount = this.expectedErrorCountThisHarvest.getAndSet(0);
            statsEngine.getStats("ErrorsExpected/all").incrementCallCount(expectedErrorCount);
        }
    }

    private void noticeTransaction(TransactionData td, TransactionStats transactionStats) {
        boolean isReportable;
        if (!this.appName.equals(td.getApplicationName())) {
            return;
        }
        if (!this.isEnabledForApp(td.getApplicationName())) {
            return;
        }
        String statusMessage = td.getStatusMessage();
        int responseStatus = td.getResponseStatus();
        Throwable throwable = td.getThrowable() == null ? null : td.getThrowable().throwable;
        boolean bl = isReportable = responseStatus >= 400 || throwable != null;
        if (throwable instanceof ReportableError) {
            statusMessage = throwable.getMessage();
            throwable = null;
        }
        if (isReportable) {
            if (!td.hasReportableErrorThatIsNotIgnored()) {
                if (Agent.LOG.isLoggable(Level.FINER)) {
                    String errorString = throwable == null ? "" : throwable.getClass().getName();
                    String msg = MessageFormat.format("Ignoring error {0} for {1} {2} ({3})", errorString, td.getRequestUri("error_collector"), this.appName, responseStatus);
                    Agent.LOG.finer(msg);
                }
                return;
            }
            TracedError error = this.createTracedError(this.appName, td, throwable, responseStatus, statusMessage);
            if (this.shouldRecordErrorCount && error.incrementsErrorMetric()) {
                this.recordErrorCount(td, transactionStats);
            }
            this.reportError(error, td, transactionStats);
        }
    }

    private TracedError createTracedError(String theAppName, TransactionData td, Throwable throwable, int responseStatus, String statusMessage) {
        boolean responseStatusExpected = this.errorCollectorConfig.getExpectedStatusCodes().contains(responseStatus);
        boolean throwableExpected = td.getThrowable() == null ? false : td.getThrowable().expected;
        boolean markedExpected = responseStatusExpected || throwableExpected;
        HashMap<String, Object> joinedIntrinsics = new HashMap<String, Object>(td.getIntrinsicAttributes());
        DistributedTraceService distributedTraceService = ServiceFactory.getDistributedTraceService();
        DistributedTracingConfig distributedTracingConfig = ServiceFactory.getConfigService().getDefaultAgentConfig().getDistributedTracingConfig();
        if (distributedTracingConfig.isEnabled()) {
            joinedIntrinsics.putAll(distributedTraceService.getIntrinsics(td.getInboundDistributedTracePayload(), td.getGuid(), td.getTraceId(), td.getTransportType(), td.getTransportDurationInMillis(), td.getLargestTransportDurationInMillis(), td.getParentId(), td.getParentSpanId(), td.getPriority()));
        }
        TracedError error = throwable != null ? ThrowableError.builder(this.errorCollectorConfig, theAppName, td.getBlameOrRootMetricName(), throwable, td.getWallClockStartTimeMs()).errorMessageReplacer(this.errorMessageReplacer).requestUri(td.getRequestUri("error_collector")).prefixedAttributes(td.getPrefixedAttributes()).userAttributes(td.getUserAttributes()).agentAttributes(td.getAgentAttributes()).errorAttributes(td.getErrorAttributes()).intrinsicAttributes(joinedIntrinsics).expected(markedExpected).build() : HttpTracedError.builder(this.errorCollectorConfig, theAppName, td.getBlameOrRootMetricName(), td.getWallClockStartTimeMs()).statusCodeAndMessage(responseStatus, statusMessage).transactionData(td).requestUri(td.getRequestUri("error_collector")).prefixedAttributes(td.getPrefixedAttributes()).userAttributes(td.getUserAttributes()).agentAttributes(td.getAgentAttributes()).errorAttributes(td.getErrorAttributes()).intrinsicAttributes(joinedIntrinsics).expected(markedExpected).build();
        return error;
    }

    private void recordErrorCount(TransactionData td, TransactionStats transactionStats) {
        String metricName = this.getErrorCountMetricName(td);
        if (metricName != null) {
            transactionStats.getUnscopedStats().getStats(metricName).incrementCallCount();
        }
        String metricNameAll = td.isWebTransaction() ? "Errors/allWeb" : "Errors/allOther";
        transactionStats.getUnscopedStats().getStats(metricNameAll).incrementCallCount();
    }

    private String getErrorCountMetricName(TransactionData td) {
        String blameMetricName = td.getBlameMetricName();
        if (blameMetricName != null) {
            StringBuilder output = new StringBuilder("Errors/".length() + blameMetricName.length());
            output.append("Errors/");
            output.append(blameMetricName);
            return output.toString();
        }
        return null;
    }

    @VisibleForTesting
    public DistributedSamplingPriorityQueue<ErrorEvent> getReservoir(String appName) {
        DistributedSamplingPriorityQueue<ErrorEvent> result = this.reservoirForApp.get(appName);
        while (result == null) {
            this.reservoirForApp.putIfAbsent(appName, new DistributedSamplingPriorityQueue(appName, "Error Service", this.maxSamplesStored));
            result = this.reservoirForApp.get(appName);
        }
        return result;
    }

    @Override
    public void reportException(Throwable throwable) {
        if (this.getErrorAnalyzer().isIgnoredThrowable(throwable)) {
            Agent.LOG.finer(MessageFormat.format("Ignoring error with throwable {0} ", throwable));
        } else {
            this.reportException(throwable, Collections.emptyMap(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportException(Throwable throwable, Map<String, ?> params, boolean expected) {
        Transaction tx = Transaction.getTransaction(false);
        if (tx != null && tx.isInProgress()) {
            TransactionActivity transactionActivity = TransactionActivity.get();
            if (transactionActivity != null && transactionActivity.getLastTracer() != null) {
                transactionActivity.getLastTracer().setNoticedError(throwable);
            }
            if (params != null) {
                tx.getErrorAttributes().putAll(params);
            }
            Transaction transaction = tx;
            synchronized (transaction) {
                tx.setThrowable(throwable, TransactionErrorPriority.API, expected);
            }
        } else {
            TracedError error = ThrowableError.builder(this.errorCollectorConfig, null, "Unknown", throwable, System.currentTimeMillis()).errorMessageReplacer(this.errorMessageReplacer).errorAttributes(params).expected(expected).build();
            this.reportError(error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportError(String message, Map<String, ?> params, boolean expected) {
        Transaction tx = Transaction.getTransaction(false);
        if (tx != null && tx.isInProgress()) {
            TransactionActivity transactionActivity = TransactionActivity.get();
            if (transactionActivity != null && transactionActivity.getLastTracer() != null) {
                transactionActivity.getLastTracer().setNoticedError(new ReportableError(message));
            }
            if (params != null) {
                tx.getErrorAttributes().putAll(params);
            }
            Transaction transaction = tx;
            synchronized (transaction) {
                tx.setThrowable(new ReportableError(message), TransactionErrorPriority.API, expected);
            }
        } else {
            TracedError error = HttpTracedError.builder(this.errorCollectorConfig, null, "Unknown", System.currentTimeMillis()).message(message).errorAttributes(params).expected(expected).build();
            this.reportError(error);
        }
    }

    @Override
    public void beforeHarvest(String appName, StatsEngine statsEngine) {
        this.harvestTracedErrors(appName, statsEngine);
    }

    @Override
    public void afterHarvest(String appName) {
    }

    public static Collection<? extends PointCut> getEnabledErrorHandlerPointCuts() {
        AgentConfig config = ServiceFactory.getConfigService().getDefaultAgentConfig();
        Object exceptionHandlers = config.getErrorCollectorConfig().getExceptionHandlers();
        ArrayList<ExceptionHandlerPointCut> pointcuts = new ArrayList<ExceptionHandlerPointCut>();
        if (exceptionHandlers instanceof Collection) {
            for (Object sigObject : (Collection)exceptionHandlers) {
                ExceptionHandlerPointCut pc;
                if (sigObject instanceof ExceptionHandlerSignature) {
                    ExceptionHandlerSignature exHandlerSig = (ExceptionHandlerSignature)sigObject;
                    String msg = MessageFormat.format("Instrumenting exception handler signature {0}", exHandlerSig.toString());
                    Agent.LOG.finer(msg);
                    pc = new ExceptionHandlerPointCut(exHandlerSig);
                    if (!pc.isEnabled()) continue;
                    pointcuts.add(pc);
                    continue;
                }
                if (sigObject instanceof String) {
                    ClassMethodSignature signature = PointCutFactory.parseClassMethodSignature(sigObject.toString());
                    try {
                        ExceptionHandlerSignature exHandlerSig = new ExceptionHandlerSignature(signature);
                        Agent.LOG.info(MessageFormat.format("Instrumenting exception handler signature {0}", exHandlerSig.toString()));
                        pc = new ExceptionHandlerPointCut(exHandlerSig);
                        if (!pc.isEnabled()) continue;
                        pointcuts.add(pc);
                    }
                    catch (InvalidMethodDescriptor e) {
                        Agent.LOG.severe(MessageFormat.format("Unable to instrument exception handler {0} : {1}", sigObject.toString(), e.toString()));
                    }
                    continue;
                }
                if (!(sigObject instanceof Exception)) continue;
                Agent.LOG.severe(MessageFormat.format("Unable to instrument exception handler : {0}", sigObject.toString()));
            }
        }
        return pointcuts;
    }

    @Override
    public void reportHTTPError(String message, int statusCode, String uri) {
        if (!this.getErrorAnalyzer().isIgnoredStatus(statusCode)) {
            TracedError error = HttpTracedError.builder(this.errorCollectorConfig, null, "WebTransaction" + uri, System.currentTimeMillis()).statusCodeAndMessage(statusCode, message).requestUri(uri).build();
            this.reportError(error);
            Agent.LOG.finer(MessageFormat.format("Reported HTTP error {0} with status code {1} URI {2}", message, statusCode, uri));
        } else {
            Agent.LOG.finer(MessageFormat.format("Ignoring HTTP error {0} with status code {1} URI {2}", message, statusCode, uri));
        }
    }

    private class MyConfigListener
    implements AgentConfigListener {
        private MyConfigListener() {
        }

        @Override
        public void configChanged(String appName, AgentConfig agentConfig) {
            if (ErrorServiceImpl.this.appName.equals(appName)) {
                Agent.LOG.fine(MessageFormat.format("Error service received configuration change notification for {0}", appName));
                ErrorServiceImpl.this.refreshErrorCollectorConfig(agentConfig);
                ErrorServiceImpl.this.refreshStripExceptionConfig(agentConfig);
            }
        }
    }

    private class MyTransactionListener
    implements TransactionListener {
        private MyTransactionListener() {
        }

        @Override
        public void dispatcherTransactionFinished(TransactionData transactionData, TransactionStats transactionStats) {
            ErrorServiceImpl.this.noticeTransaction(transactionData, transactionStats);
        }
    }
}

