/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deps.org.apache.logging.log4j.core.util;

import com.newrelic.agent.deps.org.apache.logging.log4j.core.config.Configuration;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.config.ConfigurationListener;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.config.Reconfigurable;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.util.AbstractWatcher;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.util.FileWatcher;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.util.Source;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.util.Watcher;
import java.io.File;
import java.util.Collections;
import java.util.List;

public class WrappedFileWatcher
extends AbstractWatcher
implements FileWatcher {
    private final FileWatcher watcher;
    private volatile long lastModifiedMillis;

    public WrappedFileWatcher(FileWatcher watcher, Configuration configuration, Reconfigurable reconfigurable, List<ConfigurationListener> configurationListeners, long lastModifiedMillis) {
        super(configuration, reconfigurable, configurationListeners);
        this.watcher = watcher;
        this.lastModifiedMillis = lastModifiedMillis;
    }

    public WrappedFileWatcher(FileWatcher watcher) {
        super(null, null, null);
        this.watcher = watcher;
    }

    @Override
    public long getLastModified() {
        return this.lastModifiedMillis;
    }

    @Override
    public void fileModified(File file) {
        this.watcher.fileModified(file);
    }

    @Override
    public boolean isModified() {
        long lastModified = this.getSource().getFile().lastModified();
        if (this.lastModifiedMillis != lastModified) {
            this.lastModifiedMillis = lastModified;
            return true;
        }
        return false;
    }

    @Override
    public List<ConfigurationListener> getListeners() {
        if (super.getListeners() != null) {
            return Collections.unmodifiableList(super.getListeners());
        }
        return null;
    }

    @Override
    public void modified() {
        if (this.getListeners() != null) {
            super.modified();
        }
        this.fileModified(this.getSource().getFile());
        this.lastModifiedMillis = this.getSource().getFile().lastModified();
    }

    @Override
    public void watching(Source source2) {
        this.lastModifiedMillis = source2.getFile().lastModified();
        super.watching(source2);
    }

    @Override
    public Watcher newWatcher(Reconfigurable reconfigurable, List<ConfigurationListener> listeners, long lastModifiedMillis) {
        WrappedFileWatcher watcher = new WrappedFileWatcher(this.watcher, this.getConfiguration(), reconfigurable, listeners, lastModifiedMillis);
        if (this.getSource() != null) {
            watcher.watching(this.getSource());
        }
        return watcher;
    }
}

