/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deps.org.apache.logging.log4j.core.util;

import com.newrelic.agent.deps.org.apache.logging.log4j.Logger;
import com.newrelic.agent.deps.org.apache.logging.log4j.status.StatusLogger;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public class ExecutorServices {
    private static final Logger LOGGER = StatusLogger.getLogger();

    public static boolean shutdown(ExecutorService executorService, long timeout2, TimeUnit timeUnit, String source2) {
        if (executorService == null || executorService.isTerminated()) {
            return true;
        }
        executorService.shutdown();
        if (timeout2 > 0L && timeUnit == null) {
            throw new IllegalArgumentException(String.format("%s can't shutdown %s when timeout = %,d and timeUnit = %s.", new Object[]{source2, executorService, timeout2, timeUnit}));
        }
        if (timeout2 > 0L) {
            try {
                if (!executorService.awaitTermination(timeout2, timeUnit)) {
                    executorService.shutdownNow();
                    if (!executorService.awaitTermination(timeout2, timeUnit)) {
                        LOGGER.error("{} pool {} did not terminate after {} {}", (Object)source2, (Object)executorService, (Object)timeout2, (Object)timeUnit);
                    }
                    return false;
                }
            }
            catch (InterruptedException ie) {
                executorService.shutdownNow();
                Thread.currentThread().interrupt();
            }
        } else {
            executorService.shutdown();
        }
        return true;
    }
}

