/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deps.okhttp3.internal;

import com.newrelic.agent.deps.kotlin.Metadata;
import com.newrelic.agent.deps.kotlin.jvm.internal.Intrinsics;
import com.newrelic.agent.deps.kotlin.text.StringsKt;
import com.newrelic.agent.deps.okhttp3.internal.Util;
import com.newrelic.agent.deps.okio.Buffer;
import com.newrelic.agent.deps.org.jetbrains.annotations.NotNull;
import com.newrelic.agent.deps.org.jetbrains.annotations.Nullable;
import java.net.IDN;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Locale;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a0\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0002\u001a\"\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\f\u0010\r\u001a\u00020\u0001*\u00020\u0003H\u0002\u001a\f\u0010\u000e\u001a\u0004\u0018\u00010\u0003*\u00020\u0003\u00a8\u0006\u000f"}, d2={"decodeIpv4Suffix", "", "input", "", "pos", "", "limit", "address", "", "addressOffset", "decodeIpv6", "Ljava/net/InetAddress;", "inet6AddressToAscii", "containsInvalidHostnameAsciiCodes", "toCanonicalHost", "okhttp"})
public final class HostnamesKt {
    @Nullable
    public static final String toCanonicalHost(@NotNull String $this$toCanonicalHost) {
        Intrinsics.checkNotNullParameter($this$toCanonicalHost, "<this>");
        String host = $this$toCanonicalHost;
        if (StringsKt.contains$default((CharSequence)host, ":", false, 2, null)) {
            InetAddress inetAddress;
            InetAddress inetAddress2 = inetAddress = StringsKt.startsWith$default(host, "[", false, 2, null) && StringsKt.endsWith$default(host, "]", false, 2, null) ? HostnamesKt.decodeIpv6(host, 1, host.length() - 1) : HostnamesKt.decodeIpv6(host, 0, host.length());
            if (inetAddress == null) {
                return null;
            }
            InetAddress inetAddress3 = inetAddress;
            byte[] address = inetAddress3.getAddress();
            if (address.length == 16) {
                Intrinsics.checkNotNullExpressionValue(address, "address");
                return HostnamesKt.inet6AddressToAscii(address);
            }
            if (address.length == 4) {
                return inetAddress3.getHostAddress();
            }
            throw new AssertionError((Object)("Invalid IPv6 address: '" + host + '\''));
        }
        try {
            String string = IDN.toASCII(host);
            Intrinsics.checkNotNullExpressionValue(string, "toASCII(host)");
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue(locale, "US");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toLowerCase(locale)");
            String result = string2;
            if (((CharSequence)result).length() == 0) {
                return null;
            }
            return HostnamesKt.containsInvalidHostnameAsciiCodes(result) ? (String)null : result;
        }
        catch (IllegalArgumentException _) {
            return null;
        }
    }

    private static final boolean containsInvalidHostnameAsciiCodes(String $this$containsInvalidHostnameAsciiCodes) {
        int n = 0;
        int n2 = $this$containsInvalidHostnameAsciiCodes.length();
        while (n < n2) {
            int i;
            char c;
            if (Intrinsics.compare(c = $this$containsInvalidHostnameAsciiCodes.charAt(i = n++), 31) <= 0 || Intrinsics.compare(c, 127) >= 0) {
                return true;
            }
            if (StringsKt.indexOf$default((CharSequence)" #%/:?@[\\]", c, 0, false, 6, null) == -1) continue;
            return true;
        }
        return false;
    }

    private static final InetAddress decodeIpv6(String input, int pos, int limit) {
        byte[] address = new byte[16];
        int b = 0;
        int compress = -1;
        int groupOffset = -1;
        int i = pos;
        while (i < limit) {
            int n;
            int hexDigit;
            if (b == address.length) {
                return null;
            }
            if (i + 2 <= limit && StringsKt.startsWith$default(input, "::", i, false, 4, null)) {
                if (compress != -1) {
                    return null;
                }
                compress = b += 2;
                if ((i += 2) == limit) {
                    break;
                }
            } else if (b != 0) {
                if (StringsKt.startsWith$default(input, ":", i, false, 4, null)) {
                    int n2 = i;
                    i = n2 + 1;
                } else {
                    if (StringsKt.startsWith$default(input, ".", i, false, 4, null)) {
                        if (!HostnamesKt.decodeIpv4Suffix(input, groupOffset, limit, address, b - 2)) {
                            return null;
                        }
                        b += 2;
                        break;
                    }
                    return null;
                }
            }
            int value = 0;
            groupOffset = i;
            while (i < limit && (hexDigit = Util.parseHexDigit(input.charAt(i))) != -1) {
                value = (value << 4) + hexDigit;
                n = i;
                i = n + 1;
            }
            int groupLength = i - groupOffset;
            if (groupLength == 0 || groupLength > 4) {
                return null;
            }
            n = b;
            b = n + 1;
            address[n] = (byte)(value >>> 8 & 0xFF);
            n = b;
            b = n + 1;
            address[n] = (byte)(value & 0xFF);
        }
        if (b != address.length) {
            if (compress == -1) {
                return null;
            }
            System.arraycopy(address, compress, address, address.length - (b - compress), b - compress);
            Arrays.fill(address, compress, compress + (address.length - b), (byte)0);
        }
        return InetAddress.getByAddress(address);
    }

    private static final boolean decodeIpv4Suffix(String input, int pos, int limit, byte[] address, int addressOffset) {
        int b = addressOffset;
        int i = pos;
        while (i < limit) {
            int n;
            char c;
            if (b == address.length) {
                return false;
            }
            if (b != addressOffset) {
                if (input.charAt(i) != '.') {
                    return false;
                }
                int n2 = i;
                i = n2 + 1;
            }
            int value = 0;
            int groupOffset = i;
            while (i < limit && Intrinsics.compare(c = input.charAt(i), 48) >= 0 && Intrinsics.compare(c, 57) <= 0) {
                if (value == 0 && groupOffset != i) {
                    return false;
                }
                if ((value = value * 10 + c - 48) > 255) {
                    return false;
                }
                n = i;
                i = n + 1;
            }
            int groupLength = i - groupOffset;
            if (groupLength == 0) {
                return false;
            }
            n = b;
            b = n + 1;
            address[n] = (byte)value;
        }
        return b == addressOffset + 4;
    }

    private static final String inet6AddressToAscii(byte[] address) {
        int i;
        int longestRunOffset = 0;
        longestRunOffset = -1;
        int longestRunLength = 0;
        boolean bl = false;
        for (i = 0; i < address.length; i += 2) {
            int currentRunOffset = i;
            while (i < 16 && address[i] == 0 && address[i + 1] == 0) {
                i += 2;
            }
            int currentRunLength = i - currentRunOffset;
            if (currentRunLength <= longestRunLength || currentRunLength < 4) continue;
            longestRunOffset = currentRunOffset;
            longestRunLength = currentRunLength;
        }
        Buffer result = new Buffer();
        i = 0;
        while (i < address.length) {
            if (i == longestRunOffset) {
                result.writeByte(58);
                if ((i += longestRunLength) != 16) continue;
                result.writeByte(58);
                continue;
            }
            if (i > 0) {
                result.writeByte(58);
            }
            int group = Util.and(address[i], 255) << 8 | Util.and(address[i + 1], 255);
            result.writeHexadecimalUnsignedLong(group);
            i += 2;
        }
        return result.readUtf8();
    }
}

