/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.EnvironmentFacade;
import com.newrelic.agent.config.SystemProps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

public class SystemPropertyProvider {
    private static final String NEW_RELIC_PREFIX_ENV = "NEW_RELIC_";
    private static final String LOG_ENV = "NEW_RELIC_LOG";
    private static final String LOG_FILE_NAME = "newrelic.config.log_file_name";
    private static final String NEW_RELIC_SYSTEM_PROPERTY_ROOT = "newrelic.";
    private final Map<String, String> envVars;
    private final Map<String, String> envVarToSystemPropKeyMap;
    private final Map<String, String> newRelicSystemProps;
    private final Map<String, Object> newRelicPropsWithoutPrefix;
    private final Map<String, Object> newRelicEnvVarsWithoutPrefix;
    private final SystemProps systemProps;
    private final EnvironmentFacade environmentFacade;

    public SystemPropertyProvider() {
        this(SystemProps.getSystemProps(), EnvironmentFacade.getInstance());
    }

    public SystemPropertyProvider(SystemProps sysProps, EnvironmentFacade environmentFacade) {
        this.systemProps = sysProps;
        this.environmentFacade = environmentFacade;
        this.envVars = this.initEnvVariables();
        this.envVarToSystemPropKeyMap = this.initEnvVarToSystemPropMap();
        this.newRelicSystemProps = this.initNewRelicSystemProperties();
        this.newRelicPropsWithoutPrefix = this.createNewRelicSystemPropertiesWithoutPrefix();
        this.newRelicEnvVarsWithoutPrefix = this.createNewRelicEnvVarsWithoutPrefix();
    }

    private Map<String, String> initEnvVariables() {
        HashMap<String, String> envVars = new HashMap<String, String>();
        envVars.put(LOG_FILE_NAME, this.getenv(LOG_ENV));
        return envVars;
    }

    private Map<String, String> initEnvVarToSystemPropMap() {
        HashMap<String, String> envVars = new HashMap<String, String>();
        envVars.put(LOG_ENV, LOG_FILE_NAME);
        return envVars;
    }

    private Map<String, String> initNewRelicSystemProperties() {
        HashMap<String, String> nrProps = new HashMap<String, String>();
        try {
            for (Map.Entry<Object, Object> entry : this.systemProps.getAllSystemProperties().entrySet()) {
                String key = entry.getKey().toString();
                if (!key.startsWith(NEW_RELIC_SYSTEM_PROPERTY_ROOT)) continue;
                String val = entry.getValue().toString();
                nrProps.put(key, val);
            }
        }
        catch (SecurityException t2) {
            Agent.LOG.log(Level.FINE, "Unable to get system properties");
        }
        return Collections.unmodifiableMap(nrProps);
    }

    private Map<String, Object> createNewRelicSystemPropertiesWithoutPrefix() {
        HashMap<String, Object> nrProps = new HashMap<String, Object>();
        this.addNewRelicSystemProperties(nrProps, this.systemProps.getAllSystemProperties());
        return Collections.unmodifiableMap(nrProps);
    }

    private Map<String, Object> createNewRelicEnvVarsWithoutPrefix() {
        HashMap<String, Object> nrEnv = new HashMap<String, Object>();
        this.addNewRelicEnvProperties(nrEnv, this.environmentFacade.getAllEnvProperties());
        return Collections.unmodifiableMap(nrEnv);
    }

    private void addNewRelicSystemProperties(Map<String, Object> nrProps, Properties allSysProps) {
        for (Map.Entry<Object, Object> entry : allSysProps.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith("newrelic.config.")) continue;
            this.addPropertyWithoutSystemPropRoot(nrProps, key, entry.getValue().toString());
        }
    }

    private void addNewRelicEnvProperties(Map<String, Object> nrProps, Map<String, String> allEnvVars) {
        for (Map.Entry<String, String> entry : allEnvVars.entrySet()) {
            String envVar = entry.getKey();
            if (envVar.startsWith(NEW_RELIC_PREFIX_ENV)) {
                String envVarNameToReplace = this.envVarToSystemPropKeyMap.get(envVar);
                if (envVarNameToReplace != null) {
                    this.addPropertyWithoutSystemPropRoot(nrProps, envVarNameToReplace, entry.getValue());
                    continue;
                }
                this.addPropertyWithoutEnvPrefix(nrProps, envVar.toLowerCase(), entry.getValue());
                continue;
            }
            if (!envVar.startsWith("newrelic.config.")) continue;
            Agent.LOG.log(Level.WARNING, "The agent only supports environment variable configurations consisting of alphanumeric characters and underscores. Use {0} instead.", this.formatNewRelicEnvVarPrefix(envVar));
        }
    }

    private void addPropertyWithoutEnvPrefix(Map<String, Object> nrProps, String key, Object value) {
        nrProps.put(key.substring(NEW_RELIC_PREFIX_ENV.length()), value);
    }

    private void addPropertyWithoutSystemPropRoot(Map<String, Object> nrProps, String key, Object value) {
        nrProps.put(key.substring("newrelic.config.".length()), value);
    }

    public String getEnvironmentVariable(String key) {
        String propVal = this.envVars.get(key);
        if (propVal != null) {
            return propVal;
        }
        return this.getenv(key);
    }

    private String getenv(String key) {
        String val = this.environmentFacade.getenv(key);
        if (val != null) {
            return val;
        }
        return this.environmentFacade.getenv(this.formatNewRelicEnvVarPrefix(key));
    }

    private String formatNewRelicEnvVarPrefix(String key) {
        return key.replace("newrelic.config", "new.relic").replaceAll("[.-]", "_").toUpperCase();
    }

    public String getSystemProperty(String prop) {
        return this.systemProps.getSystemProperty(prop);
    }

    public Map<String, String> getNewRelicSystemProperties() {
        return this.newRelicSystemProps;
    }

    public Map<String, Object> getNewRelicPropertiesWithoutPrefix() {
        return this.newRelicPropsWithoutPrefix;
    }

    public Map<String, Object> getNewRelicEnvVarsWithoutPrefix() {
        return this.newRelicEnvVarsWithoutPrefix;
    }
}

