/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.InetHostAddress;
import com.newrelic.agent.deps.com.google.common.annotations.VisibleForTesting;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;

public class Hostname {
    private static volatile String cachedHostname = null;
    private static volatile String cachedFullHostname = null;
    private static volatile String inUseIPAddress = null;
    private static volatile ArrayList<String> ipAddress = new ArrayList();

    private Hostname() {
    }

    public static String getDisplayHostname(AgentConfig config, String defaultHostname) {
        return (String)config.getValue("process_host.display_name", defaultHostname);
    }

    public static String getHostname(AgentConfig config, boolean invalidate) {
        if (invalidate) {
            cachedHostname = null;
        }
        return Hostname.getHostname(config);
    }

    public static String getHostname(AgentConfig config) {
        if (cachedHostname != null) {
            return cachedHostname;
        }
        try {
            cachedHostname = InetAddress.getLocalHost().getHostName();
            return cachedHostname;
        }
        catch (UnknownHostException e) {
            Agent.LOG.log(Level.FINE, "Error getting host name. Using IP address.", e);
            return Hostname.getInUseIpAddress(config);
        }
    }

    public static String getFullHostname(AgentConfig config) {
        if (cachedFullHostname != null) {
            return cachedFullHostname;
        }
        try {
            cachedFullHostname = InetAddress.getLocalHost().getCanonicalHostName();
            return cachedFullHostname;
        }
        catch (UnknownHostException e) {
            Agent.LOG.log(Level.FINE, "Error getting host name. Using IP address.", e);
            return Hostname.getInUseIpAddress(config);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static InetAddress determineAddress() {
        try (DatagramSocket socket = new DatagramSocket();){
            socket.connect(Inet6Address.getByName("newrelic.com"), 10002);
            InetAddress inetAddress = socket.getLocalAddress();
            return inetAddress;
        }
        catch (SocketException | UnknownHostException e) {
            Agent.LOG.log(Level.FINE, "Unable to determine IP address.", e);
            return InetAddress.getLoopbackAddress();
        }
    }

    private static List<InterfaceAddress> getAllInterfaceAddresses(String ip) {
        if (ip == null) {
            return Collections.emptyList();
        }
        List<NetworkInterface> networkInterfaces = Hostname.getNetworkInterfaces();
        for (NetworkInterface networkInterface : networkInterfaces) {
            List<InterfaceAddress> addresses = networkInterface.getInterfaceAddresses();
            for (InterfaceAddress address : addresses) {
                if (!ip.equals(InetHostAddress.from(address))) continue;
                return addresses;
            }
        }
        return Collections.emptyList();
    }

    @VisibleForTesting
    protected static void setInUseIpAddress(String address) {
        inUseIPAddress = address;
    }

    public static String getInUseIpAddress(AgentConfig config) {
        if (inUseIPAddress == null) {
            Hostname.discoverInUseIpAddress(config);
        }
        return inUseIPAddress;
    }

    @VisibleForTesting
    protected static void setIpAddress(ArrayList<String> addresses) {
        ipAddress = addresses;
    }

    public static ArrayList<String> getIpAddress(AgentConfig config) {
        if (ipAddress == null || ipAddress.isEmpty()) {
            Hostname.discoverInUseIpAddress(config);
        }
        return ipAddress;
    }

    private static void discoverInUseIpAddress(AgentConfig config) {
        InetAddress candidate = Hostname.determineAddress();
        boolean preferIpv6 = Hostname.preferIpv6(config);
        if (candidate != InetAddress.getLoopbackAddress()) {
            List<InterfaceAddress> iface = Hostname.getAllInterfaceAddresses(candidate.getHostAddress());
            for (InterfaceAddress addr : iface) {
                ipAddress.add(addr.getAddress().getHostAddress());
                if (preferIpv6) {
                    if (!(addr.getAddress() instanceof Inet6Address)) continue;
                    inUseIPAddress = addr.getAddress().getHostAddress();
                    continue;
                }
                if (!(addr.getAddress() instanceof Inet4Address)) continue;
                inUseIPAddress = addr.getAddress().getHostAddress();
            }
        }
        if (inUseIPAddress == null) {
            if (preferIpv6) {
                inUseIPAddress = "0:0:0:0:0:0:0:1";
                Agent.LOG.log(Level.FINE, "Unable to determine IPv6 address. Setting to {0}", inUseIPAddress);
            } else {
                inUseIPAddress = "127.0.0.1";
                Agent.LOG.log(Level.FINE, "Unable to determine IPv4 address. Setting to {0}", inUseIPAddress);
            }
            ipAddress.add(inUseIPAddress);
        }
    }

    private static List<NetworkInterface> getNetworkInterfaces() {
        try {
            return Collections.list(NetworkInterface.getNetworkInterfaces());
        }
        catch (SocketException e) {
            return Collections.emptyList();
        }
    }

    protected static Boolean preferIpv6(AgentConfig config) {
        Object value = config.getValue("process_host.ipv_preference", null);
        if (value != null && "6".equals(String.valueOf(value))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

