/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.browser;

import com.newrelic.agent.ConnectionListener;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.browser.BrowserConfig;
import com.newrelic.agent.browser.BrowserConfigFactory;
import com.newrelic.agent.browser.BrowserService;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class BrowserServiceImpl
extends AbstractService
implements BrowserService,
ConnectionListener {
    private final ConcurrentMap<String, BrowserConfig> browserConfigs = new ConcurrentHashMap<String, BrowserConfig>();
    private volatile BrowserConfig defaultBrowserConfig = null;
    private final String defaultAppName = ServiceFactory.getConfigService().getDefaultAgentConfig().getApplicationName();

    public BrowserServiceImpl() {
        super(BrowserService.class.getSimpleName());
    }

    @Override
    protected void doStart() throws Exception {
        ServiceFactory.getRPMServiceManager().addConnectionListener(this);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceFactory.getRPMServiceManager().removeConnectionListener(this);
    }

    @Override
    public BrowserConfig getBrowserConfig(String appName) {
        if (appName == null || appName.equals(this.defaultAppName)) {
            return this.defaultBrowserConfig;
        }
        return (BrowserConfig)this.browserConfigs.get(appName);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void connected(IRPMService rpmService, AgentConfig agentConfig) {
        String appName = rpmService.getApplicationName();
        BrowserConfig browserConfig = BrowserConfigFactory.createBrowserConfig(appName, agentConfig);
        if (appName == null || appName.equals(this.defaultAppName)) {
            this.defaultBrowserConfig = browserConfig;
        } else if (browserConfig == null) {
            this.browserConfigs.remove(appName);
        } else {
            this.browserConfigs.put(appName, browserConfig);
        }
    }

    @Override
    public void disconnected(IRPMService rpmService) {
    }
}

