/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.weave.weavepackage;

import com.newrelic.agent.deps.com.google.common.collect.ImmutableMap;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.deps.org.objectweb.asm.tree.ClassNode;
import com.newrelic.weave.utils.ClassCache;
import com.newrelic.weave.utils.WeaveUtils;
import com.newrelic.weave.weavepackage.PackageValidationResult;
import java.util.List;
import java.util.Map;

public class PackageWeaveResult {
    private final String className;
    private final ClassNode composite;
    private final PackageValidationResult validationResult;
    private final Map<String, List<Method>> weavedMethods;
    private final Map<String, byte[]> annotationProxyClasses;

    public PackageWeaveResult(PackageValidationResult validationResult, String className, ClassNode composite, Map<String, List<Method>> weavedMethods, Map<String, byte[]> annotationProxyClasses) {
        this.validationResult = validationResult;
        this.className = className;
        this.composite = composite;
        this.weavedMethods = ImmutableMap.copyOf(weavedMethods);
        this.annotationProxyClasses = ImmutableMap.copyOf(annotationProxyClasses);
    }

    public boolean weavedClass() {
        return this.weavedMethods.size() > 0;
    }

    public byte[] getCompositeBytes(ClassCache cache) {
        if (this.weavedClass()) {
            return WeaveUtils.convertToClassBytes(this.composite, cache);
        }
        return null;
    }

    public String getClassName() {
        return this.className;
    }

    public ClassNode getComposite() {
        if (this.weavedClass()) {
            return this.composite;
        }
        return null;
    }

    public Map<String, List<Method>> getWeavedMethods() {
        return this.weavedMethods;
    }

    public PackageValidationResult getValidationResult() {
        return this.validationResult;
    }

    public Map<String, byte[]> getAnnotationProxyClasses() {
        return this.annotationProxyClasses;
    }
}

