/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry.metrics;

import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.metrics.Metric;
import com.newrelic.telemetry.util.Utils;
import java.util.Map;

public final class Count
implements Metric {
    private final String name;
    private final double value;
    private final long startTimeMs;
    private final long endTimeMs;
    private final Map<String, Object> attributes;

    public Count(String name, double value, long startTimeMs, long endTimeMs, Attributes attributes) {
        this.name = Utils.verifyNonNull(name);
        this.value = value;
        this.startTimeMs = startTimeMs;
        this.endTimeMs = endTimeMs;
        this.attributes = Utils.verifyNonNull(attributes).asMap();
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public double getValue() {
        return this.value;
    }

    public long getStartTimeMs() {
        return this.startTimeMs;
    }

    public long getEndTimeMs() {
        return this.endTimeMs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Count count = (Count)o;
        if (Double.compare(count.getValue(), this.getValue()) != 0) {
            return false;
        }
        if (this.getStartTimeMs() != count.getStartTimeMs()) {
            return false;
        }
        if (this.getEndTimeMs() != count.getEndTimeMs()) {
            return false;
        }
        if (this.getName() != null ? !this.getName().equals(count.getName()) : count.getName() != null) {
            return false;
        }
        return this.getAttributes() != null ? this.getAttributes().equals(count.getAttributes()) : count.getAttributes() == null;
    }

    public int hashCode() {
        int result = this.getName() != null ? this.getName().hashCode() : 0;
        long temp = Double.doubleToLongBits(this.getValue());
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (int)(this.getStartTimeMs() ^ this.getStartTimeMs() >>> 32);
        result = 31 * result + (int)(this.getEndTimeMs() ^ this.getEndTimeMs() >>> 32);
        result = 31 * result + (this.getAttributes() != null ? this.getAttributes().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Count{name='" + this.name + '\'' + ", value=" + this.value + ", startTimeMs=" + this.startTimeMs + ", endTimeMs=" + this.endTimeMs + ", attributes=" + this.attributes + '}';
    }
}

