/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ThreadNameNormalizer {
    private static final char REPLACEMENT_CHAR = '#';
    private static final String REPLACEMENT_STRING = new String(new char[]{'#'});
    public static final String DEFAULT_PATTERN = "((?<=[\\W_]|^)([0-9a-fA-F]){4,}(?=[\\W_]|$))|\\d+";
    private static final ReplacementRule[] regexps = new ReplacementRule[]{ThreadNameNormalizer.getConstantRegexReplacementRule(".* (GET|PUT|POST|DELETE|HEAD) .*", "WebRequest#"), ThreadNameNormalizer.getConstantRegexReplacementRule("pool-.*thread.*", "pool#thread#"), ThreadNameNormalizer.getPrefixReplacementRule("ActiveMQ", "BoneCP-keep-alive-scheduler", "CookieBrokerUpdates", "C3P0PooledConnectionPoolManager", "default-akka.actor.default", "DelayedAutomationRunner", "elasticsearch", "hystrix", "org.eclipse.jetty.server.session.HashSessionManager", "jbm-client-session", "JobHandler", "QuartzScheduler", "Sending mailitem", "SOAPProcessorThread", "TransientResourceLock"), ThreadNameNormalizer.getReplaceAfterMatchRule("http:", "https:", "uri:", "@"), ThreadNameNormalizer.getEnclosingCharactersReplacementRule('{', '}'), ThreadNameNormalizer.getEnclosingCharactersReplacementRule('(', ')'), ThreadNameNormalizer.getEnclosingCharactersReplacementRule('[', ']')};
    List<ReplacementRule> REPLACEMENT_RULES = Collections.unmodifiableList(Arrays.asList(regexps));
    private final Pattern replacementPattern;

    ThreadNameNormalizer() {
        this(DEFAULT_PATTERN);
    }

    public ThreadNameNormalizer(String pattern) {
        this.replacementPattern = Pattern.compile(pattern);
    }

    public String getNormalizedThreadName(String name) {
        for (ReplacementRule rule : this.REPLACEMENT_RULES) {
            ReplacementResult result = rule.getResult(name);
            if (null == result) continue;
            name = result.replacement;
            if (!result.stop) continue;
            return name;
        }
        String renamed = this.replacementPattern.matcher(name).replaceAll(REPLACEMENT_STRING);
        return renamed.replace('/', '-');
    }

    private static ReplacementRule getEnclosingCharactersReplacementRule(final char startChar, final char endChar) {
        return new ReplacementRule(){

            @Override
            public ReplacementResult getResult(String name) {
                int index = 0;
                boolean replace = false;
                while (index < name.length() && (index = name.indexOf(startChar, index)) >= 0) {
                    int i;
                    replace = true;
                    int found = 1;
                    for (i = index + 1; i < name.length() && found > 0; ++i) {
                        if (name.charAt(i) == startChar) {
                            ++found;
                            continue;
                        }
                        if (name.charAt(i) != endChar) continue;
                        --found;
                    }
                    String replacement = name.substring(0, index) + startChar + '#' + endChar;
                    index = replacement.length();
                    if (i == name.length()) {
                        name = replacement;
                        continue;
                    }
                    name = replacement + name.substring(i, name.length());
                }
                return replace ? new ReplacementResult(false, name) : null;
            }
        };
    }

    private static ReplacementRule getConstantRegexReplacementRule(String regex, String replacement) {
        final ReplacementResult replacementResult = new ReplacementResult(true, replacement);
        return new RegexReplacementRule(regex){

            @Override
            protected ReplacementResult getResult(String name, Matcher matcher) {
                return replacementResult;
            }
        };
    }

    private static ReplacementRule getPrefixReplacementRule(String ... terms) {
        StringJoiner sj = new StringJoiner("|");
        for (String s2 : terms) {
            sj.add(s2);
        }
        return ThreadNameNormalizer.getGroupRegexReplacementRule('(' + sj.toString() + ").*", 1, true);
    }

    private static ReplacementRule getReplaceAfterMatchRule(String ... patterns) {
        final HashSet<String> patternsList = new HashSet<String>(Arrays.asList(patterns));
        for (String p : patterns) {
            patternsList.add(p.toUpperCase());
        }
        return new ReplacementRule(){

            @Override
            public ReplacementResult getResult(String name) {
                for (String p : patternsList) {
                    int index = name.indexOf(p);
                    if (index < 0) continue;
                    return new ReplacementResult(false, name.substring(0, index) + p + '#');
                }
                return null;
            }
        };
    }

    private static ReplacementRule getGroupRegexReplacementRule(String regex, final int groupId, final boolean stop) {
        return new RegexReplacementRule(regex){

            @Override
            protected ReplacementResult getResult(String name, Matcher matcher) {
                return new ReplacementResult(stop, matcher.group(groupId) + '#');
            }
        };
    }

    private static abstract class RegexReplacementRule
    implements ReplacementRule {
        private final Pattern pattern;

        public RegexReplacementRule(String regex) {
            this.pattern = Pattern.compile(regex);
        }

        @Override
        public ReplacementResult getResult(String name) {
            Matcher matcher = this.pattern.matcher(name);
            if (matcher.matches()) {
                return this.getResult(name, matcher);
            }
            return null;
        }

        protected abstract ReplacementResult getResult(String var1, Matcher var2);
    }

    private static interface ReplacementRule {
        public ReplacementResult getResult(String var1);
    }

    private static class ReplacementResult {
        final boolean stop;
        final String replacement;

        public ReplacementResult(boolean stop, String replacement) {
            this.stop = stop;
            this.replacement = replacement;
        }
    }
}

