/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.api.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.MetricNames;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.attributes.AgentAttributeSender;
import com.newrelic.agent.attributes.AttributeSender;
import com.newrelic.agent.attributes.CustomAttributeSender;
import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.bridge.PublicApi;
import com.newrelic.agent.bridge.TransactionNamePriority;
import com.newrelic.agent.config.ExpectedErrorConfig;
import com.newrelic.agent.deps.org.apache.commons.lang3.StringUtils;
import com.newrelic.agent.dispatchers.Dispatcher;
import com.newrelic.agent.errors.ErrorGroupCallbackHolder;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.transaction.TransactionNamingPolicy;
import com.newrelic.api.agent.ErrorGroupCallback;
import com.newrelic.api.agent.NewRelic;
import com.newrelic.api.agent.Request;
import com.newrelic.api.agent.Response;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

public class NewRelicApiImplementation
implements PublicApi {
    private final AttributeSender customAttributeSender;
    private final AgentAttributeSender agentAttributeSender;

    public NewRelicApiImplementation(AttributeSender customSender, AgentAttributeSender agentSender) {
        this.customAttributeSender = customSender;
        this.agentAttributeSender = agentSender;
    }

    public NewRelicApiImplementation() {
        this(new CustomAttributeSender(), new AgentAttributeSender());
    }

    public void noticeError(Throwable throwable, Map<String, ?> params) {
        this.noticeError(throwable, params, this.isExpectedErrorConfigured(throwable));
    }

    public void noticeError(Throwable throwable) {
        Map params = Collections.emptyMap();
        this.noticeError(throwable, params, this.isExpectedErrorConfigured(throwable));
    }

    public void noticeError(String message, Map<String, ?> params) {
        this.noticeError(message, params, false);
    }

    public void noticeError(String message) {
        Map params = Collections.emptyMap();
        this.noticeError(message, params, false);
    }

    public void noticeError(Throwable throwable, boolean expected) {
        Map params = Collections.emptyMap();
        this.noticeError(throwable, params, expected);
    }

    public void noticeError(Throwable throwable, Map<String, ?> params, boolean expected) {
        try {
            ServiceFactory.getRPMService().getErrorService().reportException(throwable, NewRelicApiImplementation.filterErrorAtts(params, this.customAttributeSender), expected);
            MetricNames.recordApiSupportabilityMetric("NoticeError");
            if (expected) {
                MetricNames.recordApiSupportabilityMetric("ExpectedError/Api/Throwable");
            }
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Reported error: {0}", throwable);
                Agent.LOG.finer(msg);
            }
        }
        catch (Throwable t2) {
            String msg = MessageFormat.format("Exception reporting exception \"{0}\": {1}", throwable, t2);
            NewRelicApiImplementation.logException(msg, t2);
        }
    }

    public void noticeError(String message, Map<String, ?> params, boolean expected) {
        try {
            ServiceFactory.getRPMService().getErrorService().reportError(message, NewRelicApiImplementation.filterErrorAtts(params, this.customAttributeSender), expected);
            MetricNames.recordApiSupportabilityMetric("NoticeError");
            if (expected) {
                MetricNames.recordApiSupportabilityMetric("ExpectedError/Api/Message");
            }
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Reported error: {0}", message);
                Agent.LOG.finer(msg);
            }
        }
        catch (Throwable t2) {
            String msg = MessageFormat.format("Exception reporting exception \"{0}\": {1}", message, t2);
            NewRelicApiImplementation.logException(msg, t2);
        }
    }

    public void noticeError(String message, boolean expected) {
        Map params = Collections.emptyMap();
        this.noticeError(message, params, expected);
    }

    private boolean isExpectedErrorConfigured(Throwable throwable) {
        if (throwable != null) {
            String expectedConfigName = throwable.getClass().getName();
            String message = throwable.getMessage();
            String app_name = (String)NewRelic.getAgent().getConfig().getValue("app_name");
            Set<ExpectedErrorConfig> expectedErrors = ServiceFactory.getConfigService().getErrorCollectorConfig(app_name).getExpectedErrors();
            for (ExpectedErrorConfig errorConfig : expectedErrors) {
                String errorClass = errorConfig.getErrorClass();
                String errorMessage = errorConfig.getErrorMessage();
                if ((!errorClass.equals(expectedConfigName) || errorMessage != null) && (errorMessage == null || !errorClass.equals(expectedConfigName) || !errorMessage.equals(message))) continue;
                return true;
            }
        }
        return false;
    }

    private static Map<String, ?> filterErrorAtts(Map<String, ?> params, AttributeSender attributeSender) {
        TreeMap<String, Object> attributes = new TreeMap<String, Object>();
        if (params == null) {
            return attributes;
        }
        int maxErrorCount = NewRelicApiImplementation.getNumberOfErrorAttsLeft();
        for (Map.Entry<String, ?> current : params.entrySet()) {
            if (attributes.size() >= maxErrorCount) {
                Agent.LOG.log(Level.FINE, "Unable to add custom attribute for key \"{0}\" because the limit on error attributes has been reached.", current.getKey());
                continue;
            }
            Object currentValue = current.getValue();
            String strValue = null;
            if (currentValue instanceof Number || currentValue instanceof Boolean || currentValue instanceof AtomicBoolean) {
                currentValue = attributeSender.verifyParameterAndReturnValue(current.getKey(), currentValue, "noticeError");
                if (currentValue == null) {
                    Agent.LOG.log(Level.FINE, "Unable to add custom attribute for key \"{0}\" because it is not a valid type.", current.getKey());
                    continue;
                }
                attributes.put(current.getKey(), currentValue);
                continue;
            }
            if (currentValue != null) {
                try {
                    strValue = currentValue.toString();
                }
                catch (Throwable t2) {
                    Agent.LOG.log(Level.FINE, "Unable to add custom attribute for key \"{0}\" because toString threw exception {1}.", current.getKey(), t2);
                    continue;
                }
            }
            if ((strValue = attributeSender.verifyParameterAndReturnValue(current.getKey(), strValue, "noticeError")) == null) continue;
            attributes.put(current.getKey(), strValue);
        }
        return attributes;
    }

    private static int getNumberOfErrorAttsLeft() {
        Transaction tx = Transaction.getTransaction(false);
        if (tx != null) {
            return 64 - tx.getErrorAttributes().size();
        }
        return 63;
    }

    public void addCustomParameter(String key, String value) {
        this.customAttributeSender.addAttribute(key, value, "addCustomParameter");
    }

    public void addCustomParameter(String key, Number value) {
        this.customAttributeSender.addAttribute(key, value, "addCustomParameter");
    }

    public void addCustomParameter(String key, boolean value) {
        this.customAttributeSender.addAttribute(key, value, "addCustomParameter");
    }

    public void addCustomParameters(Map<String, Object> params) {
        this.customAttributeSender.addAttributes(params, "addCustomParameters");
    }

    public void setUserId(String userId) {
        if (ServiceFactory.getConfigService().getDefaultAgentConfig().isHighSecurity()) {
            return;
        }
        String attributeKey = "enduser.id";
        String methodCalled = "setUserId";
        if (userId == null || userId.trim().isEmpty()) {
            Agent.LOG.log(Level.FINER, "Will not include the {0} attribute because {1} was invoked with a null or blank value", "enduser.id", "setUserId");
            this.agentAttributeSender.removeAttribute("enduser.id");
            return;
        }
        this.agentAttributeSender.addAttribute("enduser.id", userId, "setUserId");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransactionName(String category, String name) {
        TransactionNamePriority namePriority;
        Transaction tx;
        if (StringUtils.isEmpty(category)) {
            category = "Custom";
        }
        if (name == null || name.length() == 0) {
            Agent.LOG.log(Level.FINER, "Unable to set the transaction name to an empty string");
            return;
        }
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        if ((tx = Transaction.getTransaction(false)) == null) {
            return;
        }
        Dispatcher dispatcher = tx.getDispatcher();
        if (dispatcher == null) {
            if (Agent.LOG.isFinerEnabled()) {
                Agent.LOG.finer(MessageFormat.format("Unable to set the transaction name to \"{0}\" in NewRelic API - no transaction", name));
            }
            return;
        }
        boolean isWebTransaction = dispatcher.isWebTransaction();
        TransactionNamingPolicy policy = TransactionNamingPolicy.getSameOrHigherPriorityTransactionNamingPolicy();
        TransactionNamePriority transactionNamePriority = namePriority = "Uri".equals(category) ? TransactionNamePriority.REQUEST_URI : TransactionNamePriority.CUSTOM_HIGH;
        if (Agent.LOG.isLoggable(Level.FINER)) {
            if (policy.canSetTransactionName(tx, namePriority)) {
                String msg = MessageFormat.format("Setting {1} transaction name to \"{0}\" in NewRelic API", name, isWebTransaction ? "web" : "background");
                Agent.LOG.finer(msg);
            } else {
                Agent.LOG.finer("Unable to set the transaction name to " + name);
            }
        }
        Transaction transaction = tx;
        synchronized (transaction) {
            policy.setTransactionName(tx, name, category, namePriority);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ignoreTransaction() {
        Transaction tx = Transaction.getTransaction(false);
        if (tx != null) {
            Transaction transaction = tx;
            synchronized (transaction) {
                tx.setIgnore(true);
            }
            if (Agent.LOG.isLoggable(Level.FINER)) {
                Agent.LOG.finer("Set ignore transaction in NewRelic API");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ignoreApdex() {
        Transaction tx = Transaction.getTransaction(false);
        if (tx != null) {
            Transaction transaction = tx;
            synchronized (transaction) {
                tx.ignoreApdex();
            }
            if (Agent.LOG.isLoggable(Level.FINER)) {
                Agent.LOG.finer("Set ignore APDEX in NewRelic API");
            }
        }
    }

    public void setRequestAndResponse(Request request, Response response) {
        Transaction tx = Transaction.getTransaction(false);
        if (tx != null) {
            Agent.LOG.finest("Registering custom request dispatcher");
            tx.setRequestAndResponse(request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBrowserTimingHeaderForContentType(String contentType) {
        Transaction tx = Transaction.getTransaction(false);
        try {
            if (tx == null) {
                Agent.LOG.finer("Unable to inject browser timing header in a JSP: not running in a transaction");
                return "";
            }
            String header = null;
            Transaction transaction = tx;
            synchronized (transaction) {
                header = tx.getBrowserTransactionState().getBrowserTimingHeaderForJsp();
            }
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Injecting browser timing header in a JSP: {0}", header);
                Agent.LOG.log(Level.FINER, msg);
            }
            return header;
        }
        catch (Throwable t2) {
            String msg = MessageFormat.format("Error injecting browser timing header in a JSP: {0}", t2);
            NewRelicApiImplementation.logException(msg, t2);
            return "";
        }
    }

    public String getBrowserTimingHeader() {
        return this.getBrowserTimingHeader(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBrowserTimingHeader(String nonce) {
        Transaction tx = Transaction.getTransaction(false);
        try {
            if (tx == null) {
                Agent.LOG.finer("Unable to get browser timing header in NewRelic API: not running in a transaction");
                return "";
            }
            String header = null;
            Transaction transaction = tx;
            synchronized (transaction) {
                header = nonce == null ? tx.getBrowserTransactionState().getBrowserTimingHeader() : tx.getBrowserTransactionState().getBrowserTimingHeader(nonce);
            }
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Got browser timing header in NewRelic API: {0}", header);
                Agent.LOG.log(Level.FINER, msg);
            }
            return header;
        }
        catch (Throwable t2) {
            String msg = MessageFormat.format("Error getting browser timing header in NewRelic API: {0}", t2);
            NewRelicApiImplementation.logException(msg, t2);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBrowserTimingFooterForContentType(String contentType) {
        Transaction tx = Transaction.getTransaction(false);
        try {
            if (tx == null) {
                Agent.LOG.finer("Unable to inject browser timing footer in a JSP: not running in a transaction");
                return "";
            }
            String footer = null;
            Transaction transaction = tx;
            synchronized (transaction) {
                footer = tx.getBrowserTransactionState().getBrowserTimingFooter();
            }
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Injecting browser timing footer in a JSP: {0}", footer);
                Agent.LOG.log(Level.FINER, msg);
            }
            return footer;
        }
        catch (Throwable t2) {
            String msg = MessageFormat.format("Error injecting browser timing footer in a JSP: {0}", t2);
            NewRelicApiImplementation.logException(msg, t2);
            return "";
        }
    }

    public String getBrowserTimingFooter() {
        return this.getBrowserTimingFooter(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBrowserTimingFooter(String nonce) {
        Transaction tx = Transaction.getTransaction(false);
        try {
            if (tx == null) {
                Agent.LOG.finer("Unable to get browser timing footer in NewRelic API: not running in a transaction");
                return "";
            }
            String footer = null;
            Transaction transaction = tx;
            synchronized (transaction) {
                footer = nonce == null ? tx.getBrowserTransactionState().getBrowserTimingFooter() : tx.getBrowserTransactionState().getBrowserTimingFooter(nonce);
            }
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Got browser timing footer in NewRelic API: {0}", footer);
                Agent.LOG.log(Level.FINER, msg);
            }
            return footer;
        }
        catch (Throwable t2) {
            String msg = MessageFormat.format("Error getting browser timing footer in NewRelic API: {0}", t2);
            NewRelicApiImplementation.logException(msg, t2);
            return "";
        }
    }

    public void setUserName(String name) {
        if (ServiceFactory.getConfigService().getDefaultAgentConfig().isHighSecurity()) {
            return;
        }
        Transaction tx = Transaction.getTransaction(false);
        if (tx == null) {
            return;
        }
        Dispatcher dispatcher = tx.getDispatcher();
        if (dispatcher == null) {
            Agent.LOG.finer(MessageFormat.format("Unable to set the user name to \"{0}\" in NewRelic API - no transaction", name));
            return;
        }
        if (!dispatcher.isWebTransaction()) {
            Agent.LOG.finer(MessageFormat.format("Unable to set the user name to \"{0}\" in NewRelic API - transaction is not a web transaction", name));
            return;
        }
        if (Agent.LOG.isLoggable(Level.FINER)) {
            String msg = MessageFormat.format("Attempting to set user name to \"{0}\" in NewRelic API", name);
            Agent.LOG.finer(msg);
        }
        MetricNames.recordApiSupportabilityMetric("SetUserName");
        this.customAttributeSender.addAttribute("user", name, "setUserName");
    }

    public void setAccountName(String name) {
        Transaction tx = Transaction.getTransaction(false);
        if (tx != null) {
            Dispatcher dispatcher = tx.getDispatcher();
            if (dispatcher == null) {
                Agent.LOG.finer(MessageFormat.format("Unable to set the account name to \"{0}\" in NewRelic API - no transaction", name));
                return;
            }
            if (!dispatcher.isWebTransaction()) {
                Agent.LOG.finer(MessageFormat.format("Unable to set the account name to \"{0}\" in NewRelic API - transaction is not a web transaction", name));
                return;
            }
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Attempting to set account name to \"{0}\" in NewRelic API", name);
                Agent.LOG.finer(msg);
            }
            this.customAttributeSender.addAttribute("account", name, "setAccountName");
            MetricNames.recordApiSupportabilityMetric("SetAccountName");
        }
    }

    public void setProductName(String name) {
        Transaction tx = Transaction.getTransaction(false);
        if (tx != null) {
            Dispatcher dispatcher = tx.getDispatcher();
            if (dispatcher == null) {
                Agent.LOG.finer(MessageFormat.format("Unable to set the product name to \"{0}\" in NewRelic API - no transaction", name));
                return;
            }
            if (!dispatcher.isWebTransaction()) {
                Agent.LOG.finer(MessageFormat.format("Unable to set the product name to \"{0}\" in NewRelic API - transaction is not a web transaction", name));
                return;
            }
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Attempting to set product name to \"{0}\" in NewRelic API", name);
                Agent.LOG.finer(msg);
            }
            MetricNames.recordApiSupportabilityMetric("SetProductName");
            this.customAttributeSender.addAttribute("product", name, "setProductName");
        }
    }

    public void setAppServerPort(int port) {
        ServiceFactory.getEnvironmentService().getEnvironment().setServerPort(port);
        MetricNames.recordApiSupportabilityMetric("SetAppServerPort");
    }

    public void setServerInfo(String dispatcherName, String version) {
        ServiceFactory.getEnvironmentService().getEnvironment().setServerInfo(dispatcherName, version);
        MetricNames.recordApiSupportabilityMetric("SetServerInfo");
    }

    public void setInstanceName(String instanceName) {
        ServiceFactory.getEnvironmentService().getEnvironment().setInstanceName(instanceName);
        MetricNames.recordApiSupportabilityMetric("SetInstanceName");
    }

    public void setErrorGroupCallback(ErrorGroupCallback errorGroupCallback) {
        ErrorGroupCallbackHolder.setErrorGroupCallback(errorGroupCallback);
    }

    private static void logException(String msg, Throwable t2) {
        if (Agent.LOG.isLoggable(Level.FINEST)) {
            Agent.LOG.log(Level.FINEST, msg, t2);
        } else if (Agent.LOG.isLoggable(Level.FINER)) {
            Agent.LOG.finer(msg);
        }
    }

    public static void initialize() {
        AgentBridge.publicApi = new NewRelicApiImplementation();
    }
}

