/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracing;

import java.util.Objects;

public class W3CTraceParent {
    private static final byte FLAG_SAMPLED = 1;
    private final String version;
    private final String traceId;
    private final String parentId;
    private final int flags;

    public W3CTraceParent(String version, String traceId, String parentId, int flags) {
        this.version = version;
        this.traceId = traceId;
        this.parentId = parentId;
        this.flags = flags;
    }

    public String getParentId() {
        return this.parentId;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public String getVersion() {
        return this.version;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean sampled() {
        return (this.flags & 1) == 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        W3CTraceParent that = (W3CTraceParent)o;
        return this.flags == that.flags && Objects.equals(this.version, that.version) && Objects.equals(this.traceId, that.traceId) && Objects.equals(this.parentId, that.parentId);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.traceId, this.parentId, this.flags);
    }
}

