/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.stats;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.org.json.simple.JSONArray;
import com.newrelic.agent.stats.DataUsageStats;
import com.newrelic.agent.stats.StatsBase;
import com.newrelic.api.agent.NewRelic;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;

public class DataUsageStatsImpl
implements DataUsageStats {
    private static final int UNUSED = 0;
    private final AtomicInteger count = new AtomicInteger(0);
    private final AtomicLong bytesSent = new AtomicLong(0L);
    private final AtomicLong bytesReceived = new AtomicLong(0L);

    protected DataUsageStatsImpl() {
    }

    @Override
    public void recordDataUsage(long bytesSent, long bytesReceived) {
        this.count.incrementAndGet();
        this.bytesSent.addAndGet(bytesSent);
        this.bytesReceived.addAndGet(bytesReceived);
        if (((Boolean)NewRelic.getAgent().getConfig().getValue("metric_debug", (Object)false)).booleanValue() && (this.count.get() < 0 || this.bytesSent.get() < 0L || this.bytesReceived.get() < 0L)) {
            NewRelic.incrementCounter((String)"Supportability/DataUsageStatsImpl/NegativeValue");
            Agent.LOG.log(Level.INFO, "Invalid count {0}, bytesSent {1}, or bytesReceived {2}", this.count.get(), this.bytesSent.get(), this.bytesReceived.get());
        }
    }

    @Override
    public int getCount() {
        return this.count.get();
    }

    @Override
    public long getBytesSent() {
        return this.bytesSent.get();
    }

    @Override
    public long getBytesReceived() {
        return this.bytesReceived.get();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DataUsageStatsImpl newStats = new DataUsageStatsImpl();
        newStats.count.set(this.count.get());
        newStats.bytesSent.set(this.bytesSent.get());
        newStats.bytesReceived.set(this.bytesReceived.get());
        return newStats;
    }

    public String toString() {
        return super.toString() + " [count=" + this.count.get() + ", bytesSent=" + this.bytesSent.get() + ", bytesReceived=" + this.bytesReceived.get() + "]";
    }

    @Override
    public boolean hasData() {
        return this.count.get() > 0 || this.bytesSent.get() > 0L || this.bytesReceived.get() > 0L;
    }

    @Override
    public void reset() {
        this.count.set(0);
        this.bytesSent.set(0L);
        this.bytesReceived.set(0L);
    }

    @Override
    public void writeJSONString(Writer writer) throws IOException {
        List<Number> data = Arrays.asList(this.count.get(), this.bytesSent.get(), this.bytesReceived.get(), 0, 0, 0);
        JSONArray.writeJSONString(data, writer);
    }

    @Override
    public void merge(StatsBase statsObj) {
        if (statsObj instanceof DataUsageStatsImpl) {
            DataUsageStatsImpl stats = (DataUsageStatsImpl)statsObj;
            this.count.addAndGet(stats.count.get());
            this.bytesSent.addAndGet(stats.bytesSent.get());
            this.bytesReceived.addAndGet(stats.bytesReceived.get());
        }
    }
}

