/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service;

import com.newrelic.InfiniteTracing;
import com.newrelic.InfiniteTracingConfig;
import com.newrelic.agent.Agent;
import com.newrelic.agent.ExpirationService;
import com.newrelic.agent.GCService;
import com.newrelic.agent.HarvestService;
import com.newrelic.agent.HarvestServiceImpl;
import com.newrelic.agent.RPMServiceManager;
import com.newrelic.agent.RPMServiceManagerImpl;
import com.newrelic.agent.ThreadService;
import com.newrelic.agent.TracerService;
import com.newrelic.agent.TransactionService;
import com.newrelic.agent.attributes.AttributesService;
import com.newrelic.agent.browser.BrowserService;
import com.newrelic.agent.browser.BrowserServiceImpl;
import com.newrelic.agent.cache.CacheService;
import com.newrelic.agent.circuitbreaker.CircuitBreakerService;
import com.newrelic.agent.commands.CommandParser;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.ConfigService;
import com.newrelic.agent.config.JfrConfig;
import com.newrelic.agent.config.JmxConfig;
import com.newrelic.agent.core.CoreService;
import com.newrelic.agent.database.DatabaseService;
import com.newrelic.agent.deadlock.DeadlockDetectorService;
import com.newrelic.agent.environment.EnvironmentService;
import com.newrelic.agent.environment.EnvironmentServiceImpl;
import com.newrelic.agent.extension.ExtensionService;
import com.newrelic.agent.instrumentation.ClassTransformerService;
import com.newrelic.agent.instrumentation.ClassTransformerServiceImpl;
import com.newrelic.agent.jfr.JfrService;
import com.newrelic.agent.jmx.JmxService;
import com.newrelic.agent.language.SourceLanguageService;
import com.newrelic.agent.logging.IAgentLogger;
import com.newrelic.agent.normalization.NormalizationService;
import com.newrelic.agent.normalization.NormalizationServiceImpl;
import com.newrelic.agent.profile.ProfilerService;
import com.newrelic.agent.reinstrument.RemoteInstrumentationService;
import com.newrelic.agent.reinstrument.RemoteInstrumentationServiceImpl;
import com.newrelic.agent.rpm.RPMConnectionService;
import com.newrelic.agent.rpm.RPMConnectionServiceImpl;
import com.newrelic.agent.samplers.CPUSamplerService;
import com.newrelic.agent.samplers.NoopSamplerService;
import com.newrelic.agent.samplers.SamplerService;
import com.newrelic.agent.samplers.SamplerServiceImpl;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.JfrServiceConnectionListener;
import com.newrelic.agent.service.NoopService;
import com.newrelic.agent.service.Service;
import com.newrelic.agent.service.ServiceManager;
import com.newrelic.agent.service.ServiceTiming;
import com.newrelic.agent.service.SpanEventsServiceFactory;
import com.newrelic.agent.service.StatsServiceMetricAggregator;
import com.newrelic.agent.service.UpdateInfiniteTracingAfterConnect;
import com.newrelic.agent.service.analytics.InfiniteTracingEnabledCheck;
import com.newrelic.agent.service.analytics.InsightsService;
import com.newrelic.agent.service.analytics.InsightsServiceImpl;
import com.newrelic.agent.service.analytics.SpanEventCreationDecider;
import com.newrelic.agent.service.analytics.SpanEventsService;
import com.newrelic.agent.service.analytics.TransactionDataToDistributedTraceIntrinsics;
import com.newrelic.agent.service.analytics.TransactionEventsService;
import com.newrelic.agent.service.async.AsyncTransactionService;
import com.newrelic.agent.service.logging.LogSenderService;
import com.newrelic.agent.service.logging.LogSenderServiceImpl;
import com.newrelic.agent.service.module.JarAnalystFactory;
import com.newrelic.agent.service.module.JarCollectorConnectionListener;
import com.newrelic.agent.service.module.JarCollectorHarvestListener;
import com.newrelic.agent.service.module.JarCollectorInputs;
import com.newrelic.agent.service.module.JarCollectorService;
import com.newrelic.agent.service.module.JarCollectorServiceImpl;
import com.newrelic.agent.service.module.JarCollectorServiceProcessor;
import com.newrelic.agent.service.module.JarData;
import com.newrelic.agent.service.module.TrackedAddSet;
import com.newrelic.agent.sql.SqlTraceService;
import com.newrelic.agent.sql.SqlTraceServiceImpl;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.stats.StatsService;
import com.newrelic.agent.stats.StatsServiceImpl;
import com.newrelic.agent.stats.StatsWork;
import com.newrelic.agent.trace.TransactionTraceService;
import com.newrelic.agent.tracing.DistributedTraceService;
import com.newrelic.agent.tracing.DistributedTraceServiceImpl;
import com.newrelic.agent.util.DefaultThreadFactory;
import com.newrelic.agent.utilization.UtilizationService;
import com.newrelic.api.agent.Logger;
import com.newrelic.api.agent.MetricAggregator;
import com.newrelic.api.agent.NewRelic;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

public class ServiceManagerImpl
extends AbstractService
implements ServiceManager {
    private final ConcurrentMap<String, Service> services = new ConcurrentHashMap<String, Service>();
    private final CoreService coreService;
    private final ConfigService configService;
    private final BlockingQueue<StatsWork> statsWork = new LinkedBlockingQueue<StatsWork>();
    private volatile ExtensionService extensionService;
    private volatile ProfilerService profilerService;
    private volatile TracerService tracerService;
    private volatile TransactionTraceService transactionTraceService;
    private volatile ThreadService threadService;
    private volatile HarvestService harvestService;
    private volatile Service gcService;
    private volatile TransactionService transactionService;
    private volatile JfrService jfrService;
    private volatile JmxService jmxService;
    private volatile TransactionEventsService transactionEventsService;
    private volatile CommandParser commandParser;
    private volatile RPMServiceManager rpmServiceManager;
    private volatile Service cpuSamplerService;
    private volatile DeadlockDetectorService deadlockDetectorService;
    private volatile SamplerService samplerService;
    private volatile RPMConnectionService rpmConnectionService;
    private volatile EnvironmentService environmentService;
    private volatile ClassTransformerService classTransformerService;
    private volatile StatsService statsService = new InitialStatsService();
    private volatile SqlTraceService sqlTraceService;
    private volatile DatabaseService databaseService;
    private volatile BrowserService browserService;
    private volatile JarCollectorService jarCollectorService;
    private volatile CacheService cacheService;
    private volatile NormalizationService normalizationService;
    private volatile RemoteInstrumentationService remoteInstrumentationService;
    private volatile AttributesService attsService;
    private volatile UtilizationService utilizationService;
    private volatile InsightsService insightsService;
    private volatile LogSenderService logSenderService;
    private volatile AsyncTransactionService asyncTxService;
    private volatile CircuitBreakerService circuitBreakerService;
    private volatile DistributedTraceServiceImpl distributedTraceService;
    private volatile SpanEventsService spanEventsService;
    private volatile SourceLanguageService sourceLanguageService;
    private volatile ExpirationService expirationService;

    public ServiceManagerImpl(CoreService coreService, ConfigService configService) {
        super(ServiceManagerImpl.class.getSimpleName());
        this.coreService = coreService;
        this.configService = configService;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    protected synchronized void doStart() throws Exception {
        this.coreService.start();
        this.threadService = new ThreadService();
        this.circuitBreakerService = new CircuitBreakerService();
        this.classTransformerService = new ClassTransformerServiceImpl(this.coreService.getInstrumentation());
        AgentConfig config = this.configService.getDefaultAgentConfig();
        JmxConfig jmxConfig = config.getJmxConfig();
        this.jmxService = new JmxService(jmxConfig);
        IAgentLogger jarCollectorLogger = Agent.LOG.getChildLogger("com.newrelic.jar_collector");
        boolean jarCollectorEnabled = this.configService.getDefaultAgentConfig().getJarCollectorConfig().isEnabled();
        AtomicBoolean shouldSendAllJars = new AtomicBoolean(true);
        TrackedAddSet<JarData> analyzedJars = new TrackedAddSet<JarData>();
        JarCollectorServiceProcessor processor = new JarCollectorServiceProcessor(jarCollectorLogger, this.configService.getDefaultAgentConfig());
        JarAnalystFactory jarAnalystFactory = new JarAnalystFactory(processor, analyzedJars, jarCollectorLogger);
        ExecutorService executorService = Executors.newSingleThreadExecutor(new DefaultThreadFactory("New Relic Jar Analysis Thread", true));
        JarCollectorInputs jarCollectorInputs = JarCollectorInputs.build(jarCollectorEnabled, jarAnalystFactory, executorService, jarCollectorLogger);
        this.jarCollectorService = new JarCollectorServiceImpl(jarCollectorLogger, jarCollectorEnabled, shouldSendAllJars, analyzedJars, jarCollectorInputs.getClassNoticingFactory());
        this.extensionService = new ExtensionService(this.configService, jarCollectorInputs.getExtensionAnalysisProducer());
        String defaultAppName = this.configService.getDefaultAgentConfig().getApplicationName();
        JarCollectorConnectionListener jarCollectorConnectionListener = new JarCollectorConnectionListener(defaultAppName, shouldSendAllJars);
        JarCollectorHarvestListener jarCollectorHarvestListener = new JarCollectorHarvestListener(defaultAppName, this.jarCollectorService);
        this.sourceLanguageService = new SourceLanguageService();
        this.expirationService = new ExpirationService();
        this.tracerService = new TracerService();
        this.asyncTxService = new AsyncTransactionService();
        this.environmentService = new EnvironmentServiceImpl();
        this.cacheService = new CacheService();
        this.extensionService.start();
        this.classTransformerService.start();
        boolean realAgent = this.coreService.getInstrumentation() != null;
        this.statsService = new StatsServiceImpl();
        this.replayStartupStatsWork();
        this.utilizationService = new UtilizationService();
        if (realAgent) {
            this.utilizationService.start();
        }
        this.rpmConnectionService = new RPMConnectionServiceImpl();
        this.transactionService = new TransactionService();
        InfiniteTracing infiniteTracing = this.buildInfiniteTracing(this.configService);
        InfiniteTracingEnabledCheck infiniteTracingEnabledCheck = new InfiniteTracingEnabledCheck(this.configService);
        SpanEventCreationDecider spanEventCreationDecider = new SpanEventCreationDecider(this.configService);
        UpdateInfiniteTracingAfterConnect agentConnectionEstablishedListener = new UpdateInfiniteTracingAfterConnect(infiniteTracingEnabledCheck, infiniteTracing);
        JfrConfig jfrConfig = config.getJfrConfig();
        this.jfrService = new JfrService(jfrConfig, this.configService.getDefaultAgentConfig());
        JfrServiceConnectionListener jfrServiceConnectionListener = new JfrServiceConnectionListener(this.jfrService);
        this.distributedTraceService = new DistributedTraceServiceImpl();
        TransactionDataToDistributedTraceIntrinsics transactionDataToDistributedTraceIntrinsics = new TransactionDataToDistributedTraceIntrinsics(this.distributedTraceService);
        this.rpmServiceManager = new RPMServiceManagerImpl(agentConnectionEstablishedListener, jarCollectorConnectionListener, jfrServiceConnectionListener);
        this.normalizationService = new NormalizationServiceImpl();
        this.harvestService = new HarvestServiceImpl();
        this.gcService = realAgent ? new GCService() : new NoopService("GC Service");
        this.transactionTraceService = new TransactionTraceService();
        this.transactionEventsService = new TransactionEventsService(transactionDataToDistributedTraceIntrinsics);
        this.profilerService = new ProfilerService();
        this.commandParser = new CommandParser();
        this.cpuSamplerService = realAgent ? new CPUSamplerService() : new NoopService("CPU Sampler");
        this.deadlockDetectorService = new DeadlockDetectorService();
        this.samplerService = realAgent ? new SamplerServiceImpl() : new NoopSamplerService();
        this.sqlTraceService = new SqlTraceServiceImpl();
        this.databaseService = new DatabaseService();
        this.browserService = new BrowserServiceImpl();
        this.remoteInstrumentationService = new RemoteInstrumentationServiceImpl();
        this.attsService = new AttributesService();
        this.insightsService = new InsightsServiceImpl();
        this.logSenderService = new LogSenderServiceImpl();
        this.spanEventsService = SpanEventsServiceFactory.builder().configService(this.configService).rpmServiceManager(this.rpmServiceManager).transactionService(this.transactionService).infiniteTracingConsumer(infiniteTracing).spanEventCreationDecider(spanEventCreationDecider).environmentService(this.environmentService).transactionDataToDistributedTraceIntrinsics(transactionDataToDistributedTraceIntrinsics).build();
        this.harvestService.addHarvestListener(this.extensionService);
        this.harvestService.addHarvestListener(jarCollectorHarvestListener);
        this.asyncTxService.start();
        this.threadService.start();
        this.statsService.start();
        this.environmentService.start();
        this.rpmConnectionService.start();
        this.tracerService.start();
        this.jarCollectorService.start();
        this.sourceLanguageService.start();
        this.harvestService.start();
        this.gcService.start();
        this.transactionService.start();
        this.transactionTraceService.start();
        this.transactionEventsService.start();
        this.profilerService.start();
        this.commandParser.start();
        this.jmxService.start();
        this.cpuSamplerService.start();
        this.deadlockDetectorService.start();
        this.samplerService.start();
        this.sqlTraceService.start();
        this.browserService.start();
        this.cacheService.start();
        this.normalizationService.start();
        this.databaseService.start();
        this.configService.start();
        this.remoteInstrumentationService.start();
        this.attsService.start();
        this.insightsService.start();
        this.logSenderService.start();
        this.circuitBreakerService.start();
        this.distributedTraceService.start();
        this.spanEventsService.start();
        this.startServices();
        this.rpmServiceManager.start();
        ServiceTiming.setEndTime();
        ServiceTiming.logServiceTimings(this.getLogger());
    }

    private InfiniteTracing buildInfiniteTracing(ConfigService configService) {
        com.newrelic.agent.config.InfiniteTracingConfig config = configService.getDefaultAgentConfig().getInfiniteTracingConfig();
        InfiniteTracingConfig infiniteTracingConfig = InfiniteTracingConfig.builder().maxQueueSize(config.getSpanEventsQueueSize()).logger(Agent.LOG.getChildLogger("com.newrelic.infinite_tracing")).host(config.getTraceObserverHost()).port(config.getTraceObserverPort()).licenseKey(configService.getDefaultAgentConfig().getLicenseKey()).flakyPercentage(config.getFlakyPercentage()).flakyCode(config.getFlakyCode()).usePlaintext(config.getUsePlaintext()).useCompression(config.getUseCompression()).useBatching(config.getUseBatching()).build();
        return InfiniteTracing.initialize(infiniteTracingConfig, NewRelic.getAgent().getMetricAggregator());
    }

    @Override
    protected synchronized void doStop() throws Exception {
        this.insightsService.stop();
        this.logSenderService.stop();
        this.circuitBreakerService.stop();
        this.remoteInstrumentationService.stop();
        this.configService.stop();
        this.classTransformerService.stop();
        this.coreService.stop();
        this.rpmConnectionService.stop();
        this.deadlockDetectorService.stop();
        this.jarCollectorService.stop();
        this.harvestService.stop();
        this.cpuSamplerService.stop();
        this.samplerService.stop();
        this.sqlTraceService.stop();
        this.normalizationService.stop();
        this.databaseService.stop();
        this.extensionService.stop();
        this.transactionService.stop();
        this.tracerService.stop();
        this.threadService.stop();
        this.transactionTraceService.stop();
        this.transactionEventsService.stop();
        this.profilerService.stop();
        this.commandParser.stop();
        this.jfrService.stop();
        this.jmxService.stop();
        this.rpmServiceManager.stop();
        this.environmentService.stop();
        this.statsService.stop();
        this.browserService.stop();
        this.cacheService.stop();
        this.attsService.stop();
        this.sourceLanguageService.stop();
        this.utilizationService.stop();
        this.asyncTxService.stop();
        this.gcService.stop();
        this.distributedTraceService.stop();
        this.spanEventsService.stop();
        this.stopServices();
    }

    private void startServices() throws Exception {
        for (Service service : this.services.values()) {
            service.start();
        }
    }

    private void stopServices() throws Exception {
        for (Service service : this.services.values()) {
            service.stop();
        }
    }

    @Override
    public void addService(Service service) {
        this.services.put(service.getName(), service);
    }

    @Override
    public Map<String, Map<String, Object>> getServicesConfiguration() {
        HashMap<String, Map<String, Object>> config = new HashMap<String, Map<String, Object>>();
        HashMap<String, Boolean> serviceInfo = new HashMap<String, Boolean>();
        serviceInfo.put("enabled", this.transactionService.isEnabled());
        config.put("TransactionService", serviceInfo);
        serviceInfo = new HashMap();
        config.put("TransactionTraceService", serviceInfo);
        serviceInfo.put("enabled", this.transactionTraceService.isEnabled());
        serviceInfo = new HashMap();
        config.put("TransactionEventsService", serviceInfo);
        serviceInfo.put("enabled", this.transactionEventsService.isEnabled());
        serviceInfo = new HashMap();
        serviceInfo.put("enabled", this.profilerService.isEnabled());
        config.put("ProfilerService", serviceInfo);
        serviceInfo = new HashMap();
        serviceInfo.put("enabled", this.tracerService.isEnabled());
        config.put("TracerService", serviceInfo);
        serviceInfo = new HashMap();
        serviceInfo.put("enabled", this.commandParser.isEnabled());
        config.put("CommandParser", serviceInfo);
        serviceInfo = new HashMap();
        serviceInfo.put("enabled", this.jfrService.isEnabled());
        config.put("JfrService", serviceInfo);
        serviceInfo = new HashMap();
        serviceInfo.put("enabled", this.jmxService.isEnabled());
        config.put("JmxService", serviceInfo);
        serviceInfo = new HashMap();
        serviceInfo.put("enabled", this.threadService.isEnabled());
        config.put("ThreadService", serviceInfo);
        serviceInfo = new HashMap();
        serviceInfo.put("enabled", this.deadlockDetectorService.isEnabled());
        config.put("DeadlockService", serviceInfo);
        for (Service service : this.services.values()) {
            serviceInfo = new HashMap();
            serviceInfo.put("enabled", service.isEnabled());
            config.put(service.getClass().getSimpleName(), serviceInfo);
        }
        return config;
    }

    @Override
    public Service getService(String name) {
        return (Service)this.services.get(name);
    }

    @Override
    public ExtensionService getExtensionService() {
        return this.extensionService;
    }

    @Override
    public ProfilerService getProfilerService() {
        return this.profilerService;
    }

    @Override
    public TracerService getTracerService() {
        return this.tracerService;
    }

    @Override
    public TransactionTraceService getTransactionTraceService() {
        return this.transactionTraceService;
    }

    @Override
    public ThreadService getThreadService() {
        return this.threadService;
    }

    @Override
    public HarvestService getHarvestService() {
        return this.harvestService;
    }

    @Override
    public TransactionService getTransactionService() {
        return this.transactionService;
    }

    @Override
    public JfrService getJfrService() {
        return this.jfrService;
    }

    @Override
    public JmxService getJmxService() {
        return this.jmxService;
    }

    @Override
    public TransactionEventsService getTransactionEventsService() {
        return this.transactionEventsService;
    }

    @Override
    public CommandParser getCommandParser() {
        return this.commandParser;
    }

    @Override
    public RPMServiceManager getRPMServiceManager() {
        return this.rpmServiceManager;
    }

    @Override
    public SamplerService getSamplerService() {
        return this.samplerService;
    }

    @Override
    public CoreService getCoreService() {
        return this.coreService;
    }

    @Override
    public ConfigService getConfigService() {
        return this.configService;
    }

    @Override
    public RPMConnectionService getRPMConnectionService() {
        return this.rpmConnectionService;
    }

    @Override
    public EnvironmentService getEnvironmentService() {
        return this.environmentService;
    }

    @Override
    public ClassTransformerService getClassTransformerService() {
        return this.classTransformerService;
    }

    @Override
    public StatsService getStatsService() {
        return this.statsService;
    }

    @Override
    public SqlTraceService getSqlTraceService() {
        return this.sqlTraceService;
    }

    @Override
    public DatabaseService getDatabaseService() {
        return this.databaseService;
    }

    @Override
    public CacheService getCacheService() {
        return this.cacheService;
    }

    @Override
    public AsyncTransactionService getAsyncTxService() {
        return this.asyncTxService;
    }

    @Override
    public BrowserService getBrowserService() {
        return this.browserService;
    }

    @Override
    public NormalizationService getNormalizationService() {
        return this.normalizationService;
    }

    @Override
    public JarCollectorService getJarCollectorService() {
        return this.jarCollectorService;
    }

    @Override
    public RemoteInstrumentationService getRemoteInstrumentationService() {
        return this.remoteInstrumentationService;
    }

    @Override
    public AttributesService getAttributesService() {
        return this.attsService;
    }

    @Override
    public InsightsService getInsights() {
        return this.insightsService;
    }

    @Override
    public LogSenderService getLogSenderService() {
        return this.logSenderService;
    }

    @Override
    public CircuitBreakerService getCircuitBreakerService() {
        return this.circuitBreakerService;
    }

    private void replayStartupStatsWork() {
        for (StatsWork work : this.statsWork) {
            this.statsService.doStatsWork(work, this.statsService.getName());
        }
        this.statsWork.clear();
    }

    @Override
    public UtilizationService getUtilizationService() {
        return this.utilizationService;
    }

    @Override
    public DistributedTraceService getDistributedTraceService() {
        return this.distributedTraceService;
    }

    @Override
    public SpanEventsService getSpanEventsService() {
        return this.spanEventsService;
    }

    @Override
    public SourceLanguageService getSourceLanguageService() {
        return this.sourceLanguageService;
    }

    @Override
    public ExpirationService getExpirationService() {
        return this.expirationService;
    }

    private class InitialStatsService
    extends AbstractService
    implements StatsService {
        private final MetricAggregator metricAggregator;
        private final Logger initialStatsServiceLogger;

        protected InitialStatsService() {
            super("Bootstrap stats service");
            this.metricAggregator = new StatsServiceMetricAggregator(this);
            this.initialStatsServiceLogger = Agent.LOG.getChildLogger("com.newrelic.InitialStatsService");
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void doStatsWork(StatsWork statsWork, String statsWorkName) {
            if (statsWork != null) {
                ServiceManagerImpl.this.statsWork.add(statsWork);
            } else {
                this.initialStatsServiceLogger.log(Level.WARNING, "Problem adding a StatsWork to queue in InitialStatsService. StatsWork was null for: " + statsWorkName);
            }
        }

        @Override
        public StatsEngine getStatsEngineForHarvest(String appName) {
            return null;
        }

        @Override
        protected void doStart() throws Exception {
        }

        @Override
        protected void doStop() throws Exception {
        }

        @Override
        public MetricAggregator getMetricAggregator() {
            return this.metricAggregator;
        }
    }
}

