/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile.v2;

import com.newrelic.agent.deps.org.json.simple.JSONArray;
import com.newrelic.agent.profile.v2.ProfileSegment;
import com.newrelic.agent.profile.v2.ProfiledMethod;
import com.newrelic.agent.tracers.Tracer;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class TraceProfileSegment
extends ProfileSegment {
    private final AtomicInteger runnableCallCount = new AtomicInteger();
    private final AtomicLong totalDurationInNanos = new AtomicLong();
    private final AtomicLong exclusiveDurationInNanos = new AtomicLong();

    private TraceProfileSegment(ProfiledMethod method) {
        super(method);
    }

    public static TraceProfileSegment newProfileSegment(ProfiledMethod method) {
        if (method == null) {
            return null;
        }
        return new TraceProfileSegment(method);
    }

    protected TraceProfileSegment createProfileSegment(ProfiledMethod method) {
        return TraceProfileSegment.newProfileSegment(method);
    }

    @Override
    public void writeJSONString(Writer out) throws IOException {
        JSONArray.writeJSONString(Arrays.asList(this.method, this.runnableCallCount.get(), TimeUnit.NANOSECONDS.toMillis(this.totalDurationInNanos.get()), TimeUnit.NANOSECONDS.toMillis(this.exclusiveDurationInNanos.get()), new ArrayList(this.children.values())), out);
    }

    public String toString() {
        return this.method.toString();
    }

    @Override
    protected int getRunnableCallCount() {
        return this.runnableCallCount.get();
    }

    @Override
    public void incrementCallCount(boolean runnable2) {
        this.runnableCallCount.incrementAndGet();
    }

    @Override
    public int getCallSiteCount() {
        int count = 1;
        for (ProfileSegment segment : this.children.values()) {
            count += segment.getCallSiteCount();
        }
        return count;
    }

    @Override
    public int getCallCount(ProfiledMethod method) {
        int count = method.equals(this.getMethod()) ? this.runnableCallCount.get() : 0;
        for (ProfileSegment kid : this.children.values()) {
            count += kid.getCallCount(method);
        }
        return count;
    }

    public void update(Tracer tracer) {
        this.totalDurationInNanos.getAndAdd(tracer.getDuration());
        this.exclusiveDurationInNanos.getAndAdd(tracer.getExclusiveDuration());
    }
}

