/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.methodmatchers;

import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import java.util.Set;
import java.util.regex.Pattern;

public final class LambdaMethodMatcher
implements MethodMatcher {
    private final int ACCESS_SYNTHETIC_STATIC = 4121;
    private final Pattern lambdaMethodPattern;
    private final boolean includeNonstatic;

    public LambdaMethodMatcher(String pattern, boolean includeNonstatic) {
        this.lambdaMethodPattern = Pattern.compile(pattern);
        this.includeNonstatic = includeNonstatic;
    }

    @Override
    public boolean matches(int access, String name, String desc, Set<String> annotations) {
        return (this.includeNonstatic || access == 4121 || access == -1) && this.lambdaMethodPattern.matcher(name).matches();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public Method[] getExactMethods() {
        return null;
    }
}

