/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deps.org.apache.logging.log4j.core.osgi;

import com.newrelic.agent.deps.org.apache.logging.log4j.LogManager;
import com.newrelic.agent.deps.org.apache.logging.log4j.Logger;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.config.plugins.util.PluginRegistry;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.impl.Log4jProvider;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.impl.ThreadContextDataInjector;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.impl.ThreadContextDataProvider;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.osgi.BundleContextSelector;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.util.ContextDataProvider;
import com.newrelic.agent.deps.org.apache.logging.log4j.spi.Provider;
import com.newrelic.agent.deps.org.apache.logging.log4j.status.StatusLogger;
import com.newrelic.agent.deps.org.apache.logging.log4j.util.PropertiesUtil;
import com.newrelic.agent.deps.org.osgi.framework.Bundle;
import com.newrelic.agent.deps.org.osgi.framework.BundleActivator;
import com.newrelic.agent.deps.org.osgi.framework.BundleContext;
import com.newrelic.agent.deps.org.osgi.framework.BundleEvent;
import com.newrelic.agent.deps.org.osgi.framework.BundleListener;
import com.newrelic.agent.deps.org.osgi.framework.InvalidSyntaxException;
import com.newrelic.agent.deps.org.osgi.framework.ServiceReference;
import com.newrelic.agent.deps.org.osgi.framework.ServiceRegistration;
import com.newrelic.agent.deps.org.osgi.framework.SynchronousBundleListener;
import com.newrelic.agent.deps.org.osgi.framework.wiring.BundleWiring;
import java.util.Collection;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicReference;

public final class Activator
implements BundleActivator,
SynchronousBundleListener {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final AtomicReference<BundleContext> contextRef = new AtomicReference();
    ServiceRegistration provideRegistration = null;
    ServiceRegistration contextDataRegistration = null;

    public void start(BundleContext context) throws Exception {
        Log4jProvider provider = new Log4jProvider();
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("APIVersion", "2.60");
        ThreadContextDataProvider threadContextProvider = new ThreadContextDataProvider();
        this.provideRegistration = context.registerService(Provider.class.getName(), (Object)provider, props);
        this.contextDataRegistration = context.registerService(ContextDataProvider.class.getName(), (Object)threadContextProvider, null);
        Activator.loadContextProviders(context);
        if (PropertiesUtil.getProperties().getStringProperty("Log4jContextSelector") == null) {
            System.setProperty("Log4jContextSelector", BundleContextSelector.class.getName());
        }
        if (this.contextRef.compareAndSet(null, context)) {
            context.addBundleListener((BundleListener)this);
            Activator.scanInstalledBundlesForPlugins(context);
        }
    }

    private static void scanInstalledBundlesForPlugins(BundleContext context) {
        Bundle[] bundles;
        for (Bundle bundle : bundles = context.getBundles()) {
            Activator.scanBundleForPlugins(bundle);
        }
    }

    private static void scanBundleForPlugins(Bundle bundle) {
        long bundleId = bundle.getBundleId();
        if (bundle.getState() == 32 && bundleId != 0L) {
            LOGGER.trace("Scanning bundle [{}, id=%d] for plugins.", (Object)bundle.getSymbolicName(), (Object)bundleId);
            PluginRegistry.getInstance().loadFromBundle(bundleId, ((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader());
        }
    }

    private static void loadContextProviders(BundleContext bundleContext) {
        try {
            Collection serviceReferences = bundleContext.getServiceReferences(ContextDataProvider.class, null);
            for (ServiceReference serviceReference : serviceReferences) {
                ContextDataProvider provider = (ContextDataProvider)bundleContext.getService(serviceReference);
                ThreadContextDataInjector.contextDataProviders.add(provider);
            }
        }
        catch (InvalidSyntaxException ex) {
            LOGGER.error("Error accessing context data provider", (Throwable)ex);
        }
    }

    private static void stopBundlePlugins(Bundle bundle) {
        LOGGER.trace("Stopping bundle [{}] plugins.", (Object)bundle.getSymbolicName());
        PluginRegistry.getInstance().clearBundlePlugins(bundle.getBundleId());
    }

    public void stop(BundleContext context) throws Exception {
        this.provideRegistration.unregister();
        this.contextDataRegistration.unregister();
        this.contextRef.compareAndSet(context, null);
        LogManager.shutdown();
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 2: {
                Activator.scanBundleForPlugins(event.getBundle());
                break;
            }
            case 256: {
                Activator.stopBundlePlugins(event.getBundle());
                break;
            }
        }
    }
}

