/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.config.BaseConfig;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AuditModeConfig
extends BaseConfig {
    public static final String ENABLED = "enabled";
    public static final boolean DEFAULT_ENABLED = false;
    public static final String ENDPOINTS = "endpoints";
    public static final String PROPERTY_NAME = "audit_mode";
    public static final String NESTED_PROPERTY_ROOT = "newrelic.config.audit_mode.";
    private boolean isEnabled;
    private Set<String> endpoints;

    public AuditModeConfig(boolean auditModeEnabled, boolean traceDataCalls) {
        super(null, null);
        this.isEnabled = auditModeEnabled || traceDataCalls;
    }

    public AuditModeConfig(Map<String, Object> pProps) {
        super(pProps, NESTED_PROPERTY_ROOT);
        this.isEnabled = this.getProperty(ENABLED, false);
        this.endpoints = new HashSet<String>(this.getUniqueStrings(ENDPOINTS, ","));
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public Set<String> getEndpoints() {
        return this.endpoints;
    }
}

