/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.HeadersUtil;
import com.newrelic.agent.Segment;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionActivity;
import com.newrelic.agent.bridge.CrossProcessState;
import com.newrelic.agent.bridge.NoOpCrossProcessState;
import com.newrelic.agent.bridge.NoOpDistributedTracePayload;
import com.newrelic.agent.bridge.NoOpSegment;
import com.newrelic.agent.bridge.NoOpToken;
import com.newrelic.agent.bridge.NoOpTracedMethod;
import com.newrelic.agent.bridge.NoOpTransaction;
import com.newrelic.agent.bridge.NoOpWebResponse;
import com.newrelic.agent.bridge.Token;
import com.newrelic.agent.bridge.TracedActivity;
import com.newrelic.agent.bridge.TracedMethod;
import com.newrelic.agent.bridge.TransactionNamePriority;
import com.newrelic.agent.bridge.WebResponse;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.api.agent.ApplicationNamePriority;
import com.newrelic.api.agent.DistributedTracePayload;
import com.newrelic.api.agent.ExtendedRequest;
import com.newrelic.api.agent.Headers;
import com.newrelic.api.agent.InboundHeaders;
import com.newrelic.api.agent.NewRelic;
import com.newrelic.api.agent.OutboundHeaders;
import com.newrelic.api.agent.Request;
import com.newrelic.api.agent.Response;
import com.newrelic.api.agent.TransportType;
import java.net.URI;
import java.util.Map;
import java.util.logging.Level;

public class TransactionApiImpl
implements com.newrelic.agent.bridge.Transaction {
    public static final TransactionApiImpl INSTANCE = new TransactionApiImpl();

    public boolean equals(Object obj) {
        if (!(obj instanceof TransactionApiImpl)) {
            return false;
        }
        TransactionApiImpl objTxi = (TransactionApiImpl)obj;
        return this.getTransactionIfExists() == objTxi.getTransactionIfExists();
    }

    public int hashCode() {
        Transaction tx = this.getTransactionIfExists();
        return tx == null ? 42 : tx.hashCode();
    }

    protected Transaction getTransactionIfExists() {
        return Transaction.getTransaction(false);
    }

    public boolean registerAsyncActivity(Object asyncContext) {
        return ServiceFactory.getAsyncTxService().registerAsyncActivity(asyncContext);
    }

    public boolean setTransactionName(com.newrelic.api.agent.TransactionNamePriority namePriority, boolean override, String category, String ... parts) {
        Transaction tx = this.getTransactionIfExists();
        return tx != null ? tx.setTransactionName(namePriority, override, category, parts) : false;
    }

    public boolean isTransactionNameSet() {
        Transaction tx = this.getTransactionIfExists();
        return tx != null ? tx.isTransactionNameSet() : false;
    }

    public com.newrelic.api.agent.TracedMethod getLastTracer() {
        return this.getTracedMethod();
    }

    public com.newrelic.api.agent.TracedMethod getTracedMethod() {
        Transaction tx = this.getTransactionIfExists();
        Tracer tracedMethod = this.getTracedMethodTracer(tx);
        if (tracedMethod == null) {
            return NoOpTracedMethod.INSTANCE;
        }
        return tracedMethod;
    }

    Tracer getTracedMethodTracer(Transaction tx) {
        if (tx == null) {
            return null;
        }
        TransactionActivity txa = tx.getTransactionActivity();
        if (txa == null) {
            return null;
        }
        return txa.getLastTracer();
    }

    public void ignore() {
        Transaction tx = this.getTransactionIfExists();
        if (tx != null) {
            tx.ignore();
        }
    }

    public void ignoreApdex() {
        Transaction tx = this.getTransactionIfExists();
        if (tx != null) {
            tx.ignoreApdex();
        }
    }

    public void ignoreErrors() {
        Transaction tx = this.getTransactionIfExists();
        if (tx != null) {
            tx.ignoreErrors();
        }
    }

    public boolean setTransactionName(TransactionNamePriority namePriority, boolean override, String category, String ... parts) {
        Transaction tx = this.getTransactionIfExists();
        return tx != null ? tx.setTransactionName(namePriority, override, category, parts) : false;
    }

    public void beforeSendResponseHeaders() {
        this.addOutboundResponseHeaders();
    }

    public void addOutboundResponseHeaders() {
        Transaction tx = this.getTransactionIfExists();
        if (tx != null) {
            tx.addOutboundResponseHeaders();
        }
    }

    public boolean isStarted() {
        Transaction tx = this.getTransactionIfExists();
        return tx != null ? tx.isStarted() : false;
    }

    public void setApplicationName(ApplicationNamePriority priority, String appName) {
        Transaction tx = this.getTransactionIfExists();
        if (tx != null) {
            tx.setApplicationName(priority, appName);
        }
    }

    public boolean isAutoAppNamingEnabled() {
        Transaction tx = this.getTransactionIfExists();
        return tx != null ? tx.isAutoAppNamingEnabled() : false;
    }

    public boolean isWebRequestSet() {
        Transaction tx = this.getTransactionIfExists();
        return tx != null ? tx.isWebRequestSet() : false;
    }

    public boolean isWebResponseSet() {
        Transaction tx = this.getTransactionIfExists();
        return tx != null ? tx.isWebResponseSet() : false;
    }

    public void setWebRequest(Request request) {
        Transaction tx = this.getTransactionIfExists();
        if (tx != null) {
            tx.setWebRequest(request);
        }
    }

    public void setWebResponse(Response response) {
        Transaction tx = this.getTransactionIfExists();
        if (tx != null) {
            tx.setWebResponse(response);
        }
    }

    public WebResponse getWebResponse() {
        Transaction tx = this.getTransactionIfExists();
        return tx != null ? tx.getWebResponse() : NoOpWebResponse.INSTANCE;
    }

    public void convertToWebTransaction() {
        Transaction tx = this.getTransactionIfExists();
        if (tx != null) {
            tx.convertToWebTransaction();
        }
    }

    public boolean isWebTransaction() {
        Transaction tx = this.getTransactionIfExists();
        if (tx != null) {
            return tx.isWebTransaction();
        }
        return false;
    }

    public void requestInitialized(Request request, Response response) {
        Transaction tx = this.getTransactionIfExists();
        if (tx != null) {
            tx.requestInitialized(request, response);
        }
    }

    public void requestDestroyed() {
        Transaction tx = this.getTransactionIfExists();
        if (tx != null) {
            tx.requestDestroyed();
        }
    }

    public void saveMessageParameters(Map<String, String> parameters) {
        Transaction tx = this.getTransactionIfExists();
        if (tx != null) {
            tx.saveMessageParameters(parameters);
        }
    }

    public CrossProcessState getCrossProcessState() {
        Transaction tx = this.getTransactionIfExists();
        return tx != null ? tx.getCrossProcessState() : NoOpCrossProcessState.INSTANCE;
    }

    public TracedMethod startFlyweightTracer() {
        Transaction tx = this.getTransactionIfExists();
        if (tx == null || !tx.isStarted()) {
            return NoOpTracedMethod.INSTANCE;
        }
        return tx.getTransactionActivity().startFlyweightTracer();
    }

    public void finishFlyweightTracer(TracedMethod parent, long startInNanos, long finishInNanos, String className, String methodName, String methodDesc, String metricName, String[] rollupMetricNames) {
        Transaction tx = this.getTransactionIfExists();
        if (tx != null && tx.isStarted()) {
            tx.getTransactionActivity().finishFlyweightTracer(parent, startInNanos, finishInNanos, className, methodName, methodDesc, metricName, rollupMetricNames);
        }
    }

    public Map<String, Object> getAgentAttributes() {
        Transaction tx = this.getTransactionIfExists();
        return tx != null ? tx.getAgentAttributes() : NoOpTransaction.INSTANCE.getAgentAttributes();
    }

    public void provideHeaders(InboundHeaders headers) {
        Transaction tx = this.getTransactionIfExists();
        if (tx != null) {
            tx.provideHeaders(headers);
        }
    }

    public String getRequestMetadata() {
        Transaction tx = this.getTransactionIfExists();
        return tx != null ? tx.getCrossProcessState().getRequestMetadata() : NoOpCrossProcessState.INSTANCE.getRequestMetadata();
    }

    public void processRequestMetadata(String metadata) {
        Transaction tx = this.getTransactionIfExists();
        if (tx != null) {
            tx.getCrossProcessState().processRequestMetadata(metadata);
        }
    }

    public String getResponseMetadata() {
        Transaction tx = this.getTransactionIfExists();
        return tx != null ? tx.getCrossProcessState().getResponseMetadata() : NoOpCrossProcessState.INSTANCE.getResponseMetadata();
    }

    public void processResponseMetadata(String metadata) {
        Transaction tx = this.getTransactionIfExists();
        if (tx != null) {
            tx.getCrossProcessState().processResponseMetadata(metadata, null);
        }
    }

    public void processResponseMetadata(String metadata, URI uri) {
        Transaction tx = this.getTransactionIfExists();
        if (tx != null) {
            tx.getCrossProcessState().processResponseMetadata(metadata, uri);
        }
    }

    public void setWebRequest(ExtendedRequest request) {
        Transaction tx = this.getTransactionIfExists();
        if (tx != null) {
            tx.setWebRequest((Request)request);
        }
    }

    public boolean markFirstByteOfResponse() {
        Transaction tx = this.getTransactionIfExists();
        return tx == null ? false : tx.markFirstByteOfResponse(System.nanoTime());
    }

    public boolean markLastByteOfResponse() {
        Transaction tx = this.getTransactionIfExists();
        return tx == null ? false : tx.markLastByteOfResponse(System.nanoTime());
    }

    public void markResponseAtTxaEnd() {
        Transaction tx = this.getTransactionIfExists();
        if (tx != null) {
            tx.getTransactionActivity().markAsResponseSender();
        }
    }

    public boolean markResponseSent() {
        Transaction tx = this.getTransactionIfExists();
        if (tx == null) {
            Agent.LOG.log(Level.FINER, "ignoring markResponseSent: no transaction");
            return false;
        }
        tx.getTransactionActivity().markAsResponseSender();
        if (tx.getTransactionTimer().markResponseTime(System.nanoTime())) {
            Agent.LOG.log(Level.FINER, "markResponseSent: successful transaction response timestamp");
            return true;
        }
        Agent.LOG.log(Level.FINER, "ignoring markResponseSent: response time is already set for {0}", tx);
        return false;
    }

    public TracedActivity createAndStartTracedActivity() {
        Transaction tx = this.getTransactionIfExists();
        if (null == tx) {
            return NoOpSegment.INSTANCE;
        }
        Segment segment = tx.startSegment("Custom", "Unnamed Segment");
        return segment == null ? NoOpSegment.INSTANCE : segment;
    }

    public DistributedTracePayload createDistributedTracePayload() {
        Transaction tx = this.getTransactionIfExists();
        if (tx == null) {
            return NoOpDistributedTracePayload.INSTANCE;
        }
        TransactionActivity txa = tx.getTransactionActivity();
        if (txa == null) {
            return NoOpDistributedTracePayload.INSTANCE;
        }
        return ServiceFactory.getDistributedTraceService().createDistributedTracePayload(txa.getLastTracer());
    }

    public Token getToken() {
        Transaction tx = this.getTransactionIfExists();
        if (null == tx) {
            return NoOpToken.INSTANCE;
        }
        return tx.getToken();
    }

    public com.newrelic.api.agent.Segment startSegment(String segmentName) {
        Transaction tx = this.getTransactionIfExists();
        if (null == tx) {
            return NoOpSegment.INSTANCE;
        }
        return this.startSegment("Custom", segmentName);
    }

    public com.newrelic.api.agent.Segment startSegment(String category, String segmentName) {
        Segment segment;
        Transaction tx = this.getTransactionIfExists();
        if (null == tx) {
            return NoOpSegment.INSTANCE;
        }
        if (category == null || category.isEmpty()) {
            category = "Custom";
        }
        if (segmentName == null || segmentName.isEmpty()) {
            segmentName = "Unnamed Segment";
        }
        return (segment = tx.startSegment(category, segmentName)) == null ? NoOpSegment.INSTANCE : segment;
    }

    public void expireAllTokens() {
        Transaction tx = this.getTransactionIfExists();
        if (null != tx) {
            tx.expireAllTokensForCurrentTransaction();
        }
    }

    public boolean clearTransaction() {
        Transaction tx = this.getTransactionIfExists();
        TransactionActivity txa = tx.getTransactionActivity();
        if (txa != null) {
            tx.checkFinishTransactionFromActivity(txa);
        }
        Transaction.clearTransaction();
        return true;
    }

    public void acceptDistributedTracePayload(String payload) {
        Transaction tx = this.getTransactionIfExists();
        if (tx != null) {
            tx.acceptDistributedTracePayload(payload);
        }
    }

    public void acceptDistributedTracePayload(DistributedTracePayload payload) {
        Transaction tx = this.getTransactionIfExists();
        if (tx != null) {
            tx.acceptDistributedTracePayload(payload);
        }
    }

    public void insertDistributedTraceHeaders(Headers headers) {
        Transaction tx = this.getTransactionIfExists();
        if (tx == null) {
            return;
        }
        HeadersUtil.createAndSetDistributedTraceHeaders(tx, NewRelic.getAgent().getTracedMethod(), (OutboundHeaders)headers);
    }

    public void acceptDistributedTraceHeaders(TransportType transportType, Headers headers) {
        Transaction tx = this.getTransactionIfExists();
        if (tx == null) {
            return;
        }
        if (TransportType.Unknown.equals((Object)tx.getTransportType())) {
            tx.setTransportType(transportType);
        }
        HeadersUtil.parseAndAcceptDistributedTraceHeaders(tx, (InboundHeaders)headers);
    }

    public Object getSecurityMetaData() {
        Transaction tx = this.getTransactionIfExists();
        if (tx != null) {
            return tx.getSecurityMetaData();
        }
        return null;
    }

    public void setTransportType(TransportType transportType) {
        Transaction tx = this.getTransactionIfExists();
        if (tx != null) {
            tx.setTransportType(transportType);
        }
    }
}

