/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.BoundTransactionApiImpl;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionApiImpl;
import com.newrelic.agent.TransactionErrorPriority;
import com.newrelic.agent.TransactionState;
import com.newrelic.agent.bridge.AsyncApi;
import com.newrelic.agent.deps.com.google.common.collect.MapMaker;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsWorks;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.servlet.ServletAsyncTransactionStateImpl;
import com.newrelic.api.agent.Logger;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;

public class AsyncApiImpl
implements AsyncApi {
    private final ConcurrentMap<Object, Transaction> asyncTransactions = new MapMaker().weakKeys().makeMap();
    private final Logger logger;

    public AsyncApiImpl(Logger logger) {
        this.logger = logger;
    }

    public void suspendAsync(Object asyncContext) {
        Transaction currentTxn;
        this.logger.log(Level.FINEST, "Suspend async");
        if (asyncContext != null && (currentTxn = Transaction.getTransaction(false)) != null) {
            TransactionState transactionState = this.setTransactionState(currentTxn);
            transactionState.suspendRootTracer();
            this.asyncTransactions.put(asyncContext, currentTxn);
            ServiceFactory.getStatsService().doStatsWork(StatsWorks.getIncrementCounterWork("Supportability/API/LegacyAsync/Suspend", 1), "Supportability/API/LegacyAsync/Suspend");
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.log(Level.FINEST, "Suspended async: {0}, for Transaction: {1}", asyncContext, (Object)currentTxn);
            }
        }
    }

    private TransactionState setTransactionState(Transaction tx) {
        TransactionState txState = tx.getTransactionState();
        if (txState instanceof ServletAsyncTransactionStateImpl) {
            return txState;
        }
        txState = new ServletAsyncTransactionStateImpl(tx);
        tx.setTransactionState(txState);
        return txState;
    }

    public com.newrelic.agent.bridge.Transaction resumeAsync(Object asyncContext) {
        this.logger.log(Level.FINEST, "Resume async");
        if (asyncContext != null) {
            Transaction suspendedTx = (Transaction)this.asyncTransactions.get(asyncContext);
            ServiceFactory.getStatsService().doStatsWork(StatsWorks.getIncrementCounterWork("Supportability/API/LegacyAsync/Resume", 1), "Supportability/API/LegacyAsync/Resume");
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.log(Level.FINEST, "Resume async: {0}, for Transaction: {1}", asyncContext, (Object)suspendedTx);
            }
            if (suspendedTx != null) {
                suspendedTx.getTransactionState().resume();
                if (suspendedTx.isStarted()) {
                    suspendedTx.getTransactionState().getRootTracer();
                    return new BoundTransactionApiImpl(suspendedTx);
                }
            }
        }
        return TransactionApiImpl.INSTANCE;
    }

    public void completeAsync(Object asyncContext) {
        this.logger.log(Level.FINEST, "Complete async");
        ServiceFactory.getStatsService().doStatsWork(StatsWorks.getIncrementCounterWork("Supportability/API/LegacyAsync/Complete", 1), "Supportability/API/LegacyAsync/Complete");
        if (asyncContext == null) {
            this.logger.log(Level.FINEST, "Complete async context is null");
            return;
        }
        Transaction transaction = (Transaction)this.asyncTransactions.remove(asyncContext);
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.log(Level.FINEST, "Complete async: {0}, for Transaction: {1}", asyncContext, (Object)transaction);
        }
        if (transaction != null) {
            transaction.getTransactionState().complete();
        }
    }

    public void errorAsync(Object asyncContext, Throwable t2) {
        this.logger.log(Level.FINEST, "Error async");
        ServiceFactory.getStatsService().doStatsWork(StatsWorks.getIncrementCounterWork("Supportability/API/LegacyAsync/Error", 1), "Supportability/API/LegacyAsync/Error");
        if (asyncContext == null || t2 == null) {
            this.logger.log(Level.FINEST, "Error async context or throwable is null");
            return;
        }
        Transaction transaction = (Transaction)this.asyncTransactions.get(asyncContext);
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.log(Level.FINEST, "Error async: {0}, for Transaction: {1}", asyncContext, (Object)transaction);
        }
        if (transaction != null) {
            transaction.setThrowable(t2, TransactionErrorPriority.API, false);
        }
    }

    public void finishRootTracer() {
        Tracer rootTracer;
        Transaction currentTxn = Transaction.getTransaction(false);
        if (currentTxn != null && (rootTracer = currentTxn.getRootTracer()) != null) {
            rootTracer.finish(177, null);
        }
    }
}

