/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import java.util.function.Function;

public enum PathType {
    LEGACY("$", token -> "." + token, index -> "[" + index + "]"),
    JSON_PATH("$", token -> {
        if (token.codePoints().allMatch(c -> c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || c == 95)) {
            return "." + token;
        }
        return "[\"" + token + "\"]";
    }, index -> "[" + index + "]"),
    JSON_POINTER("", token -> {
        if (token.indexOf(126) != -1) {
            token = token.replace("~", "~0");
        }
        if (token.indexOf(47) != -1) {
            token = token.replace("/", "~1");
        }
        return "/" + token;
    }, index -> "/" + index);

    public static final PathType DEFAULT;
    private final String rootToken;
    private final Function<String, String> appendTokenFn;
    private final Function<Integer, String> appendIndexFn;

    private PathType(String rootToken, Function<String, String> appendTokenFn, Function<Integer, String> appendIndexFn) {
        this.rootToken = rootToken;
        this.appendTokenFn = appendTokenFn;
        this.appendIndexFn = appendIndexFn;
    }

    public String append(String currentPath, String child) {
        return currentPath + this.appendTokenFn.apply(child);
    }

    public String append(String currentPath, int index) {
        return currentPath + this.appendIndexFn.apply(index);
    }

    public String getRoot() {
        return this.rootToken;
    }

    public String convertToJsonPointer(String path) {
        switch (this) {
            case JSON_POINTER: {
                return path;
            }
        }
        return PathType.fromLegacyOrJsonPath(path);
    }

    static String fromLegacyOrJsonPath(String path) {
        return path.replace("\"", "").replace("]", "").replace('[', '/').replace('.', '/').replace("$", "");
    }

    static {
        DEFAULT = LEGACY;
    }
}

