/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.ethlo.time.ITU;
import com.ethlo.time.LeapSecondException;
import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonType;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.TypeFactory;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.time.LocalDate;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(DateTimeValidator.class);
    private static final String DATE = "date";
    private static final String DATETIME = "date-time";
    private final String formatName;

    public DateTimeValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext, String formatName, ValidatorTypeCode type) {
        super(schemaPath, schemaNode, parentSchema, type, validationContext);
        this.formatName = formatName;
        this.validationContext = validationContext;
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
        if (!formatName.equals(DATE) && !formatName.equals(DATETIME)) {
            throw new IllegalArgumentException(String.format("formatName must be one of the following: [%s, %s]", DATE, DATETIME));
        }
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        JsonType nodeType = TypeFactory.getValueNodeType(node, this.validationContext.getConfig());
        if (nodeType != JsonType.STRING) {
            return errors;
        }
        if (!this.isLegalDateTime(node.textValue())) {
            errors.add(this.buildValidationMessage(at, node.textValue(), this.formatName));
        }
        return Collections.unmodifiableSet(errors);
    }

    private boolean isLegalDateTime(String string) {
        try {
            block7: {
                if (this.formatName.equals(DATE)) {
                    LocalDate.parse(string);
                } else if (this.formatName.equals(DATETIME)) {
                    try {
                        ITU.parseDateTime((String)string);
                    }
                    catch (LeapSecondException ex) {
                        if (ex.isVerifiedValidLeapYearMonth()) break block7;
                        return false;
                    }
                }
            }
            return true;
        }
        catch (Exception ex) {
            logger.debug("Invalid {}: {}", (Object)this.formatName, (Object)ex.getMessage());
            return false;
        }
    }
}

