/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.atlas.shaded.spectator-atlas.json.databind.deser.std;

import com.netflix.spectator.atlas.shaded.spectator-atlas.json.core.JsonParser;
import com.netflix.spectator.atlas.shaded.spectator-atlas.json.databind.DeserializationContext;
import com.netflix.spectator.atlas.shaded.spectator-atlas.json.databind.deser.std.StdScalarDeserializer;
import com.netflix.spectator.atlas.shaded.spectator-atlas.json.databind.type.LogicalType;
import com.netflix.spectator.atlas.shaded.spectator-atlas.json.databind.util.ByteBufferBackedOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ByteBufferDeserializer
extends StdScalarDeserializer<ByteBuffer> {
    private static final long serialVersionUID = 1L;

    protected ByteBufferDeserializer() {
        super(ByteBuffer.class);
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Binary;
    }

    @Override
    public ByteBuffer deserialize(JsonParser parser, DeserializationContext cx) throws IOException {
        byte[] b = parser.getBinaryValue();
        return ByteBuffer.wrap(b);
    }

    @Override
    public ByteBuffer deserialize(JsonParser jp, DeserializationContext ctxt, ByteBuffer intoValue) throws IOException {
        ByteBufferBackedOutputStream out = new ByteBufferBackedOutputStream(intoValue);
        jp.readBinaryValue(ctxt.getBase64Variant(), out);
        out.close();
        return intoValue;
    }
}

