/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.transport.netty.http;

import com.google.common.collect.Lists;
import com.netflix.client.ClientException;
import com.netflix.client.DefaultLoadBalancerRetryHandler;
import com.netflix.client.config.IClientConfig;
import com.netflix.client.http.UnexpectedHttpResponseException;
import io.netty.channel.ConnectTimeoutException;
import io.netty.handler.timeout.ReadTimeoutException;
import io.reactivex.netty.client.PoolExhaustedException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.List;

public class NettyHttpLoadBalancerErrorHandler
extends DefaultLoadBalancerRetryHandler {
    private List<Class<? extends Throwable>> retriable = Lists.newArrayList((Object[])new Class[]{ConnectException.class, SocketTimeoutException.class, ReadTimeoutException.class, ConnectTimeoutException.class, PoolExhaustedException.class});
    private List<Class<? extends Throwable>> circuitRelated = Lists.newArrayList((Object[])new Class[]{SocketException.class, SocketTimeoutException.class, ReadTimeoutException.class, ConnectTimeoutException.class, PoolExhaustedException.class});

    public NettyHttpLoadBalancerErrorHandler() {
    }

    public NettyHttpLoadBalancerErrorHandler(IClientConfig clientConfig) {
        super(clientConfig);
    }

    public NettyHttpLoadBalancerErrorHandler(int retrySameServer, int retryNextServer, boolean retryEnabled) {
        super(retrySameServer, retryNextServer, retryEnabled);
    }

    public boolean isCircuitTrippingException(Throwable e) {
        if (e instanceof UnexpectedHttpResponseException) {
            return ((UnexpectedHttpResponseException)e).getStatusCode() == 503;
        }
        if (e instanceof ClientException) {
            return ((ClientException)e).getErrorType() == ClientException.ErrorType.SERVER_THROTTLED;
        }
        return super.isCircuitTrippingException(e);
    }

    public boolean isRetriableException(Throwable e, boolean sameServer) {
        ClientException ce;
        if (e instanceof ClientException && (ce = (ClientException)e).getErrorType() == ClientException.ErrorType.SERVER_THROTTLED) {
            return !sameServer && this.retryEnabled;
        }
        return super.isRetriableException(e, sameServer);
    }

    protected List<Class<? extends Throwable>> getRetriableExceptions() {
        return this.retriable;
    }

    protected List<Class<? extends Throwable>> getCircuitRelatedExceptions() {
        return this.circuitRelated;
    }
}

