/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.dashboard.stream;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockStreamServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(MockStreamServlet.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String filename = request.getParameter("file");
        if (filename == null) {
            filename = "hystrix.stream";
        } else {
            filename = filename.replaceAll("\\.\\.", "");
            filename = filename.replaceAll("/", "");
        }
        int delay = 500;
        String delayArg = request.getParameter("delay");
        if (delayArg != null) {
            delay = Integer.parseInt(delayArg);
        }
        int batch = 1;
        String batchArg = request.getParameter("batch");
        if (batchArg != null) {
            batch = Integer.parseInt(batchArg);
        }
        String data = this.getFileFromPackage(filename);
        String[] lines = data.split("\n");
        response.setContentType("text/event-stream");
        response.setCharacterEncoding("UTF-8");
        int batchCount = 0;
        block4: while (true) {
            String[] stringArray = lines;
            int n = stringArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) continue block4;
                String s = stringArray[n2];
                if ((s = s.trim()).length() > 0) {
                    try {
                        response.getWriter().println(s);
                        response.getWriter().println("");
                        response.getWriter().flush();
                    }
                    catch (Exception e) {
                        logger.warn("Exception writing mock data to output.", (Throwable)e);
                        return;
                    }
                    if (++batchCount == batch) {
                        try {
                            Thread.sleep(delay);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        batchCount = 0;
                    }
                }
                ++n2;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFileFromPackage(String filename) {
        String string;
        String file = "/" + this.getClass().getPackage().getName().replace('.', '/') + "/" + filename;
        InputStream is = this.getClass().getResourceAsStream(file);
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
            StringWriter s = new StringWriter();
            int c = -1;
            while ((c = in.read()) > -1) {
                s.write(c);
            }
            string = s.toString();
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not find file: " + filename, e);
            }
        }
        is.close();
        return string;
    }
}

