/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal.utils;

import com.netflix.graphql.dgs.Internal;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.OperationDefinition;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.parser.Parser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Internal
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/netflix/graphql/dgs/internal/utils/SelectionSetUtil;", "", "()V", "Companion", "graphql-dgs"})
public final class SelectionSetUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u0002J\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u0005\u00a8\u0006\n"}, d2={"Lcom/netflix/graphql/dgs/internal/utils/SelectionSetUtil$Companion;", "", "()V", "toPaths", "", "", "selectionSet", "Lgraphql/language/SelectionSet;", "nesting", "", "graphql-dgs"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<List<String>> toPaths(@NotNull String selectionSet) {
            Intrinsics.checkNotNullParameter((Object)selectionSet, (String)"selectionSet");
            Document document = Parser.parse((String)("{ " + selectionSet + " }"));
            Object e = document.getDefinitions().get(0);
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type graphql.language.OperationDefinition");
            OperationDefinition operation = (OperationDefinition)e;
            SelectionSet selectionSet2 = operation.getSelectionSet();
            Intrinsics.checkNotNullExpressionValue((Object)selectionSet2, (String)"getSelectionSet(...)");
            return this.toPaths(selectionSet2, new ArrayList());
        }

        private final List<List<String>> toPaths(SelectionSet selectionSet, List<String> nesting) {
            ArrayList<List<String>> results = new ArrayList<List<String>>();
            for (Selection selection : selectionSet.getSelections()) {
                if (!(selection instanceof Field)) continue;
                if (((Field)selection).getSelectionSet() == null) {
                    results.add(Stream.concat(nesting.stream(), Stream.of(((Field)selection).getName())).toList());
                    continue;
                }
                String string = ((Field)selection).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                nesting.add(string);
                SelectionSet selectionSet2 = ((Field)selection).getSelectionSet();
                Intrinsics.checkNotNullExpressionValue((Object)selectionSet2, (String)"getSelectionSet(...)");
                results.addAll((Collection)this.toPaths(selectionSet2, nesting));
                CollectionsKt.removeLast(nesting);
            }
            return results;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

