/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs;

import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.internal.DataFetcherResultProcessor;
import graphql.TrivialDataFetcher;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetcherFactories;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLFieldDefinition;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\n\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0002J\u001a\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0011J\u001a\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/netflix/graphql/dgs/DgsCodeRegistryBuilder;", "", "dataFetcherResultProcessors", "", "Lcom/netflix/graphql/dgs/internal/DataFetcherResultProcessor;", "graphQLCodeRegistry", "Lgraphql/schema/GraphQLCodeRegistry$Builder;", "ctx", "Lorg/springframework/context/ApplicationContext;", "(Ljava/util/List;Lgraphql/schema/GraphQLCodeRegistry$Builder;Lorg/springframework/context/ApplicationContext;)V", "convertResult", "dfe", "Lgraphql/schema/DataFetchingEnvironment;", "result", "dataFetcher", "coordinates", "Lgraphql/schema/FieldCoordinates;", "Lgraphql/schema/DataFetcher;", "getDataFetcher", "fieldDefinition", "Lgraphql/schema/GraphQLFieldDefinition;", "hasDataFetcher", "", "graphql-dgs"})
@SourceDebugExtension(value={"SMAP\nDgsCodeRegistryBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DgsCodeRegistryBuilder.kt\ncom/netflix/graphql/dgs/DgsCodeRegistryBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n1#2:78\n*E\n"})
public final class DgsCodeRegistryBuilder {
    @NotNull
    private final List<DataFetcherResultProcessor> dataFetcherResultProcessors;
    @NotNull
    private final GraphQLCodeRegistry.Builder graphQLCodeRegistry;
    @NotNull
    private final ApplicationContext ctx;

    public DgsCodeRegistryBuilder(@NotNull List<? extends DataFetcherResultProcessor> dataFetcherResultProcessors, @NotNull GraphQLCodeRegistry.Builder graphQLCodeRegistry, @NotNull ApplicationContext ctx) {
        Intrinsics.checkNotNullParameter(dataFetcherResultProcessors, (String)"dataFetcherResultProcessors");
        Intrinsics.checkNotNullParameter((Object)graphQLCodeRegistry, (String)"graphQLCodeRegistry");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.dataFetcherResultProcessors = dataFetcherResultProcessors;
        this.graphQLCodeRegistry = graphQLCodeRegistry;
        this.ctx = ctx;
    }

    @NotNull
    public final DgsCodeRegistryBuilder dataFetcher(@NotNull FieldCoordinates coordinates, @NotNull DataFetcher<?> dataFetcher) {
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        Intrinsics.checkNotNullParameter(dataFetcher, (String)"dataFetcher");
        DataFetcher fetcher = !((Collection)this.dataFetcherResultProcessors).isEmpty() && !(dataFetcher instanceof TrivialDataFetcher) ? DataFetcherFactories.wrapDataFetcher(dataFetcher, (arg_0, arg_1) -> DgsCodeRegistryBuilder.dataFetcher$lambda$0(this, arg_0, arg_1)) : dataFetcher;
        this.graphQLCodeRegistry.dataFetcher(coordinates, fetcher);
        return this;
    }

    public final boolean hasDataFetcher(@NotNull FieldCoordinates coordinates) {
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        return this.graphQLCodeRegistry.hasDataFetcher(coordinates);
    }

    @NotNull
    public final DataFetcher<?> getDataFetcher(@NotNull FieldCoordinates coordinates, @NotNull GraphQLFieldDefinition fieldDefinition) {
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        Intrinsics.checkNotNullParameter((Object)fieldDefinition, (String)"fieldDefinition");
        DataFetcher dataFetcher = this.graphQLCodeRegistry.getDataFetcher(coordinates, fieldDefinition);
        Intrinsics.checkNotNullExpressionValue((Object)dataFetcher, (String)"getDataFetcher(...)");
        return dataFetcher;
    }

    private final Object convertResult(DataFetchingEnvironment dfe, Object result) {
        Object v0;
        block3: {
            if (result == null) {
                return null;
            }
            Iterable iterable = this.dataFetcherResultProcessors;
            for (Object t : iterable) {
                DataFetcherResultProcessor it = (DataFetcherResultProcessor)t;
                boolean bl = false;
                if (!it.supportsType(result)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        DataFetcherResultProcessor dataFetcherResultProcessor = v0;
        if (dataFetcherResultProcessor == null) {
            return result;
        }
        DataFetcherResultProcessor processor = dataFetcherResultProcessor;
        DgsDataFetchingEnvironment env = dfe instanceof DgsDataFetchingEnvironment ? (DgsDataFetchingEnvironment)dfe : new DgsDataFetchingEnvironment(dfe, this.ctx);
        return processor.process(result, env);
    }

    private static final Object dataFetcher$lambda$0(DgsCodeRegistryBuilder this$0, DataFetchingEnvironment dfe, Object result) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)dfe);
        return this$0.convertResult(dfe, result);
    }
}

