/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.subscriptions.websockets;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.netflix.graphql.dgs.DgsQueryExecutor;
import com.netflix.graphql.dgs.subscriptions.websockets.Context;
import com.netflix.graphql.dgs.subscriptions.websockets.WebsocketGraphQLTransportWSProtocolHandler;
import com.netflix.graphql.types.subscription.websockets.CloseCode;
import com.netflix.graphql.types.subscription.websockets.Message;
import graphql.ExecutionResult;
import graphql.GraphqlErrorBuilder;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.PostConstruct;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 $2\u00020\u0001:\u0001$B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0012H\u0016J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0012H\u0002J \u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u0012H\u0002J\u0018\u0010 \u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u0016H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/netflix/graphql/dgs/subscriptions/websockets/WebsocketGraphQLTransportWSProtocolHandler;", "Lorg/springframework/web/socket/handler/TextWebSocketHandler;", "dgsQueryExecutor", "Lcom/netflix/graphql/dgs/DgsQueryExecutor;", "connectionInitTimeout", "Ljava/time/Duration;", "subscriptionErrorLogLevel", "Lorg/slf4j/event/Level;", "(Lcom/netflix/graphql/dgs/DgsQueryExecutor;Ljava/time/Duration;Lorg/slf4j/event/Level;)V", "contexts", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/netflix/graphql/dgs/subscriptions/websockets/Context;", "", "getContexts$graphql_dgs_subscriptions_websockets", "()Ljava/util/concurrent/ConcurrentHashMap;", "sessions", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lorg/springframework/web/socket/WebSocketSession;", "getSessions$graphql_dgs_subscriptions_websockets", "()Ljava/util/concurrent/CopyOnWriteArrayList;", "afterConnectionClosed", "", "session", "status", "Lorg/springframework/web/socket/CloseStatus;", "afterConnectionEstablished", "cleanupSubscriptionsForSession", "handleSubscription", "id", "payload", "Lcom/netflix/graphql/types/subscription/websockets/Message$SubscribeMessage$Payload;", "handleTextMessage", "textMessage", "Lorg/springframework/web/socket/TextMessage;", "setupCleanup", "Companion", "graphql-dgs-subscriptions-websockets"})
public final class WebsocketGraphQLTransportWSProtocolHandler
extends TextWebSocketHandler {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final DgsQueryExecutor dgsQueryExecutor;
    @NotNull
    private final Duration connectionInitTimeout;
    @NotNull
    private final Level subscriptionErrorLogLevel;
    @NotNull
    private final CopyOnWriteArrayList<WebSocketSession> sessions;
    @NotNull
    private final ConcurrentHashMap<String, Context<Object>> contexts;
    @Deprecated
    private static final Logger logger = LoggerFactory.getLogger(WebsocketGraphQLTransportWSProtocolHandler.class);
    @Deprecated
    @NotNull
    private static final ObjectMapper objectMapper = ExtensionsKt.jacksonObjectMapper();

    public WebsocketGraphQLTransportWSProtocolHandler(@NotNull DgsQueryExecutor dgsQueryExecutor, @NotNull Duration connectionInitTimeout, @NotNull Level subscriptionErrorLogLevel) {
        Intrinsics.checkNotNullParameter((Object)dgsQueryExecutor, (String)"dgsQueryExecutor");
        Intrinsics.checkNotNullParameter((Object)connectionInitTimeout, (String)"connectionInitTimeout");
        Intrinsics.checkNotNullParameter((Object)subscriptionErrorLogLevel, (String)"subscriptionErrorLogLevel");
        this.dgsQueryExecutor = dgsQueryExecutor;
        this.connectionInitTimeout = connectionInitTimeout;
        this.subscriptionErrorLogLevel = subscriptionErrorLogLevel;
        this.sessions = new CopyOnWriteArrayList();
        this.contexts = new ConcurrentHashMap();
    }

    @NotNull
    public final CopyOnWriteArrayList<WebSocketSession> getSessions$graphql_dgs_subscriptions_websockets() {
        return this.sessions;
    }

    @NotNull
    public final ConcurrentHashMap<String, Context<Object>> getContexts$graphql_dgs_subscriptions_websockets() {
        return this.contexts;
    }

    @PostConstruct
    public final void setupCleanup() {
        TimerTask timerTask2 = new TimerTask(this){
            final /* synthetic */ WebsocketGraphQLTransportWSProtocolHandler this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public void run() {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = this.this$0.getSessions$graphql_dgs_subscriptions_websockets();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    WebSocketSession it = (WebSocketSession)element$iv$iv;
                    boolean bl = false;
                    if (!(!it.isOpen())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                WebsocketGraphQLTransportWSProtocolHandler websocketGraphQLTransportWSProtocolHandler = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    WebSocketSession p0 = (WebSocketSession)element$iv;
                    boolean bl = false;
                    WebsocketGraphQLTransportWSProtocolHandler.access$cleanupSubscriptionsForSession(websocketGraphQLTransportWSProtocolHandler, p0);
                }
            }
        };
        Timer timer = new Timer(true);
        timer.scheduleAtFixedRate(timerTask2, 0L, 5000L);
    }

    public void afterConnectionEstablished(@NotNull WebSocketSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Map map = this.contexts;
        String string = session.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"session.id");
        String string2 = string;
        Context context = new Context(false, 1, null);
        map.put(string2, context);
        TimerTask timerTask2 = new TimerTask(this, session){
            final /* synthetic */ WebsocketGraphQLTransportWSProtocolHandler this$0;
            final /* synthetic */ WebSocketSession $session;
            {
                this.this$0 = $receiver;
                this.$session = $session;
            }

            public void run() {
                Context<Object> context = this.this$0.getContexts$graphql_dgs_subscriptions_websockets().get(this.$session.getId());
                boolean bl = context != null ? !context.getConnectionInitReceived() : false;
                if (bl) {
                    this.$session.close(new CloseStatus(CloseCode.ConnectionInitialisationTimeout.getCode()));
                    this.this$0.getContexts$graphql_dgs_subscriptions_websockets().remove(this.$session.getId());
                }
            }
        };
        Timer timer = new Timer();
        timer.schedule(timerTask2, this.connectionInitTimeout.toMillis());
    }

    public void afterConnectionClosed(@NotNull WebSocketSession session, @NotNull CloseStatus status) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        if (Intrinsics.areEqual((Object)status, (Object)CloseStatus.NORMAL)) {
            this.cleanupSubscriptionsForSession(session);
        }
    }

    public void handleTextMessage(@NotNull WebSocketSession session, @NotNull TextMessage textMessage) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)textMessage, (String)"textMessage");
        Message message = (Message)objectMapper.readValue((String)textMessage.getPayload(), Message.class);
        Context<Object> context = this.contexts.get(session.getId());
        Intrinsics.checkNotNull(context);
        Context<Object> context2 = context;
        Message message2 = message;
        if (message2 instanceof Message.ConnectionInitMessage) {
            logger.info("Initialized connection for {}", (Object)session.getId());
            if (context2.setConnectionInitReceived()) {
                session.close(new CloseStatus(CloseCode.BadRequest.getCode(), "Too many initialisation requests"));
                return;
            }
            this.sessions.add(session);
            context2.setConnectionParams(((Message.ConnectionInitMessage)message).getPayload());
            try {
                session.sendMessage((WebSocketMessage)new TextMessage(objectMapper.writeValueAsBytes((Object)new Message.ConnectionAckMessage(null, 1, null))));
                context2.setAcknowledged(true);
            }
            catch (Throwable e) {
                session.close(new CloseStatus(CloseCode.Forbidden.getCode(), "Forbidden"));
            }
        } else if (message2 instanceof Message.PingMessage) {
            session.sendMessage((WebSocketMessage)new TextMessage(objectMapper.writeValueAsBytes((Object)new Message.PongMessage(((Message.PingMessage)message).getPayload()))));
        } else if (!(message2 instanceof Message.PongMessage)) {
            if (message2 instanceof Message.SubscribeMessage) {
                if (!context2.getAcknowledged()) {
                    session.close(new CloseStatus(CloseCode.Unauthorized.getCode(), "Unauthorized"));
                    return;
                }
                String id = ((Message.SubscribeMessage)message).component1();
                Message.SubscribeMessage.Payload payload = ((Message.SubscribeMessage)message).component2();
                if (context2.getSubscriptions().contains(id)) {
                    session.close(new CloseStatus(CloseCode.SubscriberAlreadyExists.getCode(), "Subscriber for " + id + " already exists"));
                    return;
                }
                this.handleSubscription(id, payload, session);
            } else if (message2 instanceof Message.CompleteMessage) {
                Subscription subscription;
                logger.info("Complete subscription for " + ((Message.CompleteMessage)message).getId());
                Subscription subscription2 = subscription = context2.getSubscriptions().remove(((Message.CompleteMessage)message).getId());
                if (subscription2 != null) {
                    subscription2.cancel();
                }
            } else {
                session.close(new CloseStatus(CloseCode.BadRequest.getCode(), "Unexpected message format"));
            }
        }
    }

    private final void cleanupSubscriptionsForSession(WebSocketSession session) {
        logger.info("Cleaning up for session {}", (Object)session.getId());
        Object object = this.contexts.get(session.getId());
        if (object != null && (object = ((Context)object).getSubscriptions()) != null && (object = ((ConcurrentHashMap)object).values()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Subscription it = (Subscription)element$iv;
                boolean bl = false;
                it.cancel();
            }
        }
        this.contexts.remove(session.getId());
        this.sessions.remove(session);
    }

    private final void handleSubscription(String id, Message.SubscribeMessage.Payload payload, WebSocketSession session) {
        ExecutionResult executionResult = this.dgsQueryExecutor.execute(payload.getQuery(), payload.getVariables(), payload.getExtensions(), null, payload.getOperationName(), null);
        Intrinsics.checkNotNullExpressionValue((Object)executionResult, (String)"dgsQueryExecutor.execute\u2026       null\n            )");
        ExecutionResult executionResult2 = executionResult;
        Object object = executionResult2.getData();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"executionResult.getData()");
        Publisher subscriptionStream = (Publisher)object;
        subscriptionStream.subscribe((Subscriber)new Subscriber<ExecutionResult>(id, this, session){
            final /* synthetic */ String $id;
            final /* synthetic */ WebsocketGraphQLTransportWSProtocolHandler this$0;
            final /* synthetic */ WebSocketSession $session;
            {
                this.$id = $id;
                this.this$0 = $receiver;
                this.$session = $session;
            }

            public void onSubscribe(@NotNull Subscription s) {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                WebsocketGraphQLTransportWSProtocolHandler.access$getCompanion$p().getLogger().info("Subscription started for {}", (Object)this.$id);
                Context<Object> context = this.this$0.getContexts$graphql_dgs_subscriptions_websockets().get(this.$session.getId());
                if (context != null && (context = context.getSubscriptions()) != null) {
                    ((Map)((Object)context)).put(this.$id, s);
                }
                s.request(1L);
            }

            public void onNext(@NotNull ExecutionResult er) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)er, (String)"er");
                    Object object = er.getData();
                    List list = er.getErrors();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"er.errors");
                    com.netflix.graphql.types.subscription.websockets.ExecutionResult executionResult = new com.netflix.graphql.types.subscription.websockets.ExecutionResult(object, list);
                    Message.NextMessage message = new Message.NextMessage(this.$id, executionResult);
                    TextMessage jsonMessage = new TextMessage(WebsocketGraphQLTransportWSProtocolHandler.access$getCompanion$p().getObjectMapper().writeValueAsBytes((Object)message));
                    WebsocketGraphQLTransportWSProtocolHandler.access$getCompanion$p().getLogger().debug("Sending subscription data: {}", (Object)jsonMessage);
                    if (!this.$session.isOpen()) break block1;
                    this.$session.sendMessage((WebSocketMessage)jsonMessage);
                    Context<Object> context = this.this$0.getContexts$graphql_dgs_subscriptions_websockets().get(this.$session.getId());
                    if (context != null && (context = context.getSubscriptions()) != null && (context = (Subscription)((ConcurrentHashMap)((Object)context)).get(this.$id)) != null) {
                        context.request(1L);
                    }
                }
            }

            public void onError(@NotNull Throwable t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                switch (handleSubscription.WhenMappings.$EnumSwitchMapping$0[WebsocketGraphQLTransportWSProtocolHandler.access$getSubscriptionErrorLogLevel$p(this.this$0).ordinal()]) {
                    case 1: {
                        WebsocketGraphQLTransportWSProtocolHandler.access$getCompanion$p().getLogger().error("Error on subscription {}", (Object)this.$id, (Object)t);
                        break;
                    }
                    case 2: {
                        WebsocketGraphQLTransportWSProtocolHandler.access$getCompanion$p().getLogger().warn("Error on subscription {}", (Object)this.$id, (Object)t);
                        break;
                    }
                    case 3: {
                        WebsocketGraphQLTransportWSProtocolHandler.access$getCompanion$p().getLogger().info("Error on subscription {}: {}", (Object)this.$id, (Object)t.getMessage());
                        break;
                    }
                    case 4: {
                        WebsocketGraphQLTransportWSProtocolHandler.access$getCompanion$p().getLogger().debug("Error on subscription {}", (Object)this.$id, (Object)t);
                        break;
                    }
                    case 5: {
                        WebsocketGraphQLTransportWSProtocolHandler.access$getCompanion$p().getLogger().trace("Error on subscription {}", (Object)this.$id, (Object)t);
                    }
                }
                Message.ErrorMessage message = new Message.ErrorMessage(this.$id, CollectionsKt.listOf((Object)GraphqlErrorBuilder.newError().message(t.getMessage(), new Object[0]).build()));
                TextMessage jsonMessage = new TextMessage(WebsocketGraphQLTransportWSProtocolHandler.access$getCompanion$p().getObjectMapper().writeValueAsBytes((Object)message));
                WebsocketGraphQLTransportWSProtocolHandler.access$getCompanion$p().getLogger().debug("Sending subscription error: {}", (Object)jsonMessage);
                if (this.$session.isOpen()) {
                    this.$session.sendMessage((WebSocketMessage)jsonMessage);
                }
            }

            public void onComplete() {
                block1: {
                    Object object;
                    WebsocketGraphQLTransportWSProtocolHandler.access$getCompanion$p().getLogger().info("Subscription completed for {}", (Object)this.$id);
                    Message.CompleteMessage message = new Message.CompleteMessage(this.$id);
                    TextMessage jsonMessage = new TextMessage(WebsocketGraphQLTransportWSProtocolHandler.access$getCompanion$p().getObjectMapper().writeValueAsBytes((Object)message));
                    if (this.$session.isOpen()) {
                        this.$session.sendMessage((WebSocketMessage)jsonMessage);
                    }
                    if ((object = this.this$0.getContexts$graphql_dgs_subscriptions_websockets().get(this.$session.getId())) == null || (object = ((Context)object).getSubscriptions()) == null) break block1;
                    Subscription cfr_ignored_0 = (Subscription)((ConcurrentHashMap)object).remove(this.$id);
                }
            }
        });
    }

    public static final /* synthetic */ void access$cleanupSubscriptionsForSession(WebsocketGraphQLTransportWSProtocolHandler $this, WebSocketSession session) {
        $this.cleanupSubscriptionsForSession(session);
    }

    public static final /* synthetic */ Companion access$getCompanion$p() {
        return Companion;
    }

    public static final /* synthetic */ Level access$getSubscriptionErrorLogLevel$p(WebsocketGraphQLTransportWSProtocolHandler $this) {
        return $this.subscriptionErrorLogLevel;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/netflix/graphql/dgs/subscriptions/websockets/WebsocketGraphQLTransportWSProtocolHandler$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/slf4j/Logger;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "graphql-dgs-subscriptions-websockets"})
    private static final class Companion {
        private Companion() {
        }

        public final Logger getLogger() {
            return logger;
        }

        @NotNull
        public final ObjectMapper getObjectMapper() {
            return objectMapper;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

