/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.subscriptions.websockets;

import com.netflix.graphql.dgs.DgsQueryExecutor;
import com.netflix.graphql.dgs.subscriptions.websockets.DgsWebSocketHandler;
import com.netflix.graphql.dgs.subscriptions.websockets.WebsocketGraphQLTransportWSProtocolHandler;
import com.netflix.graphql.dgs.subscriptions.websockets.WebsocketGraphQLWSProtocolHandler;
import java.time.Duration;
import java.util.List;
import javax.annotation.PostConstruct;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.SubProtocolCapable;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001d2\u00020\u00012\u00020\u0002:\u0001\u001dB\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J\u0018\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u001c\u001a\u00020\u000fH\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/netflix/graphql/dgs/subscriptions/websockets/DgsWebSocketHandler;", "Lorg/springframework/web/socket/handler/TextWebSocketHandler;", "Lorg/springframework/web/socket/SubProtocolCapable;", "dgsQueryExecutor", "Lcom/netflix/graphql/dgs/DgsQueryExecutor;", "connectionInitTimeout", "Ljava/time/Duration;", "subscriptionErrorLogLevel", "Lorg/slf4j/event/Level;", "(Lcom/netflix/graphql/dgs/DgsQueryExecutor;Ljava/time/Duration;Lorg/slf4j/event/Level;)V", "graphqlTransportWSHandler", "Lcom/netflix/graphql/dgs/subscriptions/websockets/WebsocketGraphQLTransportWSProtocolHandler;", "graphqlWSHandler", "Lcom/netflix/graphql/dgs/subscriptions/websockets/WebsocketGraphQLWSProtocolHandler;", "afterConnectionClosed", "", "session", "Lorg/springframework/web/socket/WebSocketSession;", "status", "Lorg/springframework/web/socket/CloseStatus;", "afterConnectionEstablished", "getSubProtocols", "", "", "handleTextMessage", "message", "Lorg/springframework/web/socket/TextMessage;", "loadSecurityContextFromSession", "setupCleanup", "Companion", "graphql-dgs-subscriptions-websockets"})
public final class DgsWebSocketHandler
extends TextWebSocketHandler
implements SubProtocolCapable {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final WebsocketGraphQLWSProtocolHandler graphqlWSHandler;
    @NotNull
    private final WebsocketGraphQLTransportWSProtocolHandler graphqlTransportWSHandler;
    @Deprecated
    private static final Logger logger = LoggerFactory.getLogger(DgsWebSocketHandler.class);
    @Deprecated
    @NotNull
    private static final Lazy<Boolean> springSecurityAvailable$delegate = LazyKt.lazy((Function0)Companion.springSecurityAvailable.2.INSTANCE);

    public DgsWebSocketHandler(@NotNull DgsQueryExecutor dgsQueryExecutor, @NotNull Duration connectionInitTimeout, @NotNull Level subscriptionErrorLogLevel) {
        Intrinsics.checkNotNullParameter((Object)dgsQueryExecutor, (String)"dgsQueryExecutor");
        Intrinsics.checkNotNullParameter((Object)connectionInitTimeout, (String)"connectionInitTimeout");
        Intrinsics.checkNotNullParameter((Object)subscriptionErrorLogLevel, (String)"subscriptionErrorLogLevel");
        this.graphqlWSHandler = new WebsocketGraphQLWSProtocolHandler(dgsQueryExecutor, subscriptionErrorLogLevel);
        this.graphqlTransportWSHandler = new WebsocketGraphQLTransportWSProtocolHandler(dgsQueryExecutor, connectionInitTimeout, subscriptionErrorLogLevel);
    }

    @PostConstruct
    public final void setupCleanup() {
        try {
            this.graphqlWSHandler.setupCleanup();
        }
        catch (Exception e) {
            logger.error("Error setting up cleanup subscriptions tasks");
        }
        try {
            this.graphqlTransportWSHandler.setupCleanup();
        }
        catch (Exception e) {
            logger.error("Error setting up cleanup subscriptions tasks");
        }
    }

    public void afterConnectionEstablished(@NotNull WebSocketSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        try {
            this.graphqlWSHandler.afterConnectionEstablished(session);
        }
        catch (Exception e) {
            logger.error("Unable to handle connection established for " + session.getId());
        }
        try {
            this.graphqlTransportWSHandler.afterConnectionEstablished(session);
        }
        catch (Exception e) {
            logger.error("Unable to handle connection established for " + session.getId());
        }
    }

    public void afterConnectionClosed(@NotNull WebSocketSession session, @NotNull CloseStatus status) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        try {
            this.graphqlWSHandler.afterConnectionClosed(session, status);
        }
        catch (Exception e) {
            logger.error("Error closing connection for session " + session.getId());
        }
        try {
            this.graphqlTransportWSHandler.afterConnectionClosed(session, status);
        }
        catch (Exception e) {
            logger.error("Error closing connection for session " + session.getId());
        }
    }

    public void handleTextMessage(@NotNull WebSocketSession session, @NotNull TextMessage message) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.loadSecurityContextFromSession(session);
        if (StringsKt.equals((String)session.getAcceptedProtocol(), (String)"graphql-ws", (boolean)true)) {
            this.graphqlWSHandler.handleTextMessage(session, message);
            return;
        }
        if (StringsKt.equals((String)session.getAcceptedProtocol(), (String)"graphql-transport-ws", (boolean)true)) {
            this.graphqlTransportWSHandler.handleTextMessage(session, message);
            return;
        }
    }

    private final void loadSecurityContextFromSession(WebSocketSession session) {
        if (DgsWebSocketHandler.Companion.getSpringSecurityAvailable()) {
            SecurityContext securityContext;
            Object v = session.getAttributes().get("SPRING_SECURITY_CONTEXT");
            SecurityContext securityContext2 = securityContext = v instanceof SecurityContext ? (SecurityContext)v : null;
            if (securityContext != null) {
                SecurityContextHolder.setContext((SecurityContext)securityContext);
            }
        }
    }

    @NotNull
    public List<String> getSubProtocols() {
        Object[] objectArray = new String[]{"graphql-ws", "graphql-transport-ws"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/netflix/graphql/dgs/subscriptions/websockets/DgsWebSocketHandler$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/slf4j/Logger;", "springSecurityAvailable", "", "getSpringSecurityAvailable", "()Z", "springSecurityAvailable$delegate", "Lkotlin/Lazy;", "graphql-dgs-subscriptions-websockets"})
    private static final class Companion {
        private Companion() {
        }

        public final Logger getLogger() {
            return logger;
        }

        private final boolean getSpringSecurityAvailable() {
            Lazy lazy = springSecurityAvailable$delegate;
            return (Boolean)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

