/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.subscriptions.websockets;

import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.server.support.HttpSessionHandshakeInterceptor;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J4\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013H\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/netflix/graphql/dgs/subscriptions/websockets/DgsHandshakeInterceptor;", "Lorg/springframework/web/socket/server/support/HttpSessionHandshakeInterceptor;", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "afterHandshake", "", "request", "Lorg/springframework/http/server/ServerHttpRequest;", "response", "Lorg/springframework/http/server/ServerHttpResponse;", "wsHandler", "Lorg/springframework/web/socket/WebSocketHandler;", "exception", "Ljava/lang/Exception;", "beforeHandshake", "", "attributes", "", "", "", "graphql-dgs-subscriptions-websockets"})
public final class DgsHandshakeInterceptor
extends HttpSessionHandshakeInterceptor {
    private final Logger logger = LoggerFactory.getLogger(DgsHandshakeInterceptor.class);

    public boolean beforeHandshake(@NotNull ServerHttpRequest request, @NotNull ServerHttpResponse response, @NotNull WebSocketHandler wsHandler, @NotNull Map<String, Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)wsHandler, (String)"wsHandler");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Collection collection = (Collection)request.getHeaders().get((Object)"Sec-WebSocket-Protocol");
        if (collection == null || collection.isEmpty()) {
            request.getHeaders().set("Sec-WebSocket-Protocol", "graphql-ws");
            request.getHeaders().set("Sec-WebSocket-Protocol", "graphql-transport-ws");
        }
        return super.beforeHandshake(request, response, wsHandler, attributes);
    }

    public void afterHandshake(@NotNull ServerHttpRequest request, @NotNull ServerHttpResponse response, @NotNull WebSocketHandler wsHandler, @Nullable Exception exception) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)wsHandler, (String)"wsHandler");
    }
}

