/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.subscriptions.graphql.sse;

import com.netflix.graphql.dgs.DgsQueryExecutor;
import com.netflix.graphql.dgs.subscriptions.graphql.sse.DgsGraphQLSSESubscriptionHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.web.servlet.DispatcherServlet;

@AutoConfiguration
@ConditionalOnWebApplication
@ConditionalOnClass(value={DispatcherServlet.class})
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/netflix/graphql/dgs/subscriptions/graphql/sse/DgsGraphQLSSEAutoConfig;", "", "pollPeriod", "", "(J)V", "getPollPeriod", "()J", "DgsGraphqlSSEController", "Lcom/netflix/graphql/dgs/subscriptions/graphql/sse/DgsGraphQLSSESubscriptionHandler;", "dgsQueryExecutor", "Lcom/netflix/graphql/dgs/DgsQueryExecutor;", "graphql-dgs-subscriptions-graphql-sse-autoconfigure"})
public class DgsGraphQLSSEAutoConfig {
    private final long pollPeriod;

    public DgsGraphQLSSEAutoConfig(@Value(value="${dgs.graphql.sse.pollPeriod:12000}") long pollPeriod) {
        this.pollPeriod = pollPeriod;
    }

    public long getPollPeriod() {
        return this.pollPeriod;
    }

    @Bean
    @NotNull
    public DgsGraphQLSSESubscriptionHandler DgsGraphqlSSEController(@NotNull DgsQueryExecutor dgsQueryExecutor) {
        Intrinsics.checkNotNullParameter((Object)dgsQueryExecutor, (String)"dgsQueryExecutor");
        return new DgsGraphQLSSESubscriptionHandler(dgsQueryExecutor, this.getPollPeriod());
    }
}

