/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.mocking;

import com.netflix.graphql.mocking.MockGraphQLVisitor;
import com.netflix.graphql.mocking.MockProvider;
import graphql.schema.DataFetcher;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.SchemaTraverser;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0010\u0010\u0006\u001a\f\u0012\u0004\u0012\u00020\b\u0012\u0002\b\u00030\u0007J\u001c\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a8\u0006\r"}, d2={"Lcom/netflix/graphql/mocking/DgsSchemaTransformer;", "", "()V", "transformSchema", "Lgraphql/schema/GraphQLSchema;", "schema", "mockConfig", "", "", "transformSchemaWithMockProviders", "mockProviders", "", "Lcom/netflix/graphql/mocking/MockProvider;", "graphql-dgs-mocking"})
@SourceDebugExtension(value={"SMAP\nDgsSchemaTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DgsSchemaTransformer.kt\ncom/netflix/graphql/mocking/DgsSchemaTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,48:1\n1855#2,2:49\n215#3,2:51\n*S KotlinDebug\n*F\n+ 1 DgsSchemaTransformer.kt\ncom/netflix/graphql/mocking/DgsSchemaTransformer\n*L\n27#1:49,2\n39#1:51,2\n*E\n"})
public final class DgsSchemaTransformer {
    @NotNull
    public final GraphQLSchema transformSchemaWithMockProviders(@NotNull GraphQLSchema schema, @NotNull Set<? extends MockProvider> mockProviders) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(mockProviders, (String)"mockProviders");
        HashMap<String, Object> mockConfig = new HashMap<String, Object>();
        Iterable $this$forEach$iv = mockProviders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MockProvider p = (MockProvider)element$iv;
            boolean bl = false;
            mockConfig.putAll(p.provide());
        }
        return this.transformSchema(schema, (Map)mockConfig);
    }

    @NotNull
    public final GraphQLSchema transformSchema(@NotNull GraphQLSchema schema, @NotNull Map<String, ?> mockConfig) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(mockConfig, (String)"mockConfig");
        HashMap mockFetchers = new HashMap();
        MockGraphQLVisitor graphQLTypeVisitorStub = new MockGraphQLVisitor(mockConfig, mockFetchers);
        new SchemaTraverser().depthFirst((GraphQLTypeVisitor)graphQLTypeVisitorStub, (GraphQLSchemaElement)schema.getType("Query"));
        GraphQLSchema graphQLSchema = schema.transform(arg_0 -> DgsSchemaTransformer.transformSchema$lambda$2(schema, mockFetchers, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)graphQLSchema, (String)"transform(...)");
        return graphQLSchema;
    }

    private static final void transformSchema$lambda$2(GraphQLSchema $schema, HashMap $mockFetchers, GraphQLSchema.Builder b) {
        Intrinsics.checkNotNullParameter((Object)$schema, (String)"$schema");
        Intrinsics.checkNotNullParameter((Object)$mockFetchers, (String)"$mockFetchers");
        GraphQLCodeRegistry.Builder newCodeRegistry = GraphQLCodeRegistry.newCodeRegistry((GraphQLCodeRegistry)$schema.getCodeRegistry());
        Map $this$forEach$iv = $mockFetchers;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            FieldCoordinates coordinates = (FieldCoordinates)entry.getKey();
            DataFetcher dataFetcher = (DataFetcher)entry.getValue();
            newCodeRegistry.dataFetcher(coordinates, dataFetcher);
        }
        b.codeRegistry(newCodeRegistry.build());
    }
}

