/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework.recipes.shared;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.netflix.curator.framework.CuratorFramework;
import com.netflix.curator.framework.api.BackgroundPathAndBytesable;
import com.netflix.curator.framework.api.CuratorWatcher;
import com.netflix.curator.framework.api.Pathable;
import com.netflix.curator.framework.api.WatchPathable;
import com.netflix.curator.framework.listen.ListenerContainer;
import com.netflix.curator.framework.recipes.shared.SharedValueListener;
import com.netflix.curator.framework.recipes.shared.SharedValueReader;
import com.netflix.curator.framework.state.ConnectionState;
import com.netflix.curator.framework.state.ConnectionStateListener;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedValue
implements Closeable,
SharedValueReader {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ListenerContainer<SharedValueListener> listeners = new ListenerContainer();
    private final CuratorFramework client;
    private final String path;
    private final byte[] seedValue;
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);
    private final CuratorWatcher watcher = new CuratorWatcher(){

        public void process(WatchedEvent event) throws Exception {
            if (SharedValue.this.state.get() == State.STARTED) {
                SharedValue.this.readValue();
                SharedValue.this.notifyListeners();
            }
        }
    };
    private final ConnectionStateListener connectionStateListener = new ConnectionStateListener(){

        public void stateChanged(CuratorFramework client, ConnectionState newState) {
            SharedValue.this.notifyListenerOfStateChanged(newState);
        }
    };
    private volatile byte[] value;
    private volatile Stat stat = new Stat();

    public SharedValue(CuratorFramework client, String path, byte[] seedValue) {
        this.client = client;
        this.path = path;
        this.seedValue = Arrays.copyOf(seedValue, seedValue.length);
        this.value = seedValue;
    }

    @Override
    public byte[] getValue() {
        return Arrays.copyOf(this.value, this.value.length);
    }

    public void setValue(byte[] newValue) throws Exception {
        Preconditions.checkState((this.state.get() == State.STARTED ? 1 : 0) != 0, (Object)"not started");
        this.client.setData().forPath(this.path, newValue);
        this.stat.setVersion(this.stat.getVersion() + 1);
        this.value = Arrays.copyOf(newValue, newValue.length);
    }

    public boolean trySetValue(byte[] newValue) throws Exception {
        Preconditions.checkState((this.state.get() == State.STARTED ? 1 : 0) != 0, (Object)"not started");
        try {
            ((BackgroundPathAndBytesable)this.client.setData().withVersion(this.stat.getVersion())).forPath(this.path, newValue);
            this.stat.setVersion(this.stat.getVersion() + 1);
            this.value = Arrays.copyOf(newValue, newValue.length);
            return true;
        }
        catch (KeeperException.BadVersionException badVersionException) {
            this.readValue();
            return false;
        }
    }

    @Override
    public ListenerContainer<SharedValueListener> getListenable() {
        return this.listeners;
    }

    public void start() throws Exception {
        Preconditions.checkState((boolean)this.state.compareAndSet(State.LATENT, State.STARTED), (Object)"Cannot be started more than once");
        this.client.getConnectionStateListenable().addListener((Object)this.connectionStateListener);
        try {
            this.client.create().creatingParentsIfNeeded().forPath(this.path, this.seedValue);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            // empty catch block
        }
        this.readValue();
    }

    @Override
    public void close() throws IOException {
        this.client.getConnectionStateListenable().removeListener((Object)this.connectionStateListener);
        this.state.set(State.CLOSED);
        this.listeners.clear();
    }

    private synchronized void readValue() throws Exception {
        Stat localStat = new Stat();
        byte[] bytes = (byte[])((Pathable)((WatchPathable)this.client.getData().storingStatIn(localStat)).usingWatcher(this.watcher)).forPath(this.path);
        this.stat = localStat;
        this.value = bytes;
    }

    private void notifyListeners() {
        this.listeners.forEach((Function)new Function<SharedValueListener, Void>(){

            public Void apply(SharedValueListener listener) {
                try {
                    listener.valueHasChanged(SharedValue.this, SharedValue.this.value);
                }
                catch (Exception e) {
                    SharedValue.this.log.error("From SharedValue listener", (Throwable)e);
                }
                return null;
            }
        });
    }

    private void notifyListenerOfStateChanged(final ConnectionState newState) {
        this.listeners.forEach((Function)new Function<SharedValueListener, Void>(){

            public Void apply(SharedValueListener listener) {
                listener.stateChanged(SharedValue.this.client, newState);
                return null;
            }
        });
    }

    private static enum State {
        LATENT,
        STARTED,
        CLOSED;

    }
}

