/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework.recipes.cache;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.netflix.curator.framework.CuratorFramework;
import com.netflix.curator.framework.api.BackgroundCallback;
import com.netflix.curator.framework.api.BackgroundPathable;
import com.netflix.curator.framework.api.CuratorEvent;
import com.netflix.curator.framework.api.CuratorWatcher;
import com.netflix.curator.framework.api.GetDataWatchBackgroundStatable;
import com.netflix.curator.framework.api.Pathable;
import com.netflix.curator.framework.api.WatchPathable;
import com.netflix.curator.framework.listen.ListenerContainer;
import com.netflix.curator.framework.recipes.cache.ChildData;
import com.netflix.curator.framework.recipes.cache.NodeCacheListener;
import com.netflix.curator.framework.state.ConnectionState;
import com.netflix.curator.framework.state.ConnectionStateListener;
import com.netflix.curator.utils.EnsurePath;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Exchanger;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeCache
implements Closeable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CuratorFramework client;
    private final String path;
    private final boolean dataIsCompressed;
    private final EnsurePath ensurePath;
    private final AtomicReference<ChildData> data = new AtomicReference<Object>(null);
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);
    private final ListenerContainer<NodeCacheListener> listeners = new ListenerContainer();
    private final AtomicBoolean isConnected = new AtomicBoolean(true);
    private final ConnectionStateListener connectionStateListener = new ConnectionStateListener(){

        public void stateChanged(CuratorFramework client, ConnectionState newState) {
            if (newState == ConnectionState.CONNECTED || newState == ConnectionState.RECONNECTED) {
                if (NodeCache.this.isConnected.compareAndSet(false, true)) {
                    try {
                        NodeCache.this.reset();
                    }
                    catch (Exception e) {
                        NodeCache.this.log.error("Trying to reset after reconnection", (Throwable)e);
                    }
                }
            } else {
                NodeCache.this.isConnected.set(false);
            }
        }
    };
    private final CuratorWatcher watcher = new CuratorWatcher(){

        public void process(WatchedEvent event) throws Exception {
            NodeCache.this.reset();
        }
    };
    private final BackgroundCallback backgroundCallback = new BackgroundCallback(){

        public void processResult(CuratorFramework client, CuratorEvent event) throws Exception {
            NodeCache.this.processBackgroundResult(event);
        }
    };
    @VisibleForTesting
    volatile Exchanger<Object> rebuildTestExchanger;

    public NodeCache(CuratorFramework client, String path) {
        this(client, path, false);
    }

    public NodeCache(CuratorFramework client, String path, boolean dataIsCompressed) {
        this.client = client;
        this.path = path;
        this.dataIsCompressed = dataIsCompressed;
        this.ensurePath = client.newNamespaceAwareEnsurePath(path).excludingLast();
    }

    public void start() throws Exception {
        this.start(false);
    }

    public void start(boolean buildInitial) throws Exception {
        Preconditions.checkState((boolean)this.state.compareAndSet(State.LATENT, State.STARTED), (Object)"Cannot be started more than once");
        this.ensurePath.ensure(this.client.getZookeeperClient());
        this.client.getConnectionStateListenable().addListener((Object)this.connectionStateListener);
        if (buildInitial) {
            this.internalRebuild();
        }
        this.reset();
    }

    @Override
    public void close() throws IOException {
        if (this.state.compareAndSet(State.STARTED, State.CLOSED)) {
            this.listeners.clear();
        }
        this.client.getConnectionStateListenable().removeListener((Object)this.connectionStateListener);
    }

    public ListenerContainer<NodeCacheListener> getListenable() {
        Preconditions.checkState((this.state.get() != State.CLOSED ? 1 : 0) != 0, (Object)"Closed");
        return this.listeners;
    }

    public void rebuild() throws Exception {
        Preconditions.checkState((this.state.get() == State.STARTED ? 1 : 0) != 0, (Object)"Not started");
        this.internalRebuild();
        this.reset();
    }

    public ChildData getCurrentData() {
        return this.data.get();
    }

    private void reset() throws Exception {
        if (this.state.get() == State.STARTED && this.isConnected.get()) {
            ((Pathable)((BackgroundPathable)this.client.checkExists().usingWatcher(this.watcher)).inBackground(this.backgroundCallback)).forPath(this.path);
        }
    }

    private void internalRebuild() throws Exception {
        try {
            Stat stat = new Stat();
            byte[] bytes = this.dataIsCompressed ? (byte[])((WatchPathable)((GetDataWatchBackgroundStatable)this.client.getData().decompressed()).storingStatIn(stat)).forPath(this.path) : (byte[])((WatchPathable)this.client.getData().storingStatIn(stat)).forPath(this.path);
            this.data.set(new ChildData(this.path, stat, bytes));
        }
        catch (KeeperException.NoNodeException e) {
            this.data.set(null);
        }
    }

    private void processBackgroundResult(CuratorEvent event) throws Exception {
        switch (event.getType()) {
            case GET_DATA: {
                if (event.getResultCode() != KeeperException.Code.OK.intValue()) break;
                ChildData childData = new ChildData(this.path, event.getStat(), event.getData());
                this.setNewData(childData);
                break;
            }
            case EXISTS: {
                if (event.getResultCode() == KeeperException.Code.NONODE.intValue()) {
                    this.setNewData(null);
                    break;
                }
                if (event.getResultCode() != KeeperException.Code.OK.intValue()) break;
                if (this.dataIsCompressed) {
                    ((Pathable)((BackgroundPathable)((GetDataWatchBackgroundStatable)this.client.getData().decompressed()).usingWatcher(this.watcher)).inBackground(this.backgroundCallback)).forPath(this.path);
                    break;
                }
                ((Pathable)((BackgroundPathable)this.client.getData().usingWatcher(this.watcher)).inBackground(this.backgroundCallback)).forPath(this.path);
            }
        }
    }

    private void setNewData(ChildData newData) throws InterruptedException {
        ChildData previousData = this.data.getAndSet(newData);
        if (!Objects.equal((Object)previousData, (Object)newData)) {
            this.listeners.forEach((Function)new Function<NodeCacheListener, Void>(){

                public Void apply(NodeCacheListener listener) {
                    try {
                        listener.nodeChanged();
                    }
                    catch (Exception e) {
                        NodeCache.this.log.error("Calling listener", (Throwable)e);
                    }
                    return null;
                }
            });
            if (this.rebuildTestExchanger != null) {
                try {
                    this.rebuildTestExchanger.exchange(new Object());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private static enum State {
        LATENT,
        STARTED,
        CLOSED;

    }
}

