/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.util;

import com.mockrunner.util.common.CaseAwareMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;

public class CaseAwareMapTest
extends TestCase {
    private CaseAwareMap map;

    protected void setUp() throws Exception {
        super.setUp();
        this.map = new CaseAwareMap();
    }

    public void testSetCaseSensitive() {
        CaseAwareMapTest.assertFalse((boolean)this.map.isCaseSensitive());
        this.map.setCaseSensitive(true);
        CaseAwareMapTest.assertTrue((boolean)this.map.isCaseSensitive());
        this.map.put("test", "abc");
        this.map.put(new Integer(3), "abc");
        this.map.setCaseSensitive(true);
        CaseAwareMapTest.assertEquals((int)0, (int)this.map.size());
    }

    public void testSize() {
        CaseAwareMapTest.assertEquals((int)0, (int)this.map.size());
        this.map.put("test", "abc");
        this.map.put(new Integer(3), "abc");
        CaseAwareMapTest.assertEquals((int)2, (int)this.map.size());
        this.map.setCaseSensitive(true);
        this.map.put(new Integer(3), "abc");
        CaseAwareMapTest.assertEquals((int)1, (int)this.map.size());
    }

    public void testIsEmptyAndClear() {
        CaseAwareMapTest.assertTrue((boolean)this.map.isEmpty());
        this.map.clear();
        CaseAwareMapTest.assertTrue((boolean)this.map.isEmpty());
        this.map.put(new Integer(3), "abc");
        CaseAwareMapTest.assertFalse((boolean)this.map.isEmpty());
        this.map.clear();
        CaseAwareMapTest.assertTrue((boolean)this.map.isEmpty());
    }

    public void testKeySet() {
        Set set = this.map.keySet();
        CaseAwareMapTest.assertTrue((boolean)set.isEmpty());
        this.map.put("Test", "1");
        this.map.put("XyZ", "2");
        this.map.put("TEST", "3");
        this.map.put(new Double(4.0), "4");
        set = this.map.keySet();
        CaseAwareMapTest.assertEquals((int)3, (int)set.size());
        CaseAwareMapTest.assertTrue((boolean)set.contains("Test"));
        CaseAwareMapTest.assertTrue((boolean)set.contains("XyZ"));
        CaseAwareMapTest.assertTrue((boolean)set.contains(new Double(4.0)));
        this.map.setCaseSensitive(true);
        this.map.put("Test", "1");
        this.map.put("XyZ", "2");
        this.map.put("TEST", "3");
        this.map.put(new Double(4.0), "4");
        CaseAwareMapTest.assertEquals((int)4, (int)set.size());
        set = this.map.keySet();
        CaseAwareMapTest.assertTrue((boolean)set.contains("Test"));
        CaseAwareMapTest.assertTrue((boolean)set.contains("XyZ"));
        CaseAwareMapTest.assertTrue((boolean)set.contains(new Double(4.0)));
        CaseAwareMapTest.assertTrue((boolean)set.contains("TEST"));
    }

    public void testPut() {
        CaseAwareMapTest.assertNull((Object)this.map.put("Test", "abc"));
        CaseAwareMapTest.assertEquals((Object)"abc", (Object)this.map.put("TEST", "def"));
        CaseAwareMapTest.assertEquals((Object)"def", (Object)this.map.put("TesT", "ghi"));
        CaseAwareMapTest.assertEquals((Object)"ghi", (Object)this.map.put("test", "jkl"));
        CaseAwareMapTest.assertEquals((int)1, (int)this.map.size());
        Set set = this.map.keySet();
        CaseAwareMapTest.assertEquals((int)1, (int)set.size());
        CaseAwareMapTest.assertTrue((boolean)set.contains("Test"));
        this.map.setCaseSensitive(true);
        CaseAwareMapTest.assertNull((Object)this.map.put("Test", "abc"));
        CaseAwareMapTest.assertNull((Object)this.map.put("TEST", "def"));
        CaseAwareMapTest.assertNull((Object)this.map.put("TesT", "ghi"));
        CaseAwareMapTest.assertNull((Object)this.map.put("test", "jkl"));
        CaseAwareMapTest.assertEquals((int)4, (int)this.map.size());
    }

    public void testPutAll() {
        HashMap<Object, String> otherMap = new HashMap<Object, String>();
        otherMap.put("hello", "1");
        otherMap.put("heLLo", "2");
        otherMap.put(new Integer(3), "3");
        this.map.putAll(otherMap);
        CaseAwareMapTest.assertEquals((int)2, (int)this.map.size());
        this.map.setCaseSensitive(true);
        this.map.putAll(otherMap);
        CaseAwareMapTest.assertEquals((int)3, (int)this.map.size());
    }

    public void testGet() {
        Object object = new Object();
        this.map.put("Test", object);
        this.map.put(new Integer(1), "123");
        CaseAwareMapTest.assertSame((Object)object, (Object)this.map.get("test"));
        CaseAwareMapTest.assertSame((Object)object, (Object)this.map.get("Test"));
        CaseAwareMapTest.assertSame((Object)object, (Object)this.map.get("TEST"));
        CaseAwareMapTest.assertEquals((Object)"123", (Object)this.map.get(new Integer(1)));
        this.map.setCaseSensitive(true);
        this.map.put("Test", object);
        CaseAwareMapTest.assertNull((Object)this.map.get("test"));
        CaseAwareMapTest.assertNull((Object)this.map.get("TEST"));
        CaseAwareMapTest.assertSame((Object)object, (Object)this.map.get("Test"));
    }

    public void testValues() {
        this.map.put("Test", "1");
        this.map.put("TEST", "2");
        this.map.put("TeSt", "3");
        this.map.put(new Integer(1), "123");
        CaseAwareMapTest.assertEquals((int)2, (int)this.map.values().size());
        CaseAwareMapTest.assertTrue((boolean)this.map.values().contains("3"));
        CaseAwareMapTest.assertTrue((boolean)this.map.values().contains("123"));
        this.map.setCaseSensitive(true);
        this.map.put("Test", "1");
        this.map.put("TEST", "2");
        this.map.put("TeSt", "3");
        this.map.put(new Integer(1), "123");
        CaseAwareMapTest.assertEquals((int)4, (int)this.map.values().size());
        CaseAwareMapTest.assertTrue((boolean)this.map.values().contains("1"));
        CaseAwareMapTest.assertTrue((boolean)this.map.values().contains("2"));
        CaseAwareMapTest.assertTrue((boolean)this.map.values().contains("3"));
        CaseAwareMapTest.assertTrue((boolean)this.map.values().contains("123"));
    }

    public void testContainsKey() {
        Object key = new Object();
        this.map.put("Test", "1");
        this.map.put("TEST", "2");
        this.map.put("TeSt", "3");
        this.map.put(key, "4");
        CaseAwareMapTest.assertTrue((boolean)this.map.containsKey("Test"));
        CaseAwareMapTest.assertTrue((boolean)this.map.containsKey("TEST"));
        CaseAwareMapTest.assertTrue((boolean)this.map.containsKey("TeSt"));
        CaseAwareMapTest.assertTrue((boolean)this.map.containsKey("tEsT"));
        CaseAwareMapTest.assertFalse((boolean)this.map.containsKey("Test1"));
        CaseAwareMapTest.assertTrue((boolean)this.map.containsKey(key));
        this.map.setCaseSensitive(true);
        this.map.put("Test", "1");
        this.map.put("TEST", "2");
        this.map.put("TeSt", "3");
        this.map.put(key, "4");
        CaseAwareMapTest.assertTrue((boolean)this.map.containsKey("Test"));
        CaseAwareMapTest.assertTrue((boolean)this.map.containsKey("TEST"));
        CaseAwareMapTest.assertTrue((boolean)this.map.containsKey("TeSt"));
        CaseAwareMapTest.assertFalse((boolean)this.map.containsKey("tEsT"));
        CaseAwareMapTest.assertFalse((boolean)this.map.containsKey("Test1"));
        CaseAwareMapTest.assertTrue((boolean)this.map.containsKey(key));
    }

    public void testContainsValue() {
        Object key = new Object();
        this.map.put("Test", "1");
        this.map.put("TEST", "2");
        this.map.put("TeSt", "3");
        this.map.put(key, "4");
        CaseAwareMapTest.assertFalse((boolean)this.map.containsValue("1"));
        CaseAwareMapTest.assertFalse((boolean)this.map.containsValue("2"));
        CaseAwareMapTest.assertTrue((boolean)this.map.containsValue("3"));
        CaseAwareMapTest.assertTrue((boolean)this.map.containsValue("4"));
        this.map.setCaseSensitive(true);
        this.map.put("Test", "1");
        this.map.put("TEST", "2");
        this.map.put("TeSt", "3");
        this.map.put(key, "4");
        CaseAwareMapTest.assertTrue((boolean)this.map.containsValue("1"));
        CaseAwareMapTest.assertTrue((boolean)this.map.containsValue("2"));
        CaseAwareMapTest.assertTrue((boolean)this.map.containsValue("3"));
        CaseAwareMapTest.assertTrue((boolean)this.map.containsValue("4"));
    }

    public void testEntrySet() {
        CaseAwareMapTest.assertEquals((int)0, (int)this.map.entrySet().size());
        this.map.put("Test", "1");
        this.map.put("TEST", "2");
        this.map.put("TeSt", "3");
        CaseAwareMapTest.assertEquals((int)1, (int)this.map.entrySet().size());
        Map.Entry entry = (Map.Entry)this.map.entrySet().iterator().next();
        CaseAwareMapTest.assertEquals((Object)"Test", entry.getKey());
        CaseAwareMapTest.assertEquals((Object)"3", entry.getValue());
        this.map.setCaseSensitive(true);
        this.map.put("Test", "1");
        this.map.put("TEST", "2");
        this.map.put("TeSt", "3");
        CaseAwareMapTest.assertEquals((int)3, (int)this.map.entrySet().size());
    }

    public void testRemove() {
        this.map.put("Test", "0");
        this.map.put("test", "1");
        this.map.put(new Integer(2), "2");
        CaseAwareMapTest.assertEquals((int)2, (int)this.map.size());
        CaseAwareMapTest.assertEquals((Object)"1", (Object)this.map.remove("TeST"));
        CaseAwareMapTest.assertNull((Object)this.map.remove("TEST"));
        CaseAwareMapTest.assertEquals((int)1, (int)this.map.size());
        CaseAwareMapTest.assertEquals((Object)"2", (Object)this.map.remove(new Integer(2)));
        CaseAwareMapTest.assertEquals((int)0, (int)this.map.size());
        this.map.setCaseSensitive(true);
        this.map.put("Test", "1");
        this.map.put(new Integer(2), "2");
        CaseAwareMapTest.assertNull((Object)this.map.remove("TEST"));
        CaseAwareMapTest.assertEquals((Object)"1", (Object)this.map.remove("Test"));
        CaseAwareMapTest.assertNull((Object)this.map.remove("Test"));
        CaseAwareMapTest.assertEquals((int)1, (int)this.map.size());
        CaseAwareMapTest.assertEquals((Object)"2", (Object)this.map.remove(new Integer(2)));
        CaseAwareMapTest.assertNull((Object)this.map.remove(new Integer(2)));
    }
}

