/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.gen;

import com.mockrunner.gen.proc.PackageImportSorter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;

public class PackageImportSorterTest
extends TestCase {
    private PackageImportSorter sorter;

    protected void setUp() throws Exception {
        this.sorter = new PackageImportSorter();
    }

    private List getMatchingTestList() {
        ArrayList<String> imports = new ArrayList<String>();
        imports.add("com.abc.base.Base");
        imports.add("java.util.List");
        imports.add("com.mockrunner.struts.ActionTestCaseAdapter");
        imports.add("java.util.Enumeration");
        imports.add("javax.servlet.jsp.JspException");
        imports.add("org.apache.commons.beanutils.BeanUtils");
        imports.add("javax.sql.DataSource");
        imports.add("java.io.BufferedWriter");
        imports.add("org.apache.struts.action.DynaActionFormClass");
        imports.add("org.mypack.TestClass");
        imports.add("javax.servlet.ServletRequest");
        imports.add("javax.swing.Box");
        imports.add("java.net.URL");
        imports.add("com.mockrunner.test.gen.PackageImportSorterTest");
        return imports;
    }

    private List getNonMatchingTestList() {
        ArrayList<String> imports = new ArrayList<String>();
        imports.add("co.bc.DEF");
        imports.add("co.ac.ABC");
        imports.add("abc.def.Base");
        imports.add("zzzz.yyy.YYY");
        imports.add("uuu.ooo.PPP");
        imports.add("coy.ooo.PPP");
        imports.add("mem.abc.ABC");
        return imports;
    }

    public void testMatchingGroups() {
        List result = this.sorter.sortBlocks(this.getMatchingTestList());
        PackageImportSorterTest.assertEquals((int)4, (int)result.size());
        Iterator block1 = ((Set)result.get(0)).iterator();
        PackageImportSorterTest.assertEquals((Object)"java.io.BufferedWriter", block1.next());
        PackageImportSorterTest.assertEquals((Object)"java.net.URL", block1.next());
        PackageImportSorterTest.assertEquals((Object)"java.util.Enumeration", block1.next());
        PackageImportSorterTest.assertEquals((Object)"java.util.List", block1.next());
        Iterator block2 = ((Set)result.get(1)).iterator();
        PackageImportSorterTest.assertEquals((Object)"javax.servlet.ServletRequest", block2.next());
        PackageImportSorterTest.assertEquals((Object)"javax.servlet.jsp.JspException", block2.next());
        PackageImportSorterTest.assertEquals((Object)"javax.sql.DataSource", block2.next());
        PackageImportSorterTest.assertEquals((Object)"javax.swing.Box", block2.next());
        Iterator block3 = ((Set)result.get(2)).iterator();
        PackageImportSorterTest.assertEquals((Object)"org.apache.commons.beanutils.BeanUtils", block3.next());
        PackageImportSorterTest.assertEquals((Object)"org.apache.struts.action.DynaActionFormClass", block3.next());
        PackageImportSorterTest.assertEquals((Object)"org.mypack.TestClass", block3.next());
        Iterator block4 = ((Set)result.get(3)).iterator();
        PackageImportSorterTest.assertEquals((Object)"com.abc.base.Base", block4.next());
        PackageImportSorterTest.assertEquals((Object)"com.mockrunner.struts.ActionTestCaseAdapter", block4.next());
        PackageImportSorterTest.assertEquals((Object)"com.mockrunner.test.gen.PackageImportSorterTest", block4.next());
    }

    public void testNonMatchingGroups() {
        List result = this.sorter.sortBlocks(this.getNonMatchingTestList());
        PackageImportSorterTest.assertEquals((int)1, (int)result.size());
        Iterator block = ((Set)result.get(0)).iterator();
        PackageImportSorterTest.assertEquals((Object)"abc.def.Base", block.next());
        PackageImportSorterTest.assertEquals((Object)"co.ac.ABC", block.next());
        PackageImportSorterTest.assertEquals((Object)"co.bc.DEF", block.next());
        PackageImportSorterTest.assertEquals((Object)"coy.ooo.PPP", block.next());
        PackageImportSorterTest.assertEquals((Object)"mem.abc.ABC", block.next());
        PackageImportSorterTest.assertEquals((Object)"uuu.ooo.PPP", block.next());
        PackageImportSorterTest.assertEquals((Object)"zzzz.yyy.YYY", block.next());
    }

    public void testMixedGroups() {
        ArrayList testList = new ArrayList();
        testList.addAll(this.getNonMatchingTestList());
        testList.addAll(this.getMatchingTestList());
        List result = this.sorter.sortBlocks(testList);
        PackageImportSorterTest.assertEquals((int)8, (int)result.size());
        Iterator block1 = ((Set)result.get(0)).iterator();
        PackageImportSorterTest.assertEquals((Object)"java.io.BufferedWriter", block1.next());
        PackageImportSorterTest.assertEquals((Object)"java.net.URL", block1.next());
        PackageImportSorterTest.assertEquals((Object)"java.util.Enumeration", block1.next());
        PackageImportSorterTest.assertEquals((Object)"java.util.List", block1.next());
        Iterator block2 = ((Set)result.get(1)).iterator();
        PackageImportSorterTest.assertEquals((Object)"javax.servlet.ServletRequest", block2.next());
        PackageImportSorterTest.assertEquals((Object)"javax.servlet.jsp.JspException", block2.next());
        PackageImportSorterTest.assertEquals((Object)"javax.sql.DataSource", block2.next());
        PackageImportSorterTest.assertEquals((Object)"javax.swing.Box", block2.next());
        Iterator block3 = ((Set)result.get(2)).iterator();
        PackageImportSorterTest.assertEquals((Object)"mem.abc.ABC", block3.next());
        Iterator block4 = ((Set)result.get(3)).iterator();
        PackageImportSorterTest.assertEquals((Object)"org.apache.commons.beanutils.BeanUtils", block4.next());
        PackageImportSorterTest.assertEquals((Object)"org.apache.struts.action.DynaActionFormClass", block4.next());
        PackageImportSorterTest.assertEquals((Object)"org.mypack.TestClass", block4.next());
        Iterator block5 = ((Set)result.get(4)).iterator();
        PackageImportSorterTest.assertEquals((Object)"uuu.ooo.PPP", block5.next());
        PackageImportSorterTest.assertEquals((Object)"zzzz.yyy.YYY", block5.next());
        Iterator block6 = ((Set)result.get(5)).iterator();
        PackageImportSorterTest.assertEquals((Object)"abc.def.Base", block6.next());
        PackageImportSorterTest.assertEquals((Object)"co.ac.ABC", block6.next());
        PackageImportSorterTest.assertEquals((Object)"co.bc.DEF", block6.next());
        Iterator block7 = ((Set)result.get(6)).iterator();
        PackageImportSorterTest.assertEquals((Object)"com.abc.base.Base", block7.next());
        PackageImportSorterTest.assertEquals((Object)"com.mockrunner.struts.ActionTestCaseAdapter", block7.next());
        PackageImportSorterTest.assertEquals((Object)"com.mockrunner.test.gen.PackageImportSorterTest", block7.next());
        Iterator block8 = ((Set)result.get(7)).iterator();
        PackageImportSorterTest.assertEquals((Object)"coy.ooo.PPP", block8.next());
    }

    public void testMixedWithSingleGroup() {
        ArrayList<String> testList = new ArrayList<String>();
        testList.addAll(this.getNonMatchingTestList());
        testList.add("java.util.Enumeration");
        List result = this.sorter.sortBlocks(testList);
        PackageImportSorterTest.assertEquals((int)3, (int)result.size());
        Iterator block1 = ((Set)result.get(0)).iterator();
        PackageImportSorterTest.assertEquals((Object)"abc.def.Base", block1.next());
        PackageImportSorterTest.assertEquals((Object)"co.ac.ABC", block1.next());
        PackageImportSorterTest.assertEquals((Object)"co.bc.DEF", block1.next());
        PackageImportSorterTest.assertEquals((Object)"coy.ooo.PPP", block1.next());
        Iterator block2 = ((Set)result.get(1)).iterator();
        PackageImportSorterTest.assertEquals((Object)"java.util.Enumeration", block2.next());
        Iterator block3 = ((Set)result.get(2)).iterator();
        PackageImportSorterTest.assertEquals((Object)"mem.abc.ABC", block3.next());
        PackageImportSorterTest.assertEquals((Object)"uuu.ooo.PPP", block3.next());
        PackageImportSorterTest.assertEquals((Object)"zzzz.yyy.YYY", block3.next());
    }

    public void testMixedWithTwoGroups() {
        ArrayList<String> testList = new ArrayList<String>();
        testList.addAll(this.getNonMatchingTestList());
        testList.add("java.util.Enumeration");
        testList.add("org.mypack.TestClass");
        List result = this.sorter.sortBlocks(testList);
        PackageImportSorterTest.assertEquals((int)5, (int)result.size());
        Iterator block1 = ((Set)result.get(0)).iterator();
        PackageImportSorterTest.assertEquals((Object)"abc.def.Base", block1.next());
        PackageImportSorterTest.assertEquals((Object)"co.ac.ABC", block1.next());
        PackageImportSorterTest.assertEquals((Object)"co.bc.DEF", block1.next());
        PackageImportSorterTest.assertEquals((Object)"coy.ooo.PPP", block1.next());
        Iterator block2 = ((Set)result.get(1)).iterator();
        PackageImportSorterTest.assertEquals((Object)"java.util.Enumeration", block2.next());
        Iterator block3 = ((Set)result.get(2)).iterator();
        PackageImportSorterTest.assertEquals((Object)"mem.abc.ABC", block3.next());
        Iterator block4 = ((Set)result.get(3)).iterator();
        PackageImportSorterTest.assertEquals((Object)"org.mypack.TestClass", block4.next());
        Iterator block5 = ((Set)result.get(4)).iterator();
        PackageImportSorterTest.assertEquals((Object)"uuu.ooo.PPP", block5.next());
        PackageImportSorterTest.assertEquals((Object)"zzzz.yyy.YYY", block5.next());
    }

    public void testMixedWithThreeGroups() {
        ArrayList<String> testList = new ArrayList<String>();
        testList.addAll(this.getNonMatchingTestList());
        testList.add("java.util.Enumeration");
        testList.add("org.mypack.TestClass");
        testList.add("javax.sql.DataSource");
        List result = this.sorter.sortBlocks(testList);
        PackageImportSorterTest.assertEquals((int)6, (int)result.size());
        Iterator block1 = ((Set)result.get(0)).iterator();
        PackageImportSorterTest.assertEquals((Object)"abc.def.Base", block1.next());
        PackageImportSorterTest.assertEquals((Object)"co.ac.ABC", block1.next());
        PackageImportSorterTest.assertEquals((Object)"co.bc.DEF", block1.next());
        PackageImportSorterTest.assertEquals((Object)"coy.ooo.PPP", block1.next());
        Iterator block2 = ((Set)result.get(1)).iterator();
        PackageImportSorterTest.assertEquals((Object)"java.util.Enumeration", block2.next());
        Iterator block3 = ((Set)result.get(2)).iterator();
        PackageImportSorterTest.assertEquals((Object)"javax.sql.DataSource", block3.next());
        Iterator block4 = ((Set)result.get(3)).iterator();
        PackageImportSorterTest.assertEquals((Object)"mem.abc.ABC", block4.next());
        Iterator block5 = ((Set)result.get(4)).iterator();
        PackageImportSorterTest.assertEquals((Object)"org.mypack.TestClass", block5.next());
        Iterator block6 = ((Set)result.get(5)).iterator();
        PackageImportSorterTest.assertEquals((Object)"uuu.ooo.PPP", block6.next());
        PackageImportSorterTest.assertEquals((Object)"zzzz.yyy.YYY", block6.next());
    }
}

