/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.gen.jar;

import com.kirkk.analyzer.framework.Jar;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class JarFileExtractor {
    private List mainJars;
    private List exceptionJars;

    public JarFileExtractor(List mainJars, List exceptionJars) {
        this.mainJars = new ArrayList(mainJars);
        this.exceptionJars = new ArrayList(exceptionJars);
    }

    public Jar[] filter(Jar[] jars) {
        ArrayList<Jar> finalList = new ArrayList<Jar>();
        for (int ii = 0; ii < jars.length; ++ii) {
            if (!this.mainJars.contains(jars[ii].getJarFileName())) continue;
            finalList.add(jars[ii]);
        }
        return finalList.toArray(new Jar[finalList.size()]);
    }

    public Map createDependencies(Jar[] jars) {
        HashMap<String, Set> finalMap = new HashMap<String, Set>();
        for (int ii = 0; ii < jars.length; ++ii) {
            if (!this.mainJars.contains(jars[ii].getJarFileName())) continue;
            Set currentSet = this.createDependencySet(jars[ii]);
            finalMap.put(jars[ii].getJarFileName(), currentSet);
        }
        return finalMap;
    }

    private Set createDependencySet(Jar jar) {
        TreeSet<String> resultSet = new TreeSet<String>();
        List dependendJars = jar.getOutgoingDependencies();
        if (null == dependendJars) {
            return resultSet;
        }
        for (int ii = 0; ii < dependendJars.size(); ++ii) {
            Jar currentJar = (Jar)dependendJars.get(ii);
            String currentJarFileName = currentJar.getJarFileName();
            resultSet.add(currentJarFileName);
            if (this.exceptionJars.contains(currentJarFileName)) continue;
            resultSet.addAll(this.createDependencySet(currentJar));
        }
        return resultSet;
    }
}

