/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.semanticfunctions;

import com.microsoft.semantickernel.builders.SemanticKernelBuilder;
import com.microsoft.semantickernel.contextvariables.CaseInsensitiveMap;
import com.microsoft.semantickernel.contextvariables.ContextVariable;
import com.microsoft.semantickernel.contextvariables.ContextVariableType;
import com.microsoft.semantickernel.contextvariables.ContextVariableTypeConverter;
import com.microsoft.semantickernel.contextvariables.ContextVariableTypes;
import com.microsoft.semantickernel.exceptions.SKException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import reactor.util.annotation.NonNull;

public class KernelFunctionArguments
implements Map<String, ContextVariable<?>> {
    public static final String MAIN_KEY = "input";
    private final CaseInsensitiveMap<ContextVariable<?>> variables;

    protected KernelFunctionArguments(@Nullable Map<String, ContextVariable<?>> variables) {
        this.variables = variables == null ? new CaseInsensitiveMap() : new CaseInsensitiveMap(variables);
    }

    protected KernelFunctionArguments(@NonNull ContextVariable<?> content) {
        this.variables = new CaseInsensitiveMap();
        this.variables.put(MAIN_KEY, content);
    }

    protected KernelFunctionArguments() {
        this.variables = new CaseInsensitiveMap();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Nullable
    public ContextVariable<?> getInput() {
        return this.get(MAIN_KEY);
    }

    public String prettyPrint() {
        return this.variables.entrySet().stream().reduce("", (str, entry) -> str + System.lineSeparator() + (String)entry.getKey() + ": " + ((ContextVariable)entry.getValue()).toPromptString(ContextVariableTypes.getGlobalTypes()), (a, b) -> a + b);
    }

    @Nullable
    public ContextVariable<?> get(String key) {
        return this.variables.get(key);
    }

    @Nullable
    <T> ContextVariable<T> get(String key, Class<T> clazz) {
        ContextVariable<?> value = this.variables.get(key);
        if (value == null) {
            return null;
        }
        if (clazz.isAssignableFrom(value.getType().getClazz())) {
            return value;
        }
        throw new SKException(String.format("Variable %s is of type %s, but requested type is %s", key, value.getType().getClazz(), clazz));
    }

    public boolean isNullOrEmpty(String key) {
        return this.get(key) == null || this.get(key).isEmpty();
    }

    @Override
    public int size() {
        return this.variables.size();
    }

    @Override
    public boolean isEmpty() {
        return this.variables.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.variables.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.variables.containsValue(value);
    }

    @Override
    @Nullable
    public ContextVariable<?> get(Object key) {
        return this.variables.get(key);
    }

    @Override
    public ContextVariable<?> put(String key, ContextVariable<?> value) {
        return this.variables.put(key, value);
    }

    @Override
    public ContextVariable<?> remove(Object key) {
        return this.variables.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends ContextVariable<?>> m) {
        this.variables.putAll((Map<String, ContextVariable<?>>)m);
    }

    @Override
    public void clear() {
        this.variables.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.variables.keySet();
    }

    @Override
    public Collection<ContextVariable<?>> values() {
        return this.variables.values();
    }

    @Override
    public Set<Map.Entry<String, ContextVariable<?>>> entrySet() {
        return this.variables.entrySet();
    }

    public KernelFunctionArguments copy() {
        return new KernelFunctionArguments(this.variables);
    }

    public static class Builder
    implements SemanticKernelBuilder<KernelFunctionArguments> {
        private final Map<String, ContextVariable<?>> variables = new HashMap();

        public <T> Builder withInput(ContextVariable<T> content) {
            return this.withVariable(KernelFunctionArguments.MAIN_KEY, content);
        }

        public Builder withInput(Object content) {
            return this.withInput(ContextVariable.ofGlobalType(content));
        }

        public <T> Builder withInput(T content, ContextVariableTypeConverter<T> typeConverter) {
            return this.withInput(new ContextVariable<T>(new ContextVariableType<T>(typeConverter, typeConverter.getType()), content));
        }

        public Builder withVariables(@Nullable Map<String, ContextVariable<?>> map) {
            if (map == null) {
                return this;
            }
            this.variables.putAll(map);
            return this;
        }

        public <T> Builder withVariable(String key, ContextVariable<T> value) {
            this.variables.put(key, value);
            return this;
        }

        public Builder withVariable(String key, Object value) {
            if (value instanceof ContextVariable) {
                return this.withVariable(key, (ContextVariable)value);
            }
            return this.withVariable(key, ContextVariable.ofGlobalType(value));
        }

        public <T> Builder withVariable(String key, T value, ContextVariableTypeConverter<T> typeConverter) {
            return this.withVariable(key, new ContextVariable<T>(new ContextVariableType<T>(typeConverter, typeConverter.getType()), value));
        }

        @Override
        public KernelFunctionArguments build() {
            return new KernelFunctionArguments(this.variables);
        }
    }
}

