/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.data.vectorstorage.options;

import com.microsoft.semantickernel.builders.SemanticKernelBuilder;
import com.microsoft.semantickernel.data.vectorsearch.VectorSearchFilter;
import javax.annotation.Nullable;

public class VectorSearchOptions {
    public static final int DEFAULT_TOP = 3;
    @Nullable
    private final VectorSearchFilter vectorSearchFilter;
    @Nullable
    private final String vectorFieldName;
    private final int top;
    private final int skip;
    private final boolean includeVectors;
    private final boolean includeTotalCount;

    public static VectorSearchOptions createDefault(String vectorFieldName) {
        return VectorSearchOptions.builder().withVectorFieldName(vectorFieldName).build();
    }

    public VectorSearchOptions(VectorSearchFilter vectorSearchFilter, String vectorFieldName, int top, int skip, boolean includeVectors, boolean includeTotalCount) {
        this.vectorSearchFilter = vectorSearchFilter;
        this.vectorFieldName = vectorFieldName;
        this.top = Math.max(1, top);
        this.skip = Math.max(0, skip);
        this.includeVectors = includeVectors;
        this.includeTotalCount = includeTotalCount;
    }

    @Nullable
    public VectorSearchFilter getVectorSearchFilter() {
        return this.vectorSearchFilter;
    }

    @Nullable
    public String getVectorFieldName() {
        return this.vectorFieldName;
    }

    public int getTop() {
        return this.top;
    }

    public int getSkip() {
        return this.skip;
    }

    public boolean isIncludeVectors() {
        return this.includeVectors;
    }

    public boolean isIncludeTotalCount() {
        return this.includeTotalCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements SemanticKernelBuilder<VectorSearchOptions> {
        private VectorSearchFilter vectorSearchFilter;
        private String vectorFieldName;
        private int top = 3;
        private int skip = 0;
        private boolean includeVectors = false;
        private boolean includeTotalCount = false;

        public Builder withVectorSearchFilter(VectorSearchFilter vectorSearchFilter) {
            this.vectorSearchFilter = vectorSearchFilter;
            return this;
        }

        public Builder withVectorFieldName(String vectorFieldName) {
            this.vectorFieldName = vectorFieldName;
            return this;
        }

        public Builder withTop(int top) {
            this.top = top;
            return this;
        }

        public Builder withSkip(int skip) {
            this.skip = skip;
            return this;
        }

        public Builder withIncludeVectors(boolean includeVectors) {
            this.includeVectors = includeVectors;
            return this;
        }

        public Builder withIncludeTotalCount(boolean includeTotalCount) {
            this.includeTotalCount = includeTotalCount;
            return this;
        }

        @Override
        public VectorSearchOptions build() {
            return new VectorSearchOptions(this.vectorSearchFilter, this.vectorFieldName, this.top, this.skip, this.includeVectors, this.includeTotalCount);
        }
    }
}

